#include "osl/move_generator/safeDropMajorPiece.h"
#include "osl/move_action/store.h"
#include "osl/record/csaString.h"
#include "osl/record/csaRecord.h"
#include "osl/move.h"
#include "osl/container/moveVector.h"
#include "osl/state/numEffectState.h"

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>

#include <iostream>

using namespace osl;
using namespace osl::move_action;
using namespace osl::move_generator;

class SafeDropMajorPieceTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(SafeDropMajorPieceTest);
  CPPUNIT_TEST(testSafeMajorPieceRookBlack);
  CPPUNIT_TEST(testSafeMajorPieceRookWhite);
  CPPUNIT_TEST(testSafeMajorPieceBishopBlack);
  CPPUNIT_TEST(testSafeMajorPieceBishopWhite);
  CPPUNIT_TEST_SUITE_END();
public:
  void testSafeMajorPieceRookBlack()
  {
    SimpleState sstate=CsaString(
      "P1 *  *  *  *  *  *  *  * -OU\n"
      "P2 *  *  *  *  *  *  *  *  * \n"
      "P3 *  *  *  *  *  *  *  *  * \n"
      "P4 *  *  *  *  *  *  *  *  * \n"
      "P5 *  *  *  *  *  *  *  *  * \n"
      "P6 *  *  *  *  *  *  *  *  * \n"
      "P7 *  *  *  *  *  *  *  *  * \n"
      "P8 * +OU *  *  *  *  *  *  * \n"
      "P9 *  *  *  *  *  *  *  *  * \n"
      "P+00HI\n"
      "P-00AL\n"
      "-\n").getInitialState();
    NumEffectState state(sstate);
    {
      MoveVector moves;
      {
	Store store(moves);
	SafeDropMajorPiece<BLACK>::generate<>(state, store);
      }
      CPPUNIT_ASSERT(23u == moves.size());

      for (size_t i = 0; i < moves.size(); i++)
      {
	CPPUNIT_ASSERT(moves[i].ptype() == ROOK);
	CPPUNIT_ASSERT(moves[i].from().isPieceStand());
	CPPUNIT_ASSERT(moves[i].to().y() <= 3);
	CPPUNIT_ASSERT(!state.hasEffectBy(alt(state.getTurn()),
					 moves[i].to()));
      }
    }
  }

  void testSafeMajorPieceRookWhite()
  {
    SimpleState sstate=CsaString(
      "P1 *  *  *  *  *  *  *  * -OU\n"
      "P2 *  *  *  *  *  *  *  *  * \n"
      "P3 *  *  *  *  *  *  *  *  * \n"
      "P4 *  *  *  *  *  *  *  *  * \n"
      "P5 *  *  *  *  *  *  *  *  * \n"
      "P6 *  *  *  *  *  *  *  *  * \n"
      "P7 *  *  *  *  *  *  *  *  * \n"
      "P8 * +OU *  *  *  *  *  *  * \n"
      "P9 *  *  *  *  *  *  *  *  * \n"
      "P-00HI\n"
      "P+00AL\n"
      "-\n").getInitialState();
    NumEffectState state(sstate);
    {
      MoveVector moves;
      {
	Store store(moves);
	SafeDropMajorPiece<WHITE>::generate<>(state, store);
      }
      CPPUNIT_ASSERT(18u == moves.size());
      for (size_t i = 0; i < moves.size(); i++)
      {
	CPPUNIT_ASSERT(moves[i].ptype() == ROOK);
	CPPUNIT_ASSERT(moves[i].from().isPieceStand());
	CPPUNIT_ASSERT(moves[i].to().y() >= 7);
	CPPUNIT_ASSERT(!state.hasEffectBy(alt(state.getTurn()),
					 moves[i].to()));
      }
    }
  }

  void testSafeMajorPieceBishopBlack()
  {
    SimpleState sstate=CsaString(
      "P1 *  *  *  *  *  *  *  * -OU\n"
      "P2 *  *  *  *  *  *  *  *  * \n"
      "P3 *  *  *  *  *  *  *  *  * \n"
      "P4 *  *  *  *  *  *  *  *  * \n"
      "P5 *  *  *  *  *  *  *  *  * \n"
      "P6 *  *  *  *  *  *  *  *  * \n"
      "P7 *  *  *  *  *  *  *  *  * \n"
      "P8 * +OU *  *  *  *  *  *  * \n"
      "P9 *  *  *  *  *  *  *  *  * \n"
      "P+00KA\n"
      "P-00AL\n"
      "-\n").getInitialState();
    NumEffectState state(sstate);
    {
      MoveVector moves;
      {
	Store store(moves);
	SafeDropMajorPiece<BLACK>::generate<>(state, store);
      }
      CPPUNIT_ASSERT(23u == moves.size());
      for (size_t i = 0; i < moves.size(); i++)
      {
	CPPUNIT_ASSERT(moves[i].ptype() == BISHOP);
	CPPUNIT_ASSERT(moves[i].from().isPieceStand());
	CPPUNIT_ASSERT(moves[i].to().y() <= 3);
	CPPUNIT_ASSERT(!state.hasEffectBy(alt(state.getTurn()),
					 moves[i].to()));
      }
    }
  }

  void testSafeMajorPieceBishopWhite()
  {
    SimpleState sstate=CsaString(
      "P1 *  *  *  *  *  *  *  * -OU\n"
      "P2 *  *  *  *  *  *  *  *  * \n"
      "P3 *  *  *  *  *  *  *  *  * \n"
      "P4 *  *  *  *  *  *  *  *  * \n"
      "P5 *  *  *  *  *  *  *  *  * \n"
      "P6 *  *  *  *  *  *  *  *  * \n"
      "P7 *  *  *  *  *  *  *  *  * \n"
      "P8 * +OU *  *  *  *  *  *  * \n"
      "P9 *  *  *  *  *  *  *  *  * \n"
      "P-00KA\n"
      "P+00AL\n"
      "-\n").getInitialState();
    NumEffectState state(sstate);
    {
      MoveVector moves;
      {
	Store store(moves);
	SafeDropMajorPiece<WHITE>::generate<>(state, store);
      }
      CPPUNIT_ASSERT(18u == moves.size());
      for (size_t i = 0; i < moves.size(); i++)
      {
	CPPUNIT_ASSERT(moves[i].ptype() == BISHOP);
	CPPUNIT_ASSERT(moves[i].from().isPieceStand());
	CPPUNIT_ASSERT(moves[i].to().y() >= 7);
	CPPUNIT_ASSERT(!state.hasEffectBy(alt(state.getTurn()),
					 moves[i].to()));
      }
    }
  }


};

CPPUNIT_TEST_SUITE_REGISTRATION(SafeDropMajorPieceTest);

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
