/* additionalLance.cc
 */
#include "osl/move_generator/additionalLance.h"
#include "osl/container/moveVector.h"


template <osl::Player P>
void osl::move_generator::AdditionalLance<P>::
generate(const NumEffectState& state, Position pawn, MoveVector& out)
{
  assert((state.hasPieceOnStand<LANCE>(P)));
  assert(state.getPieceOnBoard(pawn).ptype() == PAWN);
  Position back_position = pawn + DirectionPlayerTraits<D,P>::offset();
  Piece target = state.getPieceAt(back_position);
  while (target.isEmpty())
  {
    if (state.hasEffectBy<PlayerTraits<P>::opponent>(back_position))
      break;
    out.push_back(Move(back_position, LANCE, P));
	  
    back_position = back_position + DirectionPlayerTraits<D,P>::offset();
    target = state.getPieceAt(back_position);
  }     
}

template <osl::Player P>
void osl::move_generator::AdditionalLance<P>::
generateIfHasLance(const NumEffectState& state, Position pawn, 
		   MoveVector& out)
{
  if (state.hasPieceOnStand<LANCE>(P))
    generate(state, pawn, out);
}
namespace osl
{
  namespace move_generator
  {
    template class AdditionalLance<BLACK>;
    template class AdditionalLance<WHITE>;
  }
}

/* ------------------------------------------------------------------------- */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
