/* trapRook.cc
 */
#include "osl/move_classifier/trapRook.h"


template <osl::Player P>
template <osl::Direction Dir>
bool osl::move_classifier::
TrapRook<P>::testDirection(const NumEffectState& state, Position initial)
{
  const Player Opponent = PlayerTraits<P>::opponent;
  for (Position p=initial+DirectionPlayerTraits<Dir,P>::offset();; 
       p+=DirectionPlayerTraits<Dir,P>::offset())
  {
    const Piece focus = state.getPieceAt(p);
    if (! focus.canMoveOn<Opponent>())
      break;

    if (! state.hasEffectBy<P>(p))
      return false;
    if (focus.isOnBoardByOwner<P>())
      return true;
    assert(focus.isEmpty());
  }
  return true;
}


template <osl::Player P>
bool osl::move_classifier::
TrapRook<P>::isMember(const NumEffectState& state, 
		      Ptype ptype,Position from,Position to)
{
  // 横に行けない、縦に成れない、飛車の一つ後ろに利きがある
  // とりあえず歩で封じるものだけ
  if (ptype != PAWN)
    return false;
  if (! from.isPieceStand())
    return false;
  if (! state.hasEffectBy<P>(to))
    return false;
  const Position back_position = to + DirectionPlayerTraits<D,P>::offset();
  const Piece rook = state.getPieceAt(back_position);
  if (rook.ptypeO() != newPtypeO(alt(P), ROOK))
    return false;  
  if (! testDirection<R>(state, back_position))
    return false;
  if (! testDirection<L>(state, back_position))
    return false;

  const Player Opponent = PlayerTraits<P>::opponent;
  for (Position p=back_position+DirectionPlayerTraits<D,P>::offset();;
       p+=DirectionPlayerTraits<D,P>::offset())
  {
    const Piece focus = state.getPieceAt(p);
    if (! focus.canMoveOn<Opponent>())
      break;

    if (focus.isOnBoardByOwner<P>())
      return state.hasEffectBy<P>(p);
    assert(focus.isEmpty());
    if (state.hasEffectBy<P>(p))
      continue;
    if (p.canPromote<Opponent>())
      return false;
  }
  return true;
}
namespace osl
{
  namespace move_classifier
  {
    template class TrapRook<BLACK>;
    template class TrapRook<WHITE>;
  }
} // namespace osl

/* ------------------------------------------------------------------------- */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
