/* fastCopier.cc
 */
#include "osl/misc/fastCopier.h"
#include "osl/effect/numSimpleEffect.h"
#include "osl/state/numEffectState.h"
using namespace osl::effect;
typedef long long v2di __attribute__ ((vector_size (16)));

inline void osl::misc::FastCopier::copy(NumSimpleEffectTable *dst, const NumSimpleEffectTable *src){
  dst->effected_mask = src->effected_mask;
  dst->mobilityTable = src->mobilityTable;

#if defined(i386) || defined(__x86_64)
  {  
    v2di en0=*((v2di*)&(*src).effectedNumTable[0]);
    v2di en2=*((v2di*)&(*src).effectedNumTable[2]);
    v2di en4=*((v2di*)&(*src).effectedNumTable[4]);
    v2di en6=*((v2di*)&(*src).effectedNumTable[6]);
    v2di en8=*((v2di*)&(*src).effectedNumTable[8]);
    v2di en10=*((v2di*)&(*src).effectedNumTable[10]);
    v2di en12=*((v2di*)&(*src).effectedNumTable[12]);
    v2di en14=*((v2di*)&(*src).effectedNumTable[14]);
    v2di en16=*((v2di*)&(*src).effectedNumTable[16]);
    v2di en18=*((v2di*)&(*src).effectedNumTable[18]);

    *((v2di*)&(*dst).effectedNumTable[0])=en0;
    *((v2di*)&(*dst).effectedNumTable[2])=en2;
    *((v2di*)&(*dst).effectedNumTable[4])=en4;
    *((v2di*)&(*dst).effectedNumTable[6])=en6;
    *((v2di*)&(*dst).effectedNumTable[8])=en8;
    *((v2di*)&(*dst).effectedNumTable[10])=en10;
    *((v2di*)&(*dst).effectedNumTable[12])=en12;
    *((v2di*)&(*dst).effectedNumTable[14])=en14;
    *((v2di*)&(*dst).effectedNumTable[16])=en16;
    *((v2di*)&(*dst).effectedNumTable[18])=en18;

    v2di en20=*((v2di*)&(*src).effectedNumTable[20]);
    v2di en22=*((v2di*)&(*src).effectedNumTable[22]);
    v2di en24=*((v2di*)&(*src).effectedNumTable[24]);
    v2di en26=*((v2di*)&(*src).effectedNumTable[26]);
    v2di en28=*((v2di*)&(*src).effectedNumTable[28]);
    v2di en30=*((v2di*)&(*src).effectedNumTable[30]);
    v2di en32=*((v2di*)&(*src).effectedNumTable[32]);
    v2di en34=*((v2di*)&(*src).effectedNumTable[34]);
    v2di en36=*((v2di*)&(*src).effectedNumTable[36]);
    v2di en38=*((v2di*)&(*src).effectedNumTable[38]);

    *((v2di*)&(*dst).effectedNumTable[20])=en20;
    *((v2di*)&(*dst).effectedNumTable[22])=en22;
    *((v2di*)&(*dst).effectedNumTable[24])=en24;
    *((v2di*)&(*dst).effectedNumTable[26])=en26;
    *((v2di*)&(*dst).effectedNumTable[28])=en28;
    *((v2di*)&(*dst).effectedNumTable[30])=en30;
    *((v2di*)&(*dst).effectedNumTable[32])=en32;
    *((v2di*)&(*dst).effectedNumTable[34])=en34;
    *((v2di*)&(*dst).effectedNumTable[36])=en36;
    *((v2di*)&(*dst).effectedNumTable[38])=en38;
  }
#else
  for(int i=0;i<40;i++)
    (*dst).effectedNumTable[i]=(*src).effectNumTable[i];
#endif

#if defined(i386) || defined(__x86_64)
  {  
    v2di e18=*((v2di*)&(*src).effects[18]);
    v2di e20=*((v2di*)&(*src).effects[20]);
    v2di e22=*((v2di*)&(*src).effects[22]);
    v2di e24=*((v2di*)&(*src).effects[24]);
    v2di e26=*((v2di*)&(*src).effects[26]);

    v2di e34=*((v2di*)&(*src).effects[34]);
    v2di e36=*((v2di*)&(*src).effects[36]);
    v2di e38=*((v2di*)&(*src).effects[38]);
    v2di e40=*((v2di*)&(*src).effects[40]);
    v2di e42=*((v2di*)&(*src).effects[42]);

    *((v2di*)&(*dst).effects[18])=e18;
    *((v2di*)&(*dst).effects[20])=e20;
    *((v2di*)&(*dst).effects[22])=e22;
    *((v2di*)&(*dst).effects[24])=e24;
    *((v2di*)&(*dst).effects[26])=e26;

    *((v2di*)&(*dst).effects[34])=e34;
    *((v2di*)&(*dst).effects[36])=e36;
    *((v2di*)&(*dst).effects[38])=e38;
    *((v2di*)&(*dst).effects[40])=e40;
    *((v2di*)&(*dst).effects[42])=e42;

    v2di e50=*((v2di*)&(*src).effects[50]);
    v2di e52=*((v2di*)&(*src).effects[52]);
    v2di e54=*((v2di*)&(*src).effects[54]);
    v2di e56=*((v2di*)&(*src).effects[56]);
    v2di e58=*((v2di*)&(*src).effects[58]);

    v2di e66=*((v2di*)&(*src).effects[66]);
    v2di e68=*((v2di*)&(*src).effects[68]);
    v2di e70=*((v2di*)&(*src).effects[70]);
    v2di e72=*((v2di*)&(*src).effects[72]);
    v2di e74=*((v2di*)&(*src).effects[74]);

    *((v2di*)&(*dst).effects[50])=e50;
    *((v2di*)&(*dst).effects[52])=e52;
    *((v2di*)&(*dst).effects[54])=e54;
    *((v2di*)&(*dst).effects[56])=e56;
    *((v2di*)&(*dst).effects[58])=e58;

    *((v2di*)&(*dst).effects[66])=e66;
    *((v2di*)&(*dst).effects[68])=e68;
    *((v2di*)&(*dst).effects[70])=e70;
    *((v2di*)&(*dst).effects[72])=e72;
    *((v2di*)&(*dst).effects[74])=e74;

    v2di e82=*((v2di*)&(*src).effects[82]);
    v2di e84=*((v2di*)&(*src).effects[84]);
    v2di e86=*((v2di*)&(*src).effects[86]);
    v2di e88=*((v2di*)&(*src).effects[88]);
    v2di e90=*((v2di*)&(*src).effects[90]);

    v2di e98=*((v2di*)&(*src).effects[98]);
    v2di e100=*((v2di*)&(*src).effects[100]);
    v2di e102=*((v2di*)&(*src).effects[102]);
    v2di e104=*((v2di*)&(*src).effects[104]);
    v2di e106=*((v2di*)&(*src).effects[106]);

    *((v2di*)&(*dst).effects[82])=e82;
    *((v2di*)&(*dst).effects[84])=e84;
    *((v2di*)&(*dst).effects[86])=e86;
    *((v2di*)&(*dst).effects[88])=e88;
    *((v2di*)&(*dst).effects[90])=e90;

    *((v2di*)&(*dst).effects[98])=e98;
    *((v2di*)&(*dst).effects[100])=e100;
    *((v2di*)&(*dst).effects[102])=e102;
    *((v2di*)&(*dst).effects[104])=e104;
    *((v2di*)&(*dst).effects[106])=e106;

    v2di e114=*((v2di*)&(*src).effects[114]);
    v2di e116=*((v2di*)&(*src).effects[116]);
    v2di e118=*((v2di*)&(*src).effects[118]);
    v2di e120=*((v2di*)&(*src).effects[120]);
    v2di e122=*((v2di*)&(*src).effects[122]);

    v2di e130=*((v2di*)&(*src).effects[130]);
    v2di e132=*((v2di*)&(*src).effects[132]);
    v2di e134=*((v2di*)&(*src).effects[134]);
    v2di e136=*((v2di*)&(*src).effects[136]);
    v2di e138=*((v2di*)&(*src).effects[138]);

    *((v2di*)&(*dst).effects[114])=e114;
    *((v2di*)&(*dst).effects[116])=e116;
    *((v2di*)&(*dst).effects[118])=e118;
    *((v2di*)&(*dst).effects[120])=e120;
    *((v2di*)&(*dst).effects[122])=e122;

    *((v2di*)&(*dst).effects[130])=e130;
    *((v2di*)&(*dst).effects[132])=e132;
    *((v2di*)&(*dst).effects[134])=e134;
    *((v2di*)&(*dst).effects[136])=e136;
    *((v2di*)&(*dst).effects[138])=e138;

    v2di e146=*((v2di*)&(*src).effects[146]);
    v2di e148=*((v2di*)&(*src).effects[148]);
    v2di e150=*((v2di*)&(*src).effects[150]);
    v2di e152=*((v2di*)&(*src).effects[152]);
    v2di e154=*((v2di*)&(*src).effects[154]);

    *((v2di*)&(*dst).effects[146])=e146;
    *((v2di*)&(*dst).effects[148])=e148;
    *((v2di*)&(*dst).effects[150])=e150;
    *((v2di*)&(*dst).effects[152])=e152;
    *((v2di*)&(*dst).effects[154])=e154;
  }
#else
  for(int x=1;x<=9;x++)
    for(int y=1;y<=9;y++)
      (*dst).effects[Position(x,y).index()]=(*src).effects[Position(x,y).index()];
#endif
}
void osl::misc::FastCopier::copy(NumEffectState *dst, const osl::state::NumEffectState *src){
  //  (*dst).used_mask=(*src).used_mask; // no need to copy
  (*dst).stand_mask=(*src).stand_mask;
#if defined(i386) || defined(__x86_64)
  {  
    v2di b16=*((v2di*)&(*src).board[16]);
    v2di b20=*((v2di*)&(*src).board[20]);
    v2di b24=*((v2di*)&(*src).board[24]);
    v2di b32=*((v2di*)&(*src).board[32]);
    v2di b36=*((v2di*)&(*src).board[36]);
    v2di b40=*((v2di*)&(*src).board[40]);
    v2di b48=*((v2di*)&(*src).board[48]);
    v2di b52=*((v2di*)&(*src).board[52]);
    v2di b56=*((v2di*)&(*src).board[56]);

    *((v2di*)&(*dst).board[16])=b16;
    *((v2di*)&(*dst).board[20])=b20;
    *((v2di*)&(*dst).board[24])=b24;
    *((v2di*)&(*dst).board[32])=b32;
    *((v2di*)&(*dst).board[36])=b36;
    *((v2di*)&(*dst).board[40])=b40;
    *((v2di*)&(*dst).board[48])=b48;
    *((v2di*)&(*dst).board[52])=b52;
    *((v2di*)&(*dst).board[56])=b56;


    v2di b64=*((v2di*)&(*src).board[64]);
    v2di b68=*((v2di*)&(*src).board[68]);
    v2di b72=*((v2di*)&(*src).board[72]);

    v2di b80=*((v2di*)&(*src).board[80]);
    v2di b84=*((v2di*)&(*src).board[84]);
    v2di b88=*((v2di*)&(*src).board[88]);

    v2di b96=*((v2di*)&(*src).board[96]);
    v2di b100=*((v2di*)&(*src).board[100]);
    v2di b104=*((v2di*)&(*src).board[104]);


    *((v2di*)&(*dst).board[64])=b64;
    *((v2di*)&(*dst).board[68])=b68;
    *((v2di*)&(*dst).board[72])=b72;

    *((v2di*)&(*dst).board[80])=b80;
    *((v2di*)&(*dst).board[84])=b84;
    *((v2di*)&(*dst).board[88])=b88;

    *((v2di*)&(*dst).board[96])=b96;
    *((v2di*)&(*dst).board[100])=b100;
    *((v2di*)&(*dst).board[104])=b104;

    v2di b112=*((v2di*)&(*src).board[112]);
    v2di b116=*((v2di*)&(*src).board[116]);
    v2di b120=*((v2di*)&(*src).board[120]);

    v2di b128=*((v2di*)&(*src).board[128]);
    v2di b132=*((v2di*)&(*src).board[132]);
    v2di b136=*((v2di*)&(*src).board[136]);

    v2di b144=*((v2di*)&(*src).board[144]);
    v2di b148=*((v2di*)&(*src).board[148]);
    v2di b152=*((v2di*)&(*src).board[152]);

    *((v2di*)&(*dst).board[112])=b112;
    *((v2di*)&(*dst).board[116])=b116;
    *((v2di*)&(*dst).board[120])=b120;

    *((v2di*)&(*dst).board[128])=b128;
    *((v2di*)&(*dst).board[132])=b132;
    *((v2di*)&(*dst).board[136])=b136;

    *((v2di*)&(*dst).board[144])=b144;
    *((v2di*)&(*dst).board[148])=b148;
    *((v2di*)&(*dst).board[152])=b152;

    v2di p0=*((v2di*)&(*src).pieces[0]);
    v2di p4=*((v2di*)&(*src).pieces[4]);
    v2di p8=*((v2di*)&(*src).pieces[8]);
    v2di p12=*((v2di*)&(*src).pieces[12]);
    v2di p16=*((v2di*)&(*src).pieces[16]);
    v2di p20=*((v2di*)&(*src).pieces[20]);
    v2di p24=*((v2di*)&(*src).pieces[24]);
    v2di p28=*((v2di*)&(*src).pieces[28]);
    v2di p32=*((v2di*)&(*src).pieces[32]);
    v2di p36=*((v2di*)&(*src).pieces[36]);
    *((v2di*)&(*dst).pieces[0])=p0;
    *((v2di*)&(*dst).pieces[4])=p4;
    *((v2di*)&(*dst).pieces[8])=p8;
    *((v2di*)&(*dst).pieces[12])=p12;
    *((v2di*)&(*dst).pieces[16])=p16;
    *((v2di*)&(*dst).pieces[20])=p20;
    *((v2di*)&(*dst).pieces[24])=p24;
    *((v2di*)&(*dst).pieces[28])=p28;
    *((v2di*)&(*dst).pieces[32])=p32;
    *((v2di*)&(*dst).pieces[36])=p36;
  }
#else
  for(int x=1;x<=9;x++)
    for(int y=1;y<=9;y++)
      (*dst).board[Position(x,y).index()]=(*src).board[Position(x,y).index()];
  (*dst).pieces=(*src).pieces;
#endif
  (*dst).pawnMask=(*src).pawnMask;
  dst->stand_count = src->stand_count;
  (*dst).turn=(*src).turn;
  copy(&((*dst).effects),&((*src).effects));
  (*dst).onBoardMask=(*src).onBoardMask;
  (*dst).promoted=(*src).promoted;
  (*dst).pin_or_open=(*src).pin_or_open;
  (*dst).king_mobility=(*src).king_mobility;
  (*dst).king8infos=(*src).king8infos;
}

