/* centering3x3.cc
 */
#include "osl/centering3x3.h"
#include "osl/position.h"

osl::Centering3x3::
Table::Table()
{
  centers.fill(Position::STAND());
  for (int y=1; y<=9; ++y)
  {
    for (int x=1; x<=9; ++x)
    {
      const Position src = Position(x,y);
      centers[src.index()] = adjustCenterNaive(src);
    }
  }
}

namespace
{
  int adjustCenterXY(int xy)
  {
    if (xy == 1)
      return xy+1;
    else if (xy == 9)
      return xy-1;
    return xy;
  }
} // anonymous namespace

const osl::Position osl::
Centering3x3::adjustCenterNaive(Position src)
{
  const int x = adjustCenterXY(src.x());
  const int y = adjustCenterXY(src.y());
  return Position(x, y);
}

/* ------------------------------------------------------------------------- */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
