/* recordStack.h
 */
#ifndef SEARCH_RECORDSTACK_H
#define SEARCH_RECORDSTACK_H

#include "osl/misc/fixedCapacityVector.h"
#include <cassert>
namespace osl
{
  namespace search
  {
    class SimpleHashRecord;
    /**
     * SimpleHashRecord** のstack. 
     * 先頭要素はrootを意味する。
     */
    class RecordStack
    {
      static const int SEARCH_DEPTH_MAX = 128;
      FixedCapacityVector<SimpleHashRecord**, SEARCH_DEPTH_MAX> data;
      CArray<SimpleHashRecord*, SEARCH_DEPTH_MAX> backup;
      SimpleHashRecord *root_record;
    public:
      RecordStack();
      RecordStack(const RecordStack&);
      void clear();
      void push(SimpleHashRecord **r) { assert(r); data.push_back(r); }
      void pop() { assert(size() > 1); data.pop_back(); }

      SimpleHashRecord** lastRecordPtr(unsigned int n=0)
      {
	assert(size() > n);
 	return data[size()-1-n];
      }
      SimpleHashRecord* lastRecord(unsigned int n=0) const
      {
	assert(size() > n);
	return *data[size()-1-n];
      }

      size_t size() const { return data.size(); }
      bool empty() const { return data.empty(); }
      bool hasLastRecord(unsigned int n=0) const
      {
	return size() > n;
      }

      /** XXX */
      SimpleHashRecord** nextSeed() { return &backup[data.size()]; }
      void dump() const;
    };
  } // namespace search
} // namespace osl


#endif /* SEARCH_RECORDSTACK_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
