#ifndef _GENERATE_OPEN_KING_ROAD_H
#define _GENERATE_OPEN_KING_ROAD_H
#include "osl/move_generator/pieceOnBoard.h"

namespace osl
{
  namespace move_generator
  {
    /**
     * Moves pieces around the neighboring8 of the King.
     */
    template <Player P>
    struct OpenKingRoad
    {
      
      template <class Action>
      static void generateDir(const NumEffectState& state, Action& action, const Direction& dir)
      {
	Position pos = state.getKingPosition<P>()
	  + Board_Table.getOffset<P>(dir);
	if (pos.isEdge()) return;

	Piece piece = state.getPieceOnBoard(pos);
	if (piece != Piece::EMPTY() && piece.owner() == P)
	{
	  PieceOnBoard<Action>::template generate<P,false>(state, piece, action);
	}
      }
      
      template <class Action>
      static void generate(const NumEffectState& state, Action& action)
      {
	generateDir(state, action, UL);
	generateDir(state, action, U);
	generateDir(state, action, UR);
	generateDir(state, action, L);
	generateDir(state, action, R);
	generateDir(state, action, DL);
	generateDir(state, action, D);
	generateDir(state, action, DR);
      }
    };
  }
} // namespace osl

#endif /* _GENERATE_OPEN_KING_ROAD_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
