/* escapeFilter.h
 */
#ifndef OSL_ESCAPE_FILTER_H
#define OSL_ESCAPE_FILTER_H

#include "osl/player.h"
#include "osl/move_action/concept.h"
#include "osl/eval/pieceEval.h"

namespace osl
{
  namespace move_action
  {
    /**
     * 利きのないまたは守りのあるところへ動くためのフィルタ
     */
    template<Player P,class OrigAction>
    class EscapeFilter
    {
      BOOST_CLASS_REQUIRE(OrigAction,osl::move_action,Concept);
      const NumEffectState& state;
      OrigAction & action;
      PieceMask attack_pin, defense_pin;
      Piece removed;
      Ptype attacking;
      int value, my_value;
      bool has_long, has_long_support;

      Piece findThreat(Position to) const
      {
	Piece attack = state.findCheapThreatNotBy(alt(P), to, state.pinOrOpen(alt(P))); // == pin
	if (! attack.isEmpty())
	  return attack;
	if (! has_long)
	  return Piece::EMPTY();
	const Direction d = Board_Table.getLongDirection<BLACK>(Offset32(to, removed.position()));
	if (!isLong(d))
	  return Piece::EMPTY();
	const int num=state.longEffectNumTable()[removed.number()][longToShort(d)];
	if (Piece::isEmptyNum(num))
	  return Piece::EMPTY();
	attack = state.getPieceOf(num);
	if (attack.owner()==alt(P))
	  return attack;
	return Piece::EMPTY();
      }
      template <bool IsSimple>
      bool suitable(Position to) const
      {
	const Piece attack = findThreat(to);
	if (attack.isEmpty())
	  return true;
	if (! IsSimple)
	{
	  const Ptype capture = state.getPieceAt(to).ptype();
	  if (capture != PTYPE_EMPTY)
	    if (eval::Ptype_Eval_Table.captureValue(newPtypeO(WHITE, capture)) >= my_value)
	      return true;
	}
	if (eval::Ptype_Eval_Table.captureValue(newPtypeO(WHITE, attack.ptype())) <= value)
	  return false;
	const int attack_count = state.countEffect(alt(P), to, attack_pin); // rough estimation
	const int defense_count = state.countEffect(P, to, defense_pin);
	if (defense_count > attack_count)
	  return true;
	if (defense_count < attack_count)
	  return false;
	if (! has_long_support)
	  return false;
	const Direction d = Board_Table.getLongDirection<BLACK>(Offset32(to, removed.position()));
	if (!isLong(d))
	  return false;
	const int num=state.longEffectNumTable()[removed.number()][longToShort(d)];
	return ! Piece::isEmptyNum(num)
	  && state.getPieceOf(num).owner() == P;
      }
    public:
      EscapeFilter(const NumEffectState& s, OrigAction & action,Position pos, Ptype ptype)
	: state(s), action(action),
	  attack_pin(state.pin(alt(P))), defense_pin(state.pin(P)),
	  removed(state.getPieceAt(pos)), 
	  has_long(state.selectLong(pos, alt(P)).any()),
	  has_long_support(state.selectLong(pos, P).any())
      {
	assert(removed.isPiece());
	assert(removed.owner() == P);

	if (ptype == PTYPE_EMPTY)
	  ptype = state.findCheapThreatNotBy(alt(P), pos, state.pinOrOpen(alt(P))).ptype();
	attacking = ptype;
	value = eval::Ptype_Eval_Table.captureValue(newPtypeO(WHITE, ptype));
	my_value = eval::Ptype_Eval_Table.captureValue(newPtypeO(WHITE, removed.ptype()))
	  - eval::Ptype_Eval_Table.value(PAWN);
      }
      void simpleMove(Position from,Position to,Ptype ptype, bool isPromote,Player /* p */,Move m){
	if (suitable<true>(to))
	  action.simpleMove(from,to,ptype,isPromote,P,m);
      }
      void unknownMove(Position from,Position to,Piece p1,Ptype ptype,bool isPromote,Player /* p */,Move m){
	if (suitable<false>(to))
	  action.unknownMove(from,to,p1,ptype,isPromote,P,m);
      }
      void dropMove(Position to,Ptype ptype,Player /* p */,Move){
	assert(0);
      }
    
    };
      // old interfaces
      void simpleMove(Position from,Position to,Ptype ptype, 
		      bool isPromote,Player p)
      {
	simpleMove(from,to,ptype,isPromote,p,
		   Move(from,to,ptype,PTYPE_EMPTY,isPromote,p));
      }
      void unknownMove(Position from,Position to,Piece captured,
		       Ptype ptype,bool isPromote,Player p)
      {
	unknownMove(from,to,captured,ptype,isPromote,p,
		    Move(from,to,ptype,captured.ptype(),isPromote,p));
      }
      void dropMove(Position to,Ptype ptype,Player p)
      {
	dropMove(to,ptype,p,
		 Move(to,ptype,p));
      }
  } // namespace move_action
} // namespace osl


#endif /* _NO_EFFECT_FILTER_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; coding:utf-8
// ;;; End:
