/* sendOffPosition.h
 */
#ifndef OSL_SENDOFFPOSITION_H
#define OSL_SENDOFFPOSITION_H

#include "osl/state/numEffectState.h"
#include "osl/container/position8.h"
namespace osl
{
  namespace effect_util
  {
    struct Offset8 : public FixedCapacityVector<int,8>
    {
    };
    /** 送り金のような玉で取ると利きがはずれる駒が発生するマスを調査 */
    struct SendOffPosition
    {
      typedef uint8_t SendOff8;
      template <Player Attack>
      static bool onlyOneSupport(const NumEffectState& state, Position target)
      {
	const Piece p = state.getPieceAt(target);
	if (! p.isOnBoardByOwner<PlayerTraits<Attack>::opponent>())
	  return false;
	return state.hasEffectBy<Attack>(target) 
	  && (state.countEffect(alt(Attack), target) == 1);
      }
      template <Player Attack>
      static SendOff8 find(const NumEffectState& state, Position king_position,
			      Position8& out);
      static SendOff8 find(Player attack,
			      const NumEffectState& state, Position king_position,
			      Position8& out);
      static SendOff8 invalidData() { return 0xff; }
      static void unpack(SendOff8, Position king, Position8& out);
      struct Table
      {
	CArray<Offset,8> normal;
	CArray<Offset8,8> reverse;
	CArray<Offset8,256> reverse_all;
	Table();
      };
    private:
      static const Table table;
      template <Player Attack>
      static void testPosition(const NumEffectState& state, Position candidate,
			       int id, int& out)
      {
	if (onlyOneSupport<Attack>(state, candidate))
	{
	  out |= (1<<id);
	}
      }
    };
  } // namespace effect_util
  using effect_util::SendOffPosition;
} // namespace osl

#endif /* OSL_SENDOFFPOSITION_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; coding:utf-8
// ;;; End:
