/* neighboring8.h
 */
#ifndef EFFECT_UTIL_NEIGHBORING8EFFECT_H
#define EFFECT_UTIL_NEIGHBORING8EFFECT_H

#include "osl/state/numEffectState.h"
#include "osl/direction.h"

namespace osl
{
  namespace effect_util
  {
    /**
     * 8近傍への利きを判定する.
     * 間に 1枚までの駒があっても良い.
     */
    class Neighboring8Effect
    {
      class Table
      {
	struct Entry
	{
	  bool has_unblockable_effect;
	  Offset nearest;
	  Entry() : has_unblockable_effect(false), nearest(Offset::ZERO())
	  {
	  }
	};
	CArray2d<Entry,PTYPEO_SIZE,Offset32::SIZE> table;
	void init(Player);

	template <int maxCount>
	bool hasAtMaxPieceBetween(const NumEffectState& state,
				  Position from, Position target) const
	{
	  assert(from.isOnBoard());
	  Offset offset=Board_Table.getShortOffset(Offset32(target, from));
	  assert(! offset.zero());
	  int count = 0;
	  for (Position pos=from+offset; pos != target; pos+=offset)
	  {
	    if (!state.getPieceAt(pos).isEmpty())
	    {
	      count++;
	      if (count > maxCount) return false;
	    }
	  }
	  return true;
	}
	
      public:
	Table();

	bool hasEffect(const NumEffectState& state,
		       PtypeO ptypeo, Position from, 
		       Position target) const
	{
	  const Offset32 offset32 = Offset32(target, from);
	  const Entry& e = table[ptypeOIndex(ptypeo)][offset32.index()];
	  if (e.has_unblockable_effect)
	    return true;
	  if (e.nearest.zero())
	    return false;
	  assert(Ptype_Table.hasLongMove(getPtype(ptypeo)));
	  const Position nearest = from+e.nearest;
	  if (! nearest.isOnBoard())
	  {
	    return false;
	  }
	  return hasAtMaxPieceBetween<1>(state, from, nearest);
	}
      };
      static const Table table;
    public:
      /**
       * ptypeo の駒がfromからtargetの8近傍に利きを持つか
       */
      static bool hasEffect(const NumEffectState& state,
			    PtypeO ptypeo, Position from, 
			    Position target)
      {
	return table.hasEffect(state, ptypeo, from, target);
      }
    private:
      static bool hasEffectFromTo(const NumEffectState& state,
				  PtypeO ptypeo, Position from, 
				  Position target, Direction d);
    public:
      static bool hasEffectNaive(const NumEffectState& state,
				 PtypeO ptypeo, Position from, 
				 Position target);
    };

  } // namespace effect_util
  using effect_util::Neighboring8Effect;
} // namespace osl

#endif /* EFFECT_UTIL_NEIGHBORING8EFFECT_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
