require 'needle/container'

module Needle

  # This constant represents the collection of registered libraries. Each
  # value in it must respond to the #call method, accepting a single
  # parameter (the container to register the library with).
  LIBRARIES = Hash.new

  class Container

    # Require the library registered under the given name. A Kernel.require
    # is done on the name, and then if a library has been registered under
    # that name, its #call method is invoked with the container as the
    # parameter.
    def require_library( name )
      Kernel.require name
      LIBRARIES[ name ].call( self ) if LIBRARIES[ name ]
    end

  end

  # A convenience method for registering libraries with the "require-library"
  # subsystem. +name+ must correspond to a file to require with Kernel.require.
  # +mod+ is a module containing the registration method named by the
  # +registration_method+ parameter (defaulting to <tt>:register_library</tt>).
  def register_library( name, mod, registration_method=:register_services )
    LIBRARIES[ name ] = lambda do |container|
      mod.__send__( registration_method, container )
    end
  end
  module_function :register_library

end
