
#-----------------------------------------------------------------------------
# Options for HDF4 Filters
#-----------------------------------------------------------------------------

INCLUDE (ExternalProject)
OPTION (HDF4_ALLOW_EXTERNAL_SUPPORT "Allow External Library Building (NO SVN TGZ)" "NO")
IF (HDF4_ALLOW_EXTERNAL_SUPPORT MATCHES "SVN" OR HDF4_ALLOW_EXTERNAL_SUPPORT MATCHES "TGZ")
  OPTION (JPEG_USE_EXTERNAL "Use External Library Building for JPEG" 1)
  OPTION (ZLIB_USE_EXTERNAL "Use External Library Building for ZLIB" 1)
  OPTION (SZIP_USE_EXTERNAL "Use External Library Building for SZIP" 1)
  IF (HDF4_ALLOW_EXTERNAL_SUPPORT MATCHES "SVN")
    SET (JPEG_URL ${JPEG_SVN_URL})
    SET (ZLIB_URL ${ZLIB_SVN_URL})
    SET (SZIP_URL ${SZIP_SVN_URL})
  ELSEIF (HDF4_ALLOW_EXTERNAL_SUPPORT MATCHES "TGZ")
    IF (NOT TGZPATH)
      SET (TGZPATH ${HDF4_SOURCE_DIR})
    ENDIF (NOT TGZPATH)
    SET (JPEG_URL ${TGZPATH}/${JPEG_TGZ_NAME})
    SET (ZLIB_URL ${TGZPATH}/${ZLIB_TGZ_NAME})
    SET (SZIP_URL ${TGZPATH}/${SZIP_TGZ_NAME})
  ELSE (HDF4_ALLOW_EXTERNAL_SUPPORT MATCHES "SVN")
    SET (JPEG_USE_EXTERNAL 0)
    SET (ZLIB_USE_EXTERNAL 0)
    SET (SZIP_USE_EXTERNAL 0)
  ENDIF (HDF4_ALLOW_EXTERNAL_SUPPORT MATCHES "SVN")
ENDIF (HDF4_ALLOW_EXTERNAL_SUPPORT MATCHES "SVN" OR HDF4_ALLOW_EXTERNAL_SUPPORT MATCHES "TGZ")

#-----------------------------------------------------------------------------
# Option for LibJpeg support
#-----------------------------------------------------------------------------
OPTION (HDF4_ENABLE_JPEG_LIB_SUPPORT "Enable libjpeg" ON)
IF (HDF4_ENABLE_JPEG_LIB_SUPPORT)
  IF (NOT H4_JPEGLIB_HEADER)
    IF (NOT JPEG_USE_EXTERNAL)
      FIND_PACKAGE (JPEG NAMES ${JPEG_PACKAGE_NAME}${HDF_PACKAGE_EXT})
      IF (NOT JPEG_FOUND)
        FIND_PACKAGE (JPEG) # Legacy find
      ENDIF (NOT JPEG_FOUND)
    ENDIF (NOT JPEG_USE_EXTERNAL)
    IF (JPEG_FOUND)
      SET (H4_HAVE_JPEGLIB_H 1)
      SET (H4_HAVE_LIBJPEG 1)
      SET (H4_JPEGLIB_HEADER "jpeglib.h")
      SET (JPEG_INCLUDE_DIR_GEN ${JPEG_INCLUDE_DIR})
      SET (JPEG_INCLUDE_DIRS ${JPEG_INCLUDE_DIR})
    ELSE (JPEG_FOUND)
      IF (HDF4_ALLOW_EXTERNAL_SUPPORT MATCHES "SVN" OR HDF4_ALLOW_EXTERNAL_SUPPORT MATCHES "TGZ")
        # May need to build JPEG with PIC on x64 machines with gcc
        # Need to use CMAKE_ANSI_CFLAGS define so that compiler test works
        IF (BUILD_JPEG_WITH_PIC)
          SET (JPEG_CMAKE_C_FLAGS "-fPIC")
        ELSE (BUILD_JPEG_WITH_PIC)
          IF (DEFINED CMAKE_ANSI_CFLAGS)
            SET (JPEG_CMAKE_C_FLAGS ${CMAKE_ANSI_CFLAGS})
          ELSE (DEFINED CMAKE_ANSI_CFLAGS)
            SET (JPEG_CMAKE_C_FLAGS " ")
          ENDIF (DEFINED CMAKE_ANSI_CFLAGS)
        ENDIF (BUILD_JPEG_WITH_PIC)

        EXTERNAL_JPEG_LIBRARY (${HDF4_ALLOW_EXTERNAL_SUPPORT} ${LIB_TYPE} ${JPEG_CMAKE_C_FLAGS})
        SET (H4_HAVE_JPEGLIB_H 1)
        SET (H4_HAVE_LIBJPEG 1)
        SET (H4_JPEGLIB_HEADER "jpeglib.h")
        MESSAGE (STATUS "JPEGLIB is built")
      ELSE (HDF4_ALLOW_EXTERNAL_SUPPORT MATCHES "SVN" OR HDF4_ALLOW_EXTERNAL_SUPPORT MATCHES "TGZ")
        MESSAGE (FATAL_ERROR " JPEGLib is Required for JPEGLib support in HDF4")
      ENDIF (HDF4_ALLOW_EXTERNAL_SUPPORT MATCHES "SVN" OR HDF4_ALLOW_EXTERNAL_SUPPORT MATCHES "TGZ")
    ENDIF (JPEG_FOUND)
  ELSE (NOT H4_JPEGLIB_HEADER)
    # This project is being called from within another and JPEGLib is already configured
    SET (H4_HAVE_JPEGLIB_H 1)
  ENDIF (NOT H4_JPEGLIB_HEADER)
  SET (LINK_LIBS ${LINK_LIBS} ${JPEG_LIBRARY})
  INCLUDE_DIRECTORIES (${JPEG_INCLUDE_DIRS})
  MESSAGE (STATUS "JPEGLIB is ON")
ENDIF (HDF4_ENABLE_JPEG_LIB_SUPPORT)

#-----------------------------------------------------------------------------
# Option for ZLib support
#-----------------------------------------------------------------------------
OPTION (HDF4_ENABLE_Z_LIB_SUPPORT "Enable Zlib Filters" ON)
IF (HDF4_ENABLE_Z_LIB_SUPPORT)
  IF (NOT H4_ZLIB_HEADER)
    IF (NOT ZLIB_USE_EXTERNAL)
      FIND_PACKAGE (ZLIB NAMES ${ZLIB_PACKAGE_NAME}${HDF_PACKAGE_EXT})
      IF (NOT ZLIB_FOUND)
        FIND_PACKAGE (ZLIB) # Legacy find
      ENDIF (NOT ZLIB_FOUND)
    ENDIF (NOT ZLIB_USE_EXTERNAL)
    IF (ZLIB_FOUND)
      SET (H4_HAVE_FILTER_DEFLATE 1)
      SET (H4_HAVE_ZLIB_H 1)
      SET (H4_HAVE_LIBZ 1)
      SET (H4_ZLIB_HEADER "zlib.h")
      SET (ZLIB_INCLUDE_DIR_GEN ${ZLIB_INCLUDE_DIR})
      SET (ZLIB_INCLUDE_DIRS ${ZLIB_INCLUDE_DIR})
    ELSE (ZLIB_FOUND)
      IF (HDF4_ALLOW_EXTERNAL_SUPPORT MATCHES "SVN" OR HDF4_ALLOW_EXTERNAL_SUPPORT MATCHES "TGZ")
        EXTERNAL_ZLIB_LIBRARY (${HDF4_ALLOW_EXTERNAL_SUPPORT} ${LIB_TYPE})
        SET (H4_HAVE_FILTER_DEFLATE 1)
        SET (H4_HAVE_ZLIB_H 1)
        SET (H4_HAVE_LIBZ 1)
        MESSAGE (STATUS "Filter ZLIB is built")
      ELSE (HDF4_ALLOW_EXTERNAL_SUPPORT MATCHES "SVN" OR HDF4_ALLOW_EXTERNAL_SUPPORT MATCHES "TGZ")
        MESSAGE (FATAL_ERROR " ZLib is Required for ZLib support in HDF4")
      ENDIF (HDF4_ALLOW_EXTERNAL_SUPPORT MATCHES "SVN" OR HDF4_ALLOW_EXTERNAL_SUPPORT MATCHES "TGZ")
    ENDIF (ZLIB_FOUND)
  ELSE (NOT H4_ZLIB_HEADER)
    # This project is being called from within another and ZLib is already configured
    SET (H4_HAVE_FILTER_DEFLATE 1)
    SET (H4_HAVE_ZLIB_H 1)
    SET (H4_HAVE_LIBZ 1)
  ENDIF (NOT H4_ZLIB_HEADER)
  SET (LINK_LIBS ${LINK_LIBS} ${ZLIB_LIBRARIES})
  INCLUDE_DIRECTORIES (${ZLIB_INCLUDE_DIRS})
  MESSAGE (STATUS "Filter ZLIB is ON")
ENDIF (HDF4_ENABLE_Z_LIB_SUPPORT)

#-----------------------------------------------------------------------------
# Option for SzLib support
#-----------------------------------------------------------------------------
OPTION (HDF4_ENABLE_SZIP_SUPPORT "Use SZip Filter" OFF)
SET (SZIP_INFO "disabled")
IF (HDF4_ENABLE_SZIP_SUPPORT)
  OPTION (HDF4_ENABLE_SZIP_ENCODING "Use SZip Encoding" OFF)
  IF (NOT SZIP_USE_EXTERNAL)
    FIND_PACKAGE (SZIP NAMES ${SZIP_PACKAGE_NAME}${HDF_PACKAGE_EXT})
    IF (NOT SZIP_FOUND)
      FIND_PACKAGE (SZIP) # Legacy find
    ENDIF (NOT SZIP_FOUND)
  ENDIF (NOT SZIP_USE_EXTERNAL)
  IF (SZIP_FOUND)
    SET (H4_HAVE_FILTER_SZIP 1)
    SET (H4_HAVE_SZLIB_H 1)
    SET (H4_HAVE_LIBSZ 1)
    SET (SZIP_INCLUDE_DIR_GEN ${SZIP_INCLUDE_DIR})
    SET (SZIP_INCLUDE_DIRS ${SZIP_INCLUDE_DIR})
  ELSE (SZIP_FOUND)
    IF (HDF4_ALLOW_EXTERNAL_SUPPORT MATCHES "SVN" OR HDF4_ALLOW_EXTERNAL_SUPPORT MATCHES "TGZ")
      EXTERNAL_SZIP_LIBRARY (${HDF4_ALLOW_EXTERNAL_SUPPORT} ${LIB_TYPE} ${HDF4_ENABLE_SZIP_ENCODING})
      SET (H4_HAVE_FILTER_SZIP 1)
      SET (H4_HAVE_SZLIB_H 1)
      SET (H4_HAVE_LIBSZ 1)
      MESSAGE (STATUS "Filter SZIP is built")
    ELSE (HDF4_ALLOW_EXTERNAL_SUPPORT MATCHES "SVN" OR HDF4_ALLOW_EXTERNAL_SUPPORT MATCHES "TGZ")
      MESSAGE (FATAL_ERROR "SZIP is Required for SZIP support in HDF4")
    ENDIF (HDF4_ALLOW_EXTERNAL_SUPPORT MATCHES "SVN" OR HDF4_ALLOW_EXTERNAL_SUPPORT MATCHES "TGZ")
  ENDIF (SZIP_FOUND)
  SET (LINK_LIBS ${LINK_LIBS} ${SZIP_LIBRARIES})
  INCLUDE_DIRECTORIES (${SZIP_INCLUDE_DIRS})
  MESSAGE (STATUS "Filter SZIP is ON")
  IF (HDF4_ENABLE_SZIP_ENCODING)
    SET (H4_HAVE_SZIP_ENCODER 1)
    SET (SZIP_INFO "enabled with encoder")
  ELSE (HDF4_ENABLE_SZIP_ENCODING)
    SET (SZIP_INFO "enabled with decoder only")
  ENDIF (HDF4_ENABLE_SZIP_ENCODING)
ENDIF (HDF4_ENABLE_SZIP_SUPPORT)
