/**
 * @file libgalago-gtk/galago-gtk-presence-icon.h Presence Icon widget
 *
 * @Copyright (C) 2004-2006 Christian Hammond.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#ifndef _GALAGO_GTK_PRESENCE_ICON_H_
#define _GALAGO_GTK_PRESENCE_ICON_H_

typedef struct _GalagoGtkPresenceIcon      GalagoGtkPresenceIcon;
typedef struct _GalagoGtkPresenceIconClass GalagoGtkPresenceIconClass;
typedef struct _GalagoGtkPresenceIconPriv  GalagoGtkPresenceIconPriv;

#include <libgalago/galago.h>
#include <gtk/gtkimage.h>
#include <libgalago-gtk/galago-gtk-types.h>

#define GALAGO_GTK_TYPE_PRESENCE_ICON (galago_gtk_presence_icon_get_type())
#define GALAGO_GTK_PRESENCE_ICON(obj) \
		(G_TYPE_CHECK_INSTANCE_CAST((obj), GALAGO_GTK_TYPE_PRESENCE_ICON, GalagoGtkPresenceIcon))
#define GALAGO_GTK_PRESENCE_ICON_CLASS(klass) \
		(G_TYPE_CHECK_CLASS_CAST((klass), GALAGO_GTK_TYPE_PRESENCE_ICON, GalagoGtkPresenceIconClass))
#define GALAGO_GTK_IS_PRESENCE_ICON(obj) \
		(G_TYPE_CHECK_INSTANCE_TYPE((obj), GALAGO_GTK_TYPE_PRESENCE_ICON))
#define GALAGO_GTK_IS_PRESENCE_ICON_CLASS(klass) \
		(G_TYPE_CHECK_CLASS_TYPE((klass), GALAGO_GTK_TYPE_PRESENCE_ICON))
#define GALAGO_GTK_PRESENCE_ICON_GET_CLASS(obj) \
		(G_TYPE_INSTANCE_GET_CLASS ((obj), GALAGO_GTK_TYPE_PRESENCE_ICON, GalagoGtkPresenceIconClass))

struct _GalagoGtkPresenceIcon
{
	GtkImage parent_object;

	GalagoGtkPresenceIconPriv *priv;

	void (*gtk_reserved1)(void);
	void (*gtk_reserved2)(void);
	void (*gtk_reserved3)(void);
	void (*gtk_reserved4)(void);
};

struct _GalagoGtkPresenceIconClass
{
	GtkImageClass parent_class;

	void (*gtk_reserved1)(void);
	void (*gtk_reserved2)(void);
	void (*gtk_reserved3)(void);
	void (*gtk_reserved4)(void);
};

G_BEGIN_DECLS

GType galago_gtk_presence_icon_get_type(void);

GtkWidget *galago_gtk_presence_icon_new(void);

void galago_gtk_presence_icon_set_account(GalagoGtkPresenceIcon *icon,
										  GalagoAccount *account);
void galago_gtk_presence_icon_set_person(GalagoGtkPresenceIcon *icon,
										 GalagoPerson *person);
void galago_gtk_presence_icon_set_precedence(GalagoGtkPresenceIcon *icon,
											 GalagoGtkIconPrecedence precedence);
void galago_gtk_presence_icon_set_size(GalagoGtkPresenceIcon *icon,
									   GtkIconSize size);
void galago_gtk_presence_icon_update(GalagoGtkPresenceIcon *icon);

char *galago_gtk_presence_icon_get_tooltip_text(const GalagoGtkPresenceIcon *icon);

GalagoAccount *galago_gtk_presence_icon_get_account(const GalagoGtkPresenceIcon *icon);
GalagoPerson *galago_gtk_presence_icon_get_person(const GalagoGtkPresenceIcon *icon);
GalagoGtkIconPrecedence galago_gtk_presence_icon_get_precedence(const GalagoGtkPresenceIcon *icon);
GtkIconSize galago_gtk_presence_icon_get_size(const GalagoGtkPresenceIcon *icon);

G_END_DECLS

#endif /* _GALAGO_GTK_PRESENCE_ICON_H_ */
