/**
 * @file libgalago-gtk/galago-gtk-service-list.h
 *       Contact list widget
 *
 * @Copyright (C) 2005-2006 Christian Hammond.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#ifndef _GALAGO_GTK_CONTACT_LIST_H_
#define _GALAGO_GTK_CONTACT_LIST_H_

typedef struct _GalagoGtkContactList      GalagoGtkContactList;
typedef struct _GalagoGtkContactListClass GalagoGtkContactListClass;
typedef struct _GalagoGtkContactListPriv  GalagoGtkContactListPriv;

#include <libgalago/galago.h>
#include <gtk/gtktreeview.h>

#define GALAGO_GTK_TYPE_CONTACT_LIST (galago_gtk_contact_list_get_type())
#define GALAGO_GTK_CONTACT_LIST(obj) \
		(G_TYPE_CHECK_INSTANCE_CAST((obj), GALAGO_GTK_TYPE_CONTACT_LIST, GalagoGtkContactList))
#define GALAGO_GTK_CONTACT_LIST_CLASS(klass) \
		(G_TYPE_CHECK_CLASS_CAST((klass), GALAGO_GTK_TYPE_CONTACT_LIST, GalagoGtkContactListClass))
#define GALAGO_GTK_IS_CONTACT_LIST(obj) \
		(G_TYPE_CHECK_INSTANCE_TYPE((obj), GALAGO_GTK_TYPE_CONTACT_LIST))
#define GALAGO_GTK_IS_CONTACT_LIST_CLASS(klass) \
		(G_TYPE_CHECK_CLASS_TYPE((klass), GALAGO_GTK_TYPE_CONTACT_LIST))
#define GALAGO_GTK_CONTACT_LIST_GET_CLASS(obj) \
		(G_TYPE_INSTANCE_GET_CLASS ((obj), GALAGO_GTK_TYPE_CONTACT_LIST, GalagoGtkContactListClass))

struct _GalagoGtkContactList
{
	GtkTreeView parent_object;

	GalagoGtkContactListPriv *priv;

	void (*gtk_reserved1)(void);
	void (*gtk_reserved2)(void);
	void (*gtk_reserved3)(void);
	void (*gtk_reserved4)(void);
};

struct _GalagoGtkContactListClass
{
	GtkTreeViewClass parent_class;

	/* Signals */
	void (*selection_changed)(GalagoGtkContactList *contact_list);
	void (*contact_activated)(GalagoGtkContactList *contact_list,
							  GalagoAccount *contact);

	void (*gtk_reserved1)(void);
	void (*gtk_reserved2)(void);
	void (*gtk_reserved3)(void);
	void (*gtk_reserved4)(void);
};

G_BEGIN_DECLS

GType galago_gtk_contact_list_get_type(void);

GtkWidget *galago_gtk_contact_list_new(gboolean auto_populate);

void galago_gtk_contact_list_set_auto_populate(GalagoGtkContactList *list,
											   gboolean auto_populate);
void galago_gtk_contact_list_set_contact(GalagoGtkContactList *list,
										 GalagoAccount *account);
void galago_gtk_contact_list_set_service(GalagoGtkContactList *list,
										 GalagoService *service);
void galago_gtk_contact_list_set_person(GalagoGtkContactList *list,
										GalagoPerson *person);
void galago_gtk_contact_list_set_show_offline(GalagoGtkContactList *list,
											  gboolean show_offline);

void galago_gtk_contact_list_add_contact(GalagoGtkContactList *list,
										 GalagoAccount *contact);
void galago_gtk_contact_list_remove_contact(GalagoGtkContactList *list,
											GalagoAccount *contact);
void galago_gtk_contact_list_clear(GalagoGtkContactList *contact_list);

gboolean galago_gtk_contact_list_get_auto_populate(
	const GalagoGtkContactList *list);
GalagoAccount *galago_gtk_contact_list_get_contact(
	const GalagoGtkContactList *list);
GalagoService *galago_gtk_contact_list_get_service(
	const GalagoGtkContactList *list);
GalagoPerson *galago_gtk_contact_list_get_person(
	const GalagoGtkContactList *list);
gboolean galago_gtk_contact_list_get_show_offline(
	const GalagoGtkContactList *list);

G_END_DECLS

#endif /* _GALAGO_GTK_CONTACT_LIST_H */
