/* color.c generated by valac, the Vala compiler
 * generated from color.vala, do not modify */

/*
 * Extension to Gdk.Color which has support for an alpha channel.
 *
 * Copyright (C) 2008, 2009 Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Author : Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <float.h>
#include <math.h>


#define DESKTOP_AGNOSTIC_TYPE_COLOR (desktop_agnostic_color_get_type ())
#define DESKTOP_AGNOSTIC_COLOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_TYPE_COLOR, DesktopAgnosticColor))
#define DESKTOP_AGNOSTIC_COLOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_TYPE_COLOR, DesktopAgnosticColorClass))
#define DESKTOP_AGNOSTIC_IS_COLOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_TYPE_COLOR))
#define DESKTOP_AGNOSTIC_IS_COLOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_TYPE_COLOR))
#define DESKTOP_AGNOSTIC_COLOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_TYPE_COLOR, DesktopAgnosticColorClass))

typedef struct _DesktopAgnosticColor DesktopAgnosticColor;
typedef struct _DesktopAgnosticColorClass DesktopAgnosticColorClass;
typedef struct _DesktopAgnosticColorPrivate DesktopAgnosticColorPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

typedef enum  {
	DESKTOP_AGNOSTIC_COLOR_PARSE_ERROR_INVALID_INPUT,
	DESKTOP_AGNOSTIC_COLOR_PARSE_ERROR_INVALID_ALPHA
} DesktopAgnosticColorParseError;
#define DESKTOP_AGNOSTIC_COLOR_PARSE_ERROR desktop_agnostic_color_parse_error_quark ()
struct _DesktopAgnosticColor {
	GObject parent_instance;
	DesktopAgnosticColorPrivate * priv;
};

struct _DesktopAgnosticColorClass {
	GObjectClass parent_class;
};

struct _DesktopAgnosticColorPrivate {
	GdkColor _color;
	gushort _alpha;
};


static gpointer desktop_agnostic_color_parent_class = NULL;

GQuark desktop_agnostic_color_parse_error_quark (void);
GType desktop_agnostic_color_get_type (void);
#define DESKTOP_AGNOSTIC_COLOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DESKTOP_AGNOSTIC_TYPE_COLOR, DesktopAgnosticColorPrivate))
enum  {
	DESKTOP_AGNOSTIC_COLOR_DUMMY_PROPERTY,
	DESKTOP_AGNOSTIC_COLOR_COLOR,
	DESKTOP_AGNOSTIC_COLOR_RED,
	DESKTOP_AGNOSTIC_COLOR_GREEN,
	DESKTOP_AGNOSTIC_COLOR_BLUE,
	DESKTOP_AGNOSTIC_COLOR_ALPHA
};
#define DESKTOP_AGNOSTIC_COLOR_HTML_STRING "#%02hx%02hx%02hx%02hx"
#define DESKTOP_AGNOSTIC_COLOR_HTML_SCALE ((gushort) 256)
static gushort desktop_agnostic_color_ushortify (DesktopAgnosticColor* self, guint value, GError** error);
DesktopAgnosticColor* desktop_agnostic_color_new (GdkColor* color, gushort alpha);
DesktopAgnosticColor* desktop_agnostic_color_construct (GType object_type, GdkColor* color, gushort alpha);
DesktopAgnosticColor* desktop_agnostic_color_new_from_values (gushort red, gushort green, gushort blue, gushort alpha);
DesktopAgnosticColor* desktop_agnostic_color_construct_from_values (GType object_type, gushort red, gushort green, gushort blue, gushort alpha);
DesktopAgnosticColor* desktop_agnostic_color_new_from_string (const char* spec, GError** error);
DesktopAgnosticColor* desktop_agnostic_color_construct_from_string (GType object_type, const char* spec, GError** error);
guint desktop_agnostic_color_get_red (DesktopAgnosticColor* self);
guint desktop_agnostic_color_get_green (DesktopAgnosticColor* self);
guint desktop_agnostic_color_get_blue (DesktopAgnosticColor* self);
char* desktop_agnostic_color_to_html_color (DesktopAgnosticColor* self);
char* desktop_agnostic_color_to_string (DesktopAgnosticColor* self);
double desktop_agnostic_color_gdk_value_to_cairo (gushort value);
void desktop_agnostic_color_get_cairo_color (DesktopAgnosticColor* self, double* red, double* green, double* blue, double* alpha);
gushort desktop_agnostic_color_cairo_value_to_gdk (double value);
void desktop_agnostic_color_set_red (DesktopAgnosticColor* self, guint value);
void desktop_agnostic_color_set_green (DesktopAgnosticColor* self, guint value);
void desktop_agnostic_color_set_blue (DesktopAgnosticColor* self, guint value);
void desktop_agnostic_color_set_cairo_color (DesktopAgnosticColor* self, double red, double green, double blue, double alpha);
void desktop_agnostic_color_get_color (DesktopAgnosticColor* self, GdkColor* result);
void desktop_agnostic_color_set_color (DesktopAgnosticColor* self, GdkColor* value);
guint desktop_agnostic_color_get_alpha (DesktopAgnosticColor* self);
void desktop_agnostic_color_set_alpha (DesktopAgnosticColor* self, guint value);
static void desktop_agnostic_color_finalize (GObject* obj);
static void desktop_agnostic_color_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void desktop_agnostic_color_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



GQuark desktop_agnostic_color_parse_error_quark (void) {
	return g_quark_from_static_string ("desktop_agnostic_color_parse_error-quark");
}


static gushort desktop_agnostic_color_ushortify (DesktopAgnosticColor* self, guint value, GError** error) {
	gushort result;
	GError * _inner_error_;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, 0U);
	_inner_error_ = NULL;
	if (value < 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = value > G_MAXUSHORT;
	}
	if (_tmp0_) {
		_inner_error_ = g_error_new (DESKTOP_AGNOSTIC_COLOR_PARSE_ERROR, DESKTOP_AGNOSTIC_COLOR_PARSE_ERROR_INVALID_INPUT, "RGB values must be between 0 and %hu.", G_MAXUSHORT);
		{
			if (_inner_error_->domain == DESKTOP_AGNOSTIC_COLOR_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0U;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0U;
			}
		}
	}
	result = (gushort) value;
	return result;
}


DesktopAgnosticColor* desktop_agnostic_color_construct (GType object_type, GdkColor* color, gushort alpha) {
	DesktopAgnosticColor * self;
	self = (DesktopAgnosticColor*) g_object_new (object_type, NULL);
	self->priv->_color = *color;
	self->priv->_alpha = alpha;
	return self;
}


DesktopAgnosticColor* desktop_agnostic_color_new (GdkColor* color, gushort alpha) {
	return desktop_agnostic_color_construct (DESKTOP_AGNOSTIC_TYPE_COLOR, color, alpha);
}


DesktopAgnosticColor* desktop_agnostic_color_construct_from_values (GType object_type, gushort red, gushort green, gushort blue, gushort alpha) {
	DesktopAgnosticColor * self;
	GdkColor _tmp0_ = {0};
	self = (DesktopAgnosticColor*) g_object_new (object_type, NULL);
	self->priv->_color = (memset (&_tmp0_, 0, sizeof (GdkColor)), _tmp0_);
	self->priv->_color.red = (guint16) red;
	self->priv->_color.green = (guint16) green;
	self->priv->_color.blue = (guint16) blue;
	self->priv->_alpha = alpha;
	return self;
}


DesktopAgnosticColor* desktop_agnostic_color_new_from_values (gushort red, gushort green, gushort blue, gushort alpha) {
	return desktop_agnostic_color_construct_from_values (DESKTOP_AGNOSTIC_TYPE_COLOR, red, green, blue, alpha);
}


static char* string_substring (const char* self, glong offset, glong len) {
	char* result;
	glong string_length;
	const char* start;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = g_utf8_strlen (self, -1);
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	start = g_utf8_offset_to_pointer (self, offset);
	result = g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
	return result;
}


DesktopAgnosticColor* desktop_agnostic_color_construct_from_string (GType object_type, const char* spec, GError** error) {
	GError * _inner_error_;
	DesktopAgnosticColor * self;
	GdkColor _tmp0_ = {0};
	char* color_data;
	g_return_val_if_fail (spec != NULL, NULL);
	_inner_error_ = NULL;
	self = (DesktopAgnosticColor*) g_object_new (object_type, NULL);
	self->priv->_color = (memset (&_tmp0_, 0, sizeof (GdkColor)), _tmp0_);
	self->priv->_alpha = G_MAXUSHORT;
	color_data = NULL;
	if (g_utf8_get_char (spec) == '#') {
		gsize cd_len;
		const char* color_hex;
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		gsize hex_len;
		gsize offset;
		char* rgb_hex;
		const char* alpha_hex;
		char* _tmp5_;
		char* _tmp4_;
		char* _tmp3_;
		gboolean _tmp6_;
		gushort bits;
		char* _tmp7_;
		cd_len = (gsize) 0;
		color_hex = g_utf8_offset_to_pointer (spec, (glong) 1);
		cd_len = (gsize) strlen (color_hex);
		if ((cd_len % 4) != 0) {
			_tmp2_ = TRUE;
		} else {
			_tmp2_ = cd_len < 4;
		}
		if (_tmp2_) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = cd_len > 16;
		}
		if (_tmp1_) {
			_inner_error_ = g_error_new_literal (DESKTOP_AGNOSTIC_COLOR_PARSE_ERROR, DESKTOP_AGNOSTIC_COLOR_PARSE_ERROR_INVALID_INPUT, "Invalid input size.");
			{
				if (_inner_error_->domain == DESKTOP_AGNOSTIC_COLOR_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (color_data);
					g_object_unref (self);
					return NULL;
				} else {
					_g_free0 (color_data);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
		}
		hex_len = cd_len / 4;
		offset = hex_len * 3;
		rgb_hex = string_substring (color_hex, (glong) 0, (glong) offset);
		alpha_hex = g_utf8_offset_to_pointer (color_hex, (glong) offset);
		if ((_tmp6_ = sscanf (alpha_hex, _tmp5_ = g_strconcat (_tmp4_ = g_strconcat ("%", _tmp3_ = g_strdup_printf ("%zu", hex_len), NULL), "hx", NULL), &self->priv->_alpha) == 0, _g_free0 (_tmp5_), _g_free0 (_tmp4_), _g_free0 (_tmp3_), _tmp6_)) {
			_inner_error_ = g_error_new (DESKTOP_AGNOSTIC_COLOR_PARSE_ERROR, DESKTOP_AGNOSTIC_COLOR_PARSE_ERROR_INVALID_ALPHA, "Could not parse alpha section of input: %s", alpha_hex);
			{
				if (_inner_error_->domain == DESKTOP_AGNOSTIC_COLOR_PARSE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (rgb_hex);
					_g_free0 (color_data);
					g_object_unref (self);
					return NULL;
				} else {
					_g_free0 (rgb_hex);
					_g_free0 (color_data);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
		}
		bits = (gushort) cd_len;
		self->priv->_alpha = (gushort) (self->priv->_alpha << ((gushort) (16 - bits)));
		while (TRUE) {
			if (!(bits < 16)) {
				break;
			}
			self->priv->_alpha = self->priv->_alpha | (self->priv->_alpha >> bits);
			bits = (gushort) (bits * ((gushort) 2));
		}
		color_data = (_tmp7_ = g_strconcat ("#", rgb_hex, NULL), _g_free0 (color_data), _tmp7_);
		_g_free0 (rgb_hex);
	} else {
		char* _tmp8_;
		color_data = (_tmp8_ = g_strdup (spec), _g_free0 (color_data), _tmp8_);
	}
	if (!gdk_color_parse (color_data, &self->priv->_color)) {
		_inner_error_ = g_error_new (DESKTOP_AGNOSTIC_COLOR_PARSE_ERROR, DESKTOP_AGNOSTIC_COLOR_PARSE_ERROR_INVALID_INPUT, "Could not parse color string: %s", spec);
		{
			if (_inner_error_->domain == DESKTOP_AGNOSTIC_COLOR_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (color_data);
				g_object_unref (self);
				return NULL;
			} else {
				_g_free0 (color_data);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	_g_free0 (color_data);
	return self;
}


DesktopAgnosticColor* desktop_agnostic_color_new_from_string (const char* spec, GError** error) {
	return desktop_agnostic_color_construct_from_string (DESKTOP_AGNOSTIC_TYPE_COLOR, spec, error);
}


char* desktop_agnostic_color_to_html_color (DesktopAgnosticColor* self) {
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = g_strdup_printf (DESKTOP_AGNOSTIC_COLOR_HTML_STRING, desktop_agnostic_color_get_red (self) / DESKTOP_AGNOSTIC_COLOR_HTML_SCALE, desktop_agnostic_color_get_green (self) / DESKTOP_AGNOSTIC_COLOR_HTML_SCALE, desktop_agnostic_color_get_blue (self) / DESKTOP_AGNOSTIC_COLOR_HTML_SCALE, self->priv->_alpha / DESKTOP_AGNOSTIC_COLOR_HTML_SCALE);
	return result;
}


char* desktop_agnostic_color_to_string (DesktopAgnosticColor* self) {
	char* result;
	char* gdk_str;
	g_return_val_if_fail (self != NULL, NULL);
	gdk_str = gdk_color_to_string (&self->priv->_color);
	result = g_strdup_printf ("%s%04x", gdk_str, (guint) self->priv->_alpha);
	_g_free0 (gdk_str);
	return result;
}


void desktop_agnostic_color_get_cairo_color (DesktopAgnosticColor* self, double* red, double* green, double* blue, double* alpha) {
	g_return_if_fail (self != NULL);
	if ((red) != NULL) {
		*red = desktop_agnostic_color_gdk_value_to_cairo ((gushort) desktop_agnostic_color_get_red (self));
	}
	if ((green) != NULL) {
		*green = desktop_agnostic_color_gdk_value_to_cairo ((gushort) desktop_agnostic_color_get_green (self));
	}
	if ((blue) != NULL) {
		*blue = desktop_agnostic_color_gdk_value_to_cairo ((gushort) desktop_agnostic_color_get_blue (self));
	}
	if ((alpha) != NULL) {
		*alpha = desktop_agnostic_color_gdk_value_to_cairo (self->priv->_alpha);
	}
}


void desktop_agnostic_color_set_cairo_color (DesktopAgnosticColor* self, double red, double green, double blue, double alpha) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	if (red > 0.0f) {
		_tmp0_ = red <= 1.0f;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		desktop_agnostic_color_set_red (self, (guint) desktop_agnostic_color_cairo_value_to_gdk (red));
	}
	if (green > 0.0f) {
		_tmp1_ = green <= 1.0f;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		desktop_agnostic_color_set_green (self, (guint) desktop_agnostic_color_cairo_value_to_gdk (green));
	}
	if (blue > 0.0f) {
		_tmp2_ = blue <= 1.0f;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		desktop_agnostic_color_set_blue (self, (guint) desktop_agnostic_color_cairo_value_to_gdk (blue));
	}
	if (alpha > 0.0f) {
		_tmp3_ = alpha <= 1.0f;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		self->priv->_alpha = desktop_agnostic_color_cairo_value_to_gdk (alpha);
	}
}


gushort desktop_agnostic_color_cairo_value_to_gdk (double value) {
	gushort result;
	result = (gushort) (lround (value * 65536) - 1);
	return result;
}


double desktop_agnostic_color_gdk_value_to_cairo (gushort value) {
	double result;
	result = (value + 1) / 65536.0;
	return result;
}


void desktop_agnostic_color_get_color (DesktopAgnosticColor* self, GdkColor* result) {
	g_return_if_fail (self != NULL);
	*result = self->priv->_color;
	return;
}


void desktop_agnostic_color_set_color (DesktopAgnosticColor* self, GdkColor* value) {
	g_return_if_fail (self != NULL);
	self->priv->_color = *value;
	g_object_notify ((GObject *) self, "color");
}


guint desktop_agnostic_color_get_red (DesktopAgnosticColor* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = (guint) self->priv->_color.red;
	return result;
}


void desktop_agnostic_color_set_red (DesktopAgnosticColor* self, guint value) {
	GError * _inner_error_;
	gushort _tmp0_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	_tmp0_ = desktop_agnostic_color_ushortify (self, value, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	self->priv->_color.red = (guint16) _tmp0_;
	g_object_notify ((GObject *) self, "red");
}


guint desktop_agnostic_color_get_green (DesktopAgnosticColor* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = (guint) self->priv->_color.green;
	return result;
}


void desktop_agnostic_color_set_green (DesktopAgnosticColor* self, guint value) {
	GError * _inner_error_;
	gushort _tmp0_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	_tmp0_ = desktop_agnostic_color_ushortify (self, value, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	self->priv->_color.green = (guint16) _tmp0_;
	g_object_notify ((GObject *) self, "green");
}


guint desktop_agnostic_color_get_blue (DesktopAgnosticColor* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = (guint) self->priv->_color.blue;
	return result;
}


void desktop_agnostic_color_set_blue (DesktopAgnosticColor* self, guint value) {
	GError * _inner_error_;
	gushort _tmp0_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	_tmp0_ = desktop_agnostic_color_ushortify (self, value, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	self->priv->_color.blue = (guint16) _tmp0_;
	g_object_notify ((GObject *) self, "blue");
}


guint desktop_agnostic_color_get_alpha (DesktopAgnosticColor* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = (guint) self->priv->_alpha;
	return result;
}


void desktop_agnostic_color_set_alpha (DesktopAgnosticColor* self, guint value) {
	GError * _inner_error_;
	gushort _tmp0_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	_tmp0_ = desktop_agnostic_color_ushortify (self, value, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	self->priv->_alpha = _tmp0_;
	g_object_notify ((GObject *) self, "alpha");
}


static void desktop_agnostic_color_class_init (DesktopAgnosticColorClass * klass) {
	desktop_agnostic_color_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DesktopAgnosticColorPrivate));
	G_OBJECT_CLASS (klass)->get_property = desktop_agnostic_color_get_property;
	G_OBJECT_CLASS (klass)->set_property = desktop_agnostic_color_set_property;
	G_OBJECT_CLASS (klass)->finalize = desktop_agnostic_color_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_COLOR_COLOR, g_param_spec_boxed ("color", "color", "color", GDK_TYPE_COLOR, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_COLOR_RED, g_param_spec_uint ("red", "red", "red", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_COLOR_GREEN, g_param_spec_uint ("green", "green", "green", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_COLOR_BLUE, g_param_spec_uint ("blue", "blue", "blue", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_COLOR_ALPHA, g_param_spec_uint ("alpha", "alpha", "alpha", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void desktop_agnostic_color_instance_init (DesktopAgnosticColor * self) {
	self->priv = DESKTOP_AGNOSTIC_COLOR_GET_PRIVATE (self);
	self->priv->_alpha = G_MAXUSHORT;
}


static void desktop_agnostic_color_finalize (GObject* obj) {
	DesktopAgnosticColor * self;
	self = DESKTOP_AGNOSTIC_COLOR (obj);
	G_OBJECT_CLASS (desktop_agnostic_color_parent_class)->finalize (obj);
}


GType desktop_agnostic_color_get_type (void) {
	static GType desktop_agnostic_color_type_id = 0;
	if (desktop_agnostic_color_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DesktopAgnosticColorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) desktop_agnostic_color_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DesktopAgnosticColor), 0, (GInstanceInitFunc) desktop_agnostic_color_instance_init, NULL };
		desktop_agnostic_color_type_id = g_type_register_static (G_TYPE_OBJECT, "DesktopAgnosticColor", &g_define_type_info, 0);
	}
	return desktop_agnostic_color_type_id;
}


static void desktop_agnostic_color_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DesktopAgnosticColor * self;
	gpointer boxed;
	self = DESKTOP_AGNOSTIC_COLOR (object);
	switch (property_id) {
		case DESKTOP_AGNOSTIC_COLOR_COLOR:
		boxed = g_new0 (GdkColor, 1);
		desktop_agnostic_color_get_color (self, boxed);
		g_value_take_boxed (value, boxed);
		break;
		case DESKTOP_AGNOSTIC_COLOR_RED:
		g_value_set_uint (value, desktop_agnostic_color_get_red (self));
		break;
		case DESKTOP_AGNOSTIC_COLOR_GREEN:
		g_value_set_uint (value, desktop_agnostic_color_get_green (self));
		break;
		case DESKTOP_AGNOSTIC_COLOR_BLUE:
		g_value_set_uint (value, desktop_agnostic_color_get_blue (self));
		break;
		case DESKTOP_AGNOSTIC_COLOR_ALPHA:
		g_value_set_uint (value, desktop_agnostic_color_get_alpha (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void desktop_agnostic_color_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DesktopAgnosticColor * self;
	self = DESKTOP_AGNOSTIC_COLOR (object);
	switch (property_id) {
		case DESKTOP_AGNOSTIC_COLOR_COLOR:
		desktop_agnostic_color_set_color (self, g_value_get_boxed (value));
		break;
		case DESKTOP_AGNOSTIC_COLOR_RED:
		desktop_agnostic_color_set_red (self, g_value_get_uint (value));
		break;
		case DESKTOP_AGNOSTIC_COLOR_GREEN:
		desktop_agnostic_color_set_green (self, g_value_get_uint (value));
		break;
		case DESKTOP_AGNOSTIC_COLOR_BLUE:
		desktop_agnostic_color_set_blue (self, g_value_get_uint (value));
		break;
		case DESKTOP_AGNOSTIC_COLOR_ALPHA:
		desktop_agnostic_color_set_alpha (self, g_value_get_uint (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




