/******************************************************************
 *  $Id: ex3.c,v 1.1 2004/06/02 11:20:49 snowdrop Exp $
 *
 * CSOAP Project:  A SOAP client/server library in C
 * Copyright (C) 2003  Ferhat Ayaz
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 * 
 * Email: ayaz@jprogrammet.net
 ******************************************************************/


/* This header will be generated by xsd2c */
#include "Customer_xsd.h"

 /* For stdout writers */
#include "../utils.h"



int main(int argc, char *argv[])
{
  struct Customer* customer;   /* object created by xsd2c */

  /* Create both objects */
  customer = Customer_Create();


  /* Set some person data */
  Person_Set_attr_id(TO_PERSON(customer), "id0001");
  Person_Set_Name(TO_PERSON(customer), "John");
  Person_Set_Lastname(TO_PERSON(customer), "Smith");
  Person_Set_Degree(TO_PERSON(customer), 34);
  Person_Add_Project(TO_PERSON(customer), "csoap");
  Person_Add_Project(TO_PERSON(customer), "xsd2c");

  /* Set some customer data */
  Customer_Set_attr_pos(customer, "Designer");
  Customer_Set_JobID(customer, "J0091");
  Customer_Set_FirmaID(customer, "f890");

  /* Serialize the Customer object. 
    The 3 sax callback functions 
    will just print the data to stdout
  */
  Customer_Sax_Serialize(customer, "Friendship", 
    Writer_StartElement, 
    Writer_Characters,
    Writer_EndElement, 0);

  /* Free both objects */
  Customer_Free(customer);

	return 0;
}
