dnl Copyright (C) 2004 EDF
dnl
dnl This file is part of the BFT software package.  For license
dnl information, see the COPYING file in the top level directory of the
dnl BFT source distribution.

# BFT_AC_CONFIG_PUBL_INIT([OUPUT FILE NAME])
#-------------------------------------------
# Initialize file

AC_DEFUN([BFT_AC_CONFIG_PUBL_INIT],[

# First arg is output file name
if test "$1" = "" ; then
  bft_ac_config_publ_h="config_publ.h"
else
  bft_ac_config_publ_h=$1
fi
bft_ac_lower='abcdefghijklmnopqrstuvwxyz.'
bft_ac_upper='ABCDEFGHIJKLMNOPQRSTUVWXYZ_'
bft_ac_config_publ_upname=`echo $bft_ac_config_publ_h | sed y/$bft_ac_lower/$bft_ac_upper/`
unset bft_ac_lower
unset bft_ac_upper
echo "#ifndef __"${bft_ac_config_publ_upname}"__" >  "$bft_ac_config_publ_h"-tmp
echo "#define __"${bft_ac_config_publ_upname}"__" >> "$bft_ac_config_publ_h"-tmp
echo >> "$bft_ac_config_publ_h"-tmp
echo "/* $bft_ac_config_publ_h. Generated by configure */" >> "$bft_ac_config_publ_h"-tmp
echo >> "$bft_ac_config_publ_h"-tmp

AC_MSG_NOTICE([initializing $bft_ac_config_publ_h])
])dnl


# BFT_AC_CONFIG_PUBL_FINALIZE
#----------------------------
# Finalize file

AC_DEFUN([BFT_AC_CONFIG_PUBL_FINALIZE],[

AC_REQUIRE([BFT_AC_CONFIG_PUBL_INIT])dnl

echo "#endif /* __"${bft_ac_config_publ_upname}"__ */" >>  "$bft_ac_config_publ_h"-tmp

AC_MSG_NOTICE([closing $bft_ac_config_publ_h])

diff $bft_ac_config_publ_h $bft_ac_config_publ_h-tmp  > /dev/null 2>&1
if test $? -eq 0 ; then
  AC_MSG_NOTICE([$bft_ac_config_publ_h  is unchanged])
  rm -f $bft_ac_config_publ_h-tmp
else
  mv $bft_ac_config_publ_h-tmp $bft_ac_config_publ_h
fi

unset bft_ac_config_publ_h
unset bft_ac_config_publ_upname

])dnl


# BFT_AC_CONFIG_PUBL_VERBATIM([VERBATIM TEXT])
#---------------------------------------------
# Add text to config file

AC_DEFUN([BFT_AC_CONFIG_PUBL_VERBATIM],[

AC_REQUIRE([BFT_AC_CONFIG_PUBL_INIT])dnl

echo "$1" >> "$bft_ac_config_publ_h"-tmp
echo ""   >> "$bft_ac_config_publ_h"-tmp

])dnl


# BFT_AC_CONFIG_PUBL_DEFINE(VARIABLE NAME, VALUE, [COMMENT])
#-----------------------------------------------------------
# Define variable

AC_DEFUN([BFT_AC_CONFIG_PUBL_DEFINE],[

AC_REQUIRE([BFT_AC_CONFIG_PUBL_INIT])dnl

unset bft_ac_lower
unset bft_ac_upper
if test "$3" != "" ; then
  echo "/* $3 */" >> "$bft_ac_config_publ_h"-tmp
fi
echo "#define $1 $2" >> "$bft_ac_config_publ_h"-tmp
echo >> "$bft_ac_config_publ_h"-tmp

])dnl


# BFT_AC_CONFIG_PUBL_DEFINE_STRING(VARIABLE NAME, VALUE, [COMMENT])
#------------------------------------------------------------------
# Define string variable

AC_DEFUN([BFT_AC_CONFIG_PUBL_DEFINE_STRING],[

AC_REQUIRE([BFT_AC_CONFIG_PUBL_INIT])dnl

unset bft_ac_lower
unset bft_ac_upper
if test "$3" != "" ; then
  echo "/* $3 */" >> "$bft_ac_config_publ_h"-tmp
fi
echo '#define $1 "$2"' >> "$bft_ac_config_publ_h"-tmp
echo >> "$bft_ac_config_publ_h"-tmp

])dnl


# BFT_AC_CONFIG_PUBL_SET(VARIABLE NAME, YES OR NO, [COMMENT])
#------------------------------------------------------------
# Set variable (define to 1 if second arg is yes, undefine if no )

AC_DEFUN([BFT_AC_CONFIG_PUBL_SET],[

# First arg is variable name, second arg is value, optional third arg is comment

AC_REQUIRE([BFT_AC_CONFIG_PUBL_INIT])dnl

unset bft_ac_lower
unset bft_ac_upper
if test "$3" != "" ; then
  echo "/* $3 */" >> "$bft_ac_config_publ_h"-tmp
fi
if test "$2" = "yes" ; then
  echo "#define $1 1" >> "$bft_ac_config_publ_h"-tmp
else
  echo "#undef $1" >> "$bft_ac_config_publ_h"-tmp
fi
echo >> "$bft_ac_config_publ_h"-tmp

])dnl

