/**
 * SECTION:application
 * @short_description: Application entry
 * 
 * <para>Objects of this class contain information about an application (installed or not installed) and associated Listaller state data.</para>
 */
/**
 * LISTALLER_TYPE_APP_ITEM:
 * 
 * The type for <link linkend="ListallerAppItem"><type>ListallerAppItem</type></link>.
 */
/**
 * listaller_app_item_load_xml_file:
 * @self: the <link linkend="ListallerAppItem"><type>ListallerAppItem</type></link> instance
 * @asdata_fname: &nbsp;
 * @error: location to store the error occuring, or %NULL to ignore
 */
/**
 * listaller_app_item_load_xml_data:
 * @self: the <link linkend="ListallerAppItem"><type>ListallerAppItem</type></link> instance
 * @xmld: &nbsp;
 * @error: location to store the error occuring, or %NULL to ignore
 */
/**
 * listaller_app_item_set_origin_local:
 * @self: the <link linkend="ListallerAppItem"><type>ListallerAppItem</type></link> instance
 */
/**
 * listaller_app_item_to_string:
 * @self: the <link linkend="ListallerAppItem"><type>ListallerAppItem</type></link> instance
 */
/**
 * listaller_app_item_fast_check:
 * @self: the <link linkend="ListallerAppItem"><type>ListallerAppItem</type></link> instance
 */
/**
 * listaller_app_item_set_license_name:
 * @self: the <link linkend="ListallerAppItem"><type>ListallerAppItem</type></link> instance
 * @name: &nbsp;
 */
/**
 * listaller_app_item_set_license_text:
 * @self: the <link linkend="ListallerAppItem"><type>ListallerAppItem</type></link> instance
 * @lText: &nbsp;
 */
/**
 * listaller_app_item_update_with_appid:
 * @self: the <link linkend="ListallerAppItem"><type>ListallerAppItem</type></link> instance
 * @fast: &nbsp;
 */
/**
 * listaller_app_item_build_pk_package_id:
 * @self: the <link linkend="ListallerAppItem"><type>ListallerAppItem</type></link> instance
 * 
 * Generate a PackageKit package-id for this application
 */
/**
 * listaller_app_item_update_with_metadata_file:
 * @self: the <link linkend="ListallerAppItem"><type>ListallerAppItem</type></link> instance
 */
/**
 * listaller_app_item_get_raw_cmd:
 * @self: the <link linkend="ListallerAppItem"><type>ListallerAppItem</type></link> instance
 * @subst_cmd: &nbsp;
 */
/**
 * listaller_app_item_get_metadata_xml:
 * @self: the <link linkend="ListallerAppItem"><type>ListallerAppItem</type></link> instance
 */
/**
 * listaller_app_item_compare_version_with:
 * @self: the <link linkend="ListallerAppItem"><type>ListallerAppItem</type></link> instance
 * @bversion: &nbsp;
 */
/**
 * listaller_app_item_new:
 */
/**
 * listaller_app_item_new_from_id:
 * @application_id: &nbsp;
 */
/**
 * ListallerAppItem:unique-name:
 * 
 * Application identifier
 */
/**
 * listaller_app_item_get_unique_name:
 * @self: the <link linkend="ListallerAppItem"><type>ListallerAppItem</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="ListallerAppItem--unique-name"><type>"unique-name"</type></link> property.
 * 
 * Application identifier
 * 
 * Returns: the value of the <link linkend="ListallerAppItem--unique-name"><type>"unique-name"</type></link> property
 */
/**
 * listaller_app_item_set_unique_name:
 * @self: the <link linkend="ListallerAppItem"><type>ListallerAppItem</type></link> instance to modify
 * @value: the new value of the <link linkend="ListallerAppItem--unique-name"><type>"unique-name"</type></link> property
 * 
 * Set the value of the <link linkend="ListallerAppItem--unique-name"><type>"unique-name"</type></link> property to @value.
 * 
 * Application identifier
 */
/**
 * ListallerAppItem:version:
 */
/**
 * listaller_app_item_get_version:
 * @self: the <link linkend="ListallerAppItem"><type>ListallerAppItem</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="ListallerAppItem--version"><type>"version"</type></link> property.
 * 
 * 
 * 
 * Returns: the value of the <link linkend="ListallerAppItem--version"><type>"version"</type></link> property
 */
/**
 * listaller_app_item_set_version:
 * @self: the <link linkend="ListallerAppItem"><type>ListallerAppItem</type></link> instance to modify
 * @value: the new value of the <link linkend="ListallerAppItem--version"><type>"version"</type></link> property
 * 
 * Set the value of the <link linkend="ListallerAppItem--version"><type>"version"</type></link> property to @value.
 * 
 * 
 */
/**
 * ListallerAppItem:license:
 */
/**
 * listaller_app_item_get_license:
 * @self: the <link linkend="ListallerAppItem"><type>ListallerAppItem</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="ListallerAppItem--license"><type>"license"</type></link> property.
 * 
 * 
 * 
 * Returns: the value of the <link linkend="ListallerAppItem--license"><type>"license"</type></link> property
 */
/**
 * listaller_app_item_set_license:
 * @self: the <link linkend="ListallerAppItem"><type>ListallerAppItem</type></link> instance to modify
 * @value: the new value of the <link linkend="ListallerAppItem--license"><type>"license"</type></link> property
 * 
 * Set the value of the <link linkend="ListallerAppItem--license"><type>"license"</type></link> property to @value.
 * 
 * 
 */
/**
 * ListallerAppItem:metainfo:
 */
/**
 * listaller_app_item_get_metainfo:
 * @self: the <link linkend="ListallerAppItem"><type>ListallerAppItem</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="ListallerAppItem--metainfo"><type>"metainfo"</type></link> property.
 * 
 * 
 * 
 * Returns: the value of the <link linkend="ListallerAppItem--metainfo"><type>"metainfo"</type></link> property
 */
/**
 * listaller_app_item_set_metainfo:
 * @self: the <link linkend="ListallerAppItem"><type>ListallerAppItem</type></link> instance to modify
 * @value: the new value of the <link linkend="ListallerAppItem--metainfo"><type>"metainfo"</type></link> property
 * 
 * Set the value of the <link linkend="ListallerAppItem--metainfo"><type>"metainfo"</type></link> property to @value.
 * 
 * 
 */
/**
 * ListallerAppItem:size-installed:
 */
/**
 * listaller_app_item_get_size_installed:
 * @self: the <link linkend="ListallerAppItem"><type>ListallerAppItem</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="ListallerAppItem--size-installed"><type>"size-installed"</type></link> property.
 * 
 * 
 * 
 * Returns: the value of the <link linkend="ListallerAppItem--size-installed"><type>"size-installed"</type></link> property
 */
/**
 * listaller_app_item_set_size_installed:
 * @self: the <link linkend="ListallerAppItem"><type>ListallerAppItem</type></link> instance to modify
 * @value: the new value of the <link linkend="ListallerAppItem--size-installed"><type>"size-installed"</type></link> property
 * 
 * Set the value of the <link linkend="ListallerAppItem--size-installed"><type>"size-installed"</type></link> property to @value.
 * 
 * 
 */
/**
 * ListallerAppItem:metadata-file:
 */
/**
 * listaller_app_item_get_metadata_file:
 * @self: the <link linkend="ListallerAppItem"><type>ListallerAppItem</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="ListallerAppItem--metadata-file"><type>"metadata-file"</type></link> property.
 * 
 * 
 * 
 * Returns: the value of the <link linkend="ListallerAppItem--metadata-file"><type>"metadata-file"</type></link> property
 */
/**
 * listaller_app_item_set_metadata_file:
 * @self: the <link linkend="ListallerAppItem"><type>ListallerAppItem</type></link> instance to modify
 * @value: the new value of the <link linkend="ListallerAppItem--metadata-file"><type>"metadata-file"</type></link> property
 * 
 * Set the value of the <link linkend="ListallerAppItem--metadata-file"><type>"metadata-file"</type></link> property to @value.
 * 
 * 
 */
/**
 * ListallerAppItem:desktop-file:
 */
/**
 * listaller_app_item_get_desktop_file:
 * @self: the <link linkend="ListallerAppItem"><type>ListallerAppItem</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="ListallerAppItem--desktop-file"><type>"desktop-file"</type></link> property.
 * 
 * 
 * 
 * Returns: the value of the <link linkend="ListallerAppItem--desktop-file"><type>"desktop-file"</type></link> property
 */
/**
 * listaller_app_item_set_desktop_file:
 * @self: the <link linkend="ListallerAppItem"><type>ListallerAppItem</type></link> instance to modify
 * @value: the new value of the <link linkend="ListallerAppItem--desktop-file"><type>"desktop-file"</type></link> property
 * 
 * Set the value of the <link linkend="ListallerAppItem--desktop-file"><type>"desktop-file"</type></link> property to @value.
 * 
 * 
 */
/**
 * ListallerAppItem:state:
 */
/**
 * listaller_app_item_get_state:
 * @self: the <link linkend="ListallerAppItem"><type>ListallerAppItem</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="ListallerAppItem--state"><type>"state"</type></link> property.
 * 
 * 
 * 
 * Returns: the value of the <link linkend="ListallerAppItem--state"><type>"state"</type></link> property
 */
/**
 * listaller_app_item_set_state:
 * @self: the <link linkend="ListallerAppItem"><type>ListallerAppItem</type></link> instance to modify
 * @value: the new value of the <link linkend="ListallerAppItem--state"><type>"state"</type></link> property
 * 
 * Set the value of the <link linkend="ListallerAppItem--state"><type>"state"</type></link> property to @value.
 * 
 * 
 */
/**
 * ListallerAppItem:install-time:
 */
/**
 * listaller_app_item_get_install_time:
 * @self: the <link linkend="ListallerAppItem"><type>ListallerAppItem</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="ListallerAppItem--install-time"><type>"install-time"</type></link> property.
 * 
 * 
 * 
 * Returns: the value of the <link linkend="ListallerAppItem--install-time"><type>"install-time"</type></link> property
 */
/**
 * listaller_app_item_set_install_time:
 * @self: the <link linkend="ListallerAppItem"><type>ListallerAppItem</type></link> instance to modify
 * @value: the new value of the <link linkend="ListallerAppItem--install-time"><type>"install-time"</type></link> property
 * 
 * Set the value of the <link linkend="ListallerAppItem--install-time"><type>"install-time"</type></link> property to @value.
 * 
 * 
 */
/**
 * ListallerAppItem:replaces:
 */
/**
 * listaller_app_item_get_replaces:
 * @self: the <link linkend="ListallerAppItem"><type>ListallerAppItem</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="ListallerAppItem--replaces"><type>"replaces"</type></link> property.
 * 
 * 
 * 
 * Returns: the value of the <link linkend="ListallerAppItem--replaces"><type>"replaces"</type></link> property
 */
/**
 * listaller_app_item_set_replaces:
 * @self: the <link linkend="ListallerAppItem"><type>ListallerAppItem</type></link> instance to modify
 * @value: the new value of the <link linkend="ListallerAppItem--replaces"><type>"replaces"</type></link> property
 * 
 * Set the value of the <link linkend="ListallerAppItem--replaces"><type>"replaces"</type></link> property to @value.
 * 
 * 
 */
/**
 * ListallerAppItem:origin:
 */
/**
 * listaller_app_item_get_origin:
 * @self: the <link linkend="ListallerAppItem"><type>ListallerAppItem</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="ListallerAppItem--origin"><type>"origin"</type></link> property.
 * 
 * 
 * 
 * Returns: the value of the <link linkend="ListallerAppItem--origin"><type>"origin"</type></link> property
 */
/**
 * listaller_app_item_set_origin:
 * @self: the <link linkend="ListallerAppItem"><type>ListallerAppItem</type></link> instance to modify
 * @value: the new value of the <link linkend="ListallerAppItem--origin"><type>"origin"</type></link> property
 * 
 * Set the value of the <link linkend="ListallerAppItem--origin"><type>"origin"</type></link> property to @value.
 * 
 * 
 */
/**
 * ListallerAppItem:appid:
 */
/**
 * listaller_app_item_get_appid:
 * @self: the <link linkend="ListallerAppItem"><type>ListallerAppItem</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="ListallerAppItem--appid"><type>"appid"</type></link> property.
 * 
 * 
 * 
 * Returns: the value of the <link linkend="ListallerAppItem--appid"><type>"appid"</type></link> property
 */
/**
 * ListallerAppItem:dependencies:
 */
/**
 * listaller_app_item_get_dependencies:
 * @self: the <link linkend="ListallerAppItem"><type>ListallerAppItem</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="ListallerAppItem--dependencies"><type>"dependencies"</type></link> property.
 * 
 * 
 * 
 * Returns: the value of the <link linkend="ListallerAppItem--dependencies"><type>"dependencies"</type></link> property
 */
/**
 * listaller_app_item_set_dependencies:
 * @self: the <link linkend="ListallerAppItem"><type>ListallerAppItem</type></link> instance to modify
 * @value: the new value of the <link linkend="ListallerAppItem--dependencies"><type>"dependencies"</type></link> property
 * 
 * Set the value of the <link linkend="ListallerAppItem--dependencies"><type>"dependencies"</type></link> property to @value.
 * 
 * 
 */
/**
 * listaller_app_item_validate_appid:
 * @application_id: &nbsp;
 */
/**
 * ListallerAppItem:
 * 
 * Application entry
 * 
 * <para>Objects of this class contain information about an application (installed or not installed) and associated Listaller state data.</para>
 */
/**
 * ListallerAppItemClass:
 * @parent_class: the parent class structure
 * 
 * The class structure for <link linkend="LISTALLER-TYPE-APP-ITEM:CAPS"><literal>LISTALLER_TYPE_APP_ITEM</literal></link>. All the fields in this structure are private and should never be accessed directly.
 */
/**
 * listaller_app_state_to_string:
 * @self: the <link linkend="ListallerAppState"><type>ListallerAppState</type></link> instance
 */
/**
 * listaller_app_state_is_all_set:
 * @self: the <link linkend="ListallerAppState"><type>ListallerAppState</type></link> instance
 * @flags: &nbsp;
 */
/**
 * listaller_app_state_is_any_set:
 * @self: the <link linkend="ListallerAppState"><type>ListallerAppState</type></link> instance
 * @flags: &nbsp;
 */
/**
 * listaller_app_state_set:
 * @self: the <link linkend="ListallerAppState"><type>ListallerAppState</type></link> instance
 * @mode: &nbsp;
 */
/**
 * listaller_app_state_unset:
 * @self: the <link linkend="ListallerAppState"><type>ListallerAppState</type></link> instance
 * @mode: &nbsp;
 */
/**
 * ListallerAppState:
 * 
 * Status of an application
 * 
 * <para>Indicates if an application is installed (and in which mode it was installed), or if it is in any other, different state.</para>
 */
/**
 * ListallerAppLicense:
 * 
 * License name and text pair
 * 
 * <para>Describes a software license</para>
 */
/**
 * listaller_app_license_dup:
 * @self: the instance to duplicate
 * 
 * Creates a copy of self.
 * 
 * <emphasis>See also</emphasis>: listaller_app_license_copy(), listaller_app_license_destroy(), listaller_app_license_free()
 * 
 * Returns: a copy of @self, free with listaller_app_license_free()
 */
/**
 * listaller_app_license_free:
 * @self: the struct to free
 * 
 * Frees the heap-allocated struct.
 * 
 * <emphasis>See also</emphasis>: listaller_app_license_dup(), listaller_app_license_copy(), listaller_app_license_destroy()
 */
/**
 * listaller_app_license_copy:
 * @self: the struct to copy
 * @dest: a unused struct. Use listaller_app_license_destroy() to free the content.
 * 
 * Creates a copy of self.
 * 
 * <emphasis>See also</emphasis>: listaller_app_license_dup(), listaller_app_license_destroy(), listaller_app_license_free()
 */
/**
 * listaller_app_license_destroy:
 * @self: the struct to destroy
 * 
 * Frees the content of the struct pointed by @self.
 * 
 * <emphasis>See also</emphasis>: listaller_app_license_dup(), listaller_app_license_copy(), listaller_app_license_free()
 */
