/* packagekit-glib2.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Pk", gir_namespace = "PackageKitGlib", gir_version = "1.0", lower_case_cprefix = "pk__")]
namespace PackageKit {
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", type_id = "pk_catalog_get_type ()")]
	public class Catalog : GLib.Object {
		[CCode (cname = "pk_catalog_new", has_construct_function = false)]
		public Catalog ();
		[CCode (cname = "pk_catalog_lookup_async")]
		public async GLib.GenericArray<weak void*> lookup_async (string filename, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_catalog_test")]
		public static void test (void* user_data);
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", type_id = "pk_category_get_type ()")]
	public class Category : PackageKit.Source {
		[CCode (cname = "pk_category_new", has_construct_function = false)]
		public Category ();
		[CCode (cname = "pk_category_get_icon")]
		public unowned string get_icon ();
		[CCode (cname = "pk_category_get_id")]
		public unowned string get_id ();
		[CCode (cname = "pk_category_get_name")]
		public unowned string get_name ();
		[CCode (cname = "pk_category_get_parent_id")]
		public unowned string get_parent_id ();
		[CCode (cname = "pk_category_get_summary")]
		public unowned string get_summary ();
		[CCode (cname = "pk_category_set_icon")]
		public void set_icon (string icon);
		[CCode (cname = "pk_category_set_id")]
		public void set_id (string cat_id);
		[CCode (cname = "pk_category_set_name")]
		public void set_name (string name);
		[CCode (cname = "pk_category_set_parent_id")]
		public void set_parent_id (string parent_id);
		[CCode (cname = "pk_category_set_summary")]
		public void set_summary (string summary);
		[NoAccessorMethod]
		public string cat_id { owned get; set; }
		[NoAccessorMethod]
		public string icon { owned get; set; }
		[NoAccessorMethod]
		public string name { owned get; set; }
		[NoAccessorMethod]
		public string parent_id { owned get; set; }
		[NoAccessorMethod]
		public string summary { owned get; set; }
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", type_id = "pk_client_get_type ()")]
	public class Client : GLib.Object {
		[CCode (cname = "pk_client_new", has_construct_function = false)]
		public Client ();
		[CCode (cname = "pk_client_accept_eula")]
		public PackageKit.Results accept_eula (string eula_id, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_client_accept_eula_async")]
		public async void accept_eula_async (string eula_id, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_client_adopt")]
		public PackageKit.Results adopt (string transaction_id, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_client_adopt_async")]
		public async void adopt_async (string transaction_id, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[NoWrapper]
		public virtual void changed ();
		[CCode (cname = "pk_client_download_packages")]
		public PackageKit.Results download_packages ([CCode (array_length = false, array_null_terminated = true)] string[] package_ids, string directory, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_client_download_packages_async")]
		public async void download_packages_async ([CCode (array_length = false, array_null_terminated = true)] string[] package_ids, string directory, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_client_generic_finish")]
		public PackageKit.Results generic_finish (GLib.AsyncResult res) throws GLib.Error;
		[CCode (cname = "pk_client_get_background")]
		public bool get_background ();
		[CCode (cname = "pk_client_get_cache_age")]
		public uint get_cache_age ();
		[CCode (cname = "pk_client_get_categories")]
		public PackageKit.Results get_categories (GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_client_get_categories_async")]
		public async void get_categories_async (GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_client_get_depends")]
		public PackageKit.Results get_depends (PackageKit.Bitfield filters, [CCode (array_length = false, array_null_terminated = true)] string[] package_ids, bool recursive, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_client_get_depends_async")]
		public async void get_depends_async (PackageKit.Bitfield filters, [CCode (array_length = false, array_null_terminated = true)] string[] package_ids, bool recursive, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_client_get_details")]
		public PackageKit.Results get_details ([CCode (array_length = false, array_null_terminated = true)] string[] package_ids, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_client_get_details_async")]
		public async void get_details_async ([CCode (array_length = false, array_null_terminated = true)] string[] package_ids, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_client_get_distro_upgrades")]
		public PackageKit.Results get_distro_upgrades (GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_client_get_distro_upgrades_async")]
		public async void get_distro_upgrades_async (GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_client_get_files")]
		public PackageKit.Results get_files ([CCode (array_length = false, array_null_terminated = true)] string[] package_ids, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_client_get_files_async")]
		public async void get_files_async ([CCode (array_length = false, array_null_terminated = true)] string[] package_ids, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_client_get_idle")]
		public bool get_idle ();
		[CCode (cname = "pk_client_get_interactive")]
		public bool get_interactive ();
		[CCode (cname = "pk_client_get_locale")]
		public unowned string get_locale ();
		[CCode (cname = "pk_client_get_old_transactions")]
		public PackageKit.Results get_old_transactions (uint number, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_client_get_old_transactions_async")]
		public async void get_old_transactions_async (uint number, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_client_get_packages")]
		public PackageKit.Results get_packages (PackageKit.Bitfield filters, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_client_get_packages_async")]
		public async void get_packages_async (PackageKit.Bitfield filters, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_client_get_progress")]
		public PackageKit.Progress get_progress (string transaction_id, GLib.Cancellable? cancellable) throws GLib.Error;
		[CCode (cname = "pk_client_get_progress_async")]
		public async PackageKit.Progress get_progress_async (string transaction_id, GLib.Cancellable? cancellable) throws GLib.Error;
		[CCode (cname = "pk_client_get_repo_list")]
		public PackageKit.Results get_repo_list (PackageKit.Bitfield filters, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_client_get_repo_list_async")]
		public async void get_repo_list_async (PackageKit.Bitfield filters, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_client_get_requires")]
		public PackageKit.Results get_requires (PackageKit.Bitfield filters, [CCode (array_length = false, array_null_terminated = true)] string[] package_ids, bool recursive, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_client_get_requires_async")]
		public async void get_requires_async (PackageKit.Bitfield filters, [CCode (array_length = false, array_null_terminated = true)] string[] package_ids, bool recursive, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_client_get_update_detail")]
		public PackageKit.Results get_update_detail ([CCode (array_length = false, array_null_terminated = true)] string[] package_ids, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_client_get_update_detail_async")]
		public async void get_update_detail_async ([CCode (array_length = false, array_null_terminated = true)] string[] package_ids, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_client_get_updates")]
		public PackageKit.Results get_updates (PackageKit.Bitfield filters, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_client_get_updates_async")]
		public async void get_updates_async (PackageKit.Bitfield filters, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_client_install_files")]
		public PackageKit.Results install_files (bool only_trusted, [CCode (array_length = false, array_null_terminated = true)] string[] files, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_client_install_files_async")]
		public async void install_files_async (bool only_trusted, [CCode (array_length = false, array_null_terminated = true)] string[] files, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_client_install_packages")]
		public PackageKit.Results install_packages (bool only_trusted, [CCode (array_length = false, array_null_terminated = true)] string[] package_ids, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_client_install_packages_async")]
		public async void install_packages_async (bool only_trusted, [CCode (array_length = false, array_null_terminated = true)] string[] package_ids, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_client_install_signature")]
		public PackageKit.Results install_signature (PackageKit.SigType type, string key_id, string package_id, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_client_install_signature_async")]
		public async void install_signature_async (PackageKit.SigType type, string key_id, string package_id, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_client_refresh_cache")]
		public PackageKit.Results refresh_cache (bool force, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_client_refresh_cache_async")]
		public async void refresh_cache_async (bool force, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_client_remove_packages")]
		public PackageKit.Results remove_packages ([CCode (array_length = false, array_null_terminated = true)] string[] package_ids, bool allow_deps, bool autoremove, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_client_remove_packages_async")]
		public async void remove_packages_async ([CCode (array_length = false, array_null_terminated = true)] string[] package_ids, bool allow_deps, bool autoremove, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_client_repair_system")]
		public PackageKit.Results repair_system (bool only_trusted, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_client_repair_system_async")]
		public async void repair_system_async (bool only_trusted, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_client_repo_enable")]
		public PackageKit.Results repo_enable (string repo_id, bool enabled, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_client_repo_enable_async")]
		public async void repo_enable_async (string repo_id, bool enabled, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_client_repo_set_data")]
		public PackageKit.Results repo_set_data (string repo_id, string parameter, string value, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_client_repo_set_data_async")]
		public async void repo_set_data_async (string repo_id, string parameter, string value, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_client_resolve")]
		public PackageKit.Results resolve (PackageKit.Bitfield filters, [CCode (array_length = false, array_null_terminated = true)] string[] packages, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_client_resolve_async")]
		public async void resolve_async (PackageKit.Bitfield filters, [CCode (array_length = false, array_null_terminated = true)] string[] packages, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_client_rollback")]
		public PackageKit.Results rollback (string transaction_id, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_client_rollback_async")]
		public async void rollback_async (string transaction_id, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_client_search_details")]
		public PackageKit.Results search_details (PackageKit.Bitfield filters, [CCode (array_length = false, array_null_terminated = true)] string[] values, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_client_search_details_async")]
		public async void search_details_async (PackageKit.Bitfield filters, [CCode (array_length = false, array_null_terminated = true)] string[] values, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_client_search_files")]
		public PackageKit.Results search_files (PackageKit.Bitfield filters, [CCode (array_length = false, array_null_terminated = true)] string[] values, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_client_search_files_async")]
		public async void search_files_async (PackageKit.Bitfield filters, [CCode (array_length = false, array_null_terminated = true)] string[] values, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_client_search_groups")]
		public PackageKit.Results search_groups (PackageKit.Bitfield filters, [CCode (array_length = false, array_null_terminated = true)] string[] values, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_client_search_groups_async")]
		public async void search_groups_async (PackageKit.Bitfield filters, [CCode (array_length = false, array_null_terminated = true)] string[] values, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_client_search_names")]
		public PackageKit.Results search_names (PackageKit.Bitfield filters, [CCode (array_length = false, array_null_terminated = true)] string[] values, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_client_search_names_async")]
		public async void search_names_async (PackageKit.Bitfield filters, [CCode (array_length = false, array_null_terminated = true)] string[] values, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_client_set_background")]
		public void set_background (bool background);
		[CCode (cname = "pk_client_set_cache_age")]
		public void set_cache_age (uint cache_age);
		[CCode (cname = "pk_client_set_interactive")]
		public void set_interactive (bool interactive);
		[CCode (cname = "pk_client_set_locale")]
		public void set_locale (string locale);
		[CCode (cname = "pk_client_simulate_install_files")]
		public PackageKit.Results simulate_install_files ([CCode (array_length = false, array_null_terminated = true)] string[] files, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_client_simulate_install_files_async")]
		public async void simulate_install_files_async ([CCode (array_length = false, array_null_terminated = true)] string[] files, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_client_simulate_install_packages")]
		public PackageKit.Results simulate_install_packages ([CCode (array_length = false, array_null_terminated = true)] string[] package_ids, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_client_simulate_install_packages_async")]
		public async void simulate_install_packages_async ([CCode (array_length = false, array_null_terminated = true)] string[] package_ids, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_client_simulate_remove_packages")]
		public PackageKit.Results simulate_remove_packages ([CCode (array_length = false, array_null_terminated = true)] string[] package_ids, bool autoremove, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_client_simulate_remove_packages_async")]
		public async void simulate_remove_packages_async ([CCode (array_length = false, array_null_terminated = true)] string[] package_ids, bool autoremove, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_client_simulate_repair_system")]
		public PackageKit.Results simulate_repair_system (GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_client_simulate_repair_system_async")]
		public async void simulate_repair_system_async (GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_client_simulate_update_packages")]
		public PackageKit.Results simulate_update_packages ([CCode (array_length = false, array_null_terminated = true)] string[] package_ids, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_client_simulate_update_packages_async")]
		public async void simulate_update_packages_async ([CCode (array_length = false, array_null_terminated = true)] string[] package_ids, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_client_test")]
		public static void test (void* user_data);
		[CCode (cname = "pk_client_update_packages")]
		public PackageKit.Results update_packages (bool only_trusted, [CCode (array_length = false, array_null_terminated = true)] string[] package_ids, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_client_update_packages_async")]
		public async void update_packages_async (bool only_trusted, [CCode (array_length = false, array_null_terminated = true)] string[] package_ids, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_client_update_system")]
		public PackageKit.Results update_system (bool only_trusted, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_client_update_system_async")]
		public async void update_system_async (bool only_trusted, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_client_upgrade_system")]
		public PackageKit.Results upgrade_system (string distro_id, PackageKit.UpgradeKind upgrade_kind, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_client_upgrade_system_async")]
		public async void upgrade_system_async (string distro_id, PackageKit.UpgradeKind upgrade_kind, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_client_what_provides")]
		public PackageKit.Results what_provides (PackageKit.Bitfield filters, PackageKit.Provides provides, [CCode (array_length = false, array_null_terminated = true)] string[] values, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_client_what_provides_async")]
		public async void what_provides_async (PackageKit.Bitfield filters, PackageKit.Provides provides, [CCode (array_length = false, array_null_terminated = true)] string[] values, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[NoAccessorMethod]
		public bool background { get; set; }
		[NoAccessorMethod]
		public uint cache_age { get; set; }
		[NoAccessorMethod]
		public bool idle { get; }
		[NoAccessorMethod]
		public bool interactive { get; set; }
		[NoAccessorMethod]
		public string locale { owned get; set; }
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", type_id = "pk_client_helper_get_type ()")]
	public class ClientHelper : GLib.Object {
		[CCode (cname = "pk_client_helper_new", has_construct_function = false)]
		public ClientHelper ();
		[CCode (cname = "pk_client_helper_start")]
		public bool start (string socket_filename, string argv, string envp) throws GLib.Error;
		[CCode (cname = "pk_client_helper_stop")]
		public bool stop () throws GLib.Error;
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", type_id = "pk_control_get_type ()")]
	public class Control : GLib.Object {
		[CCode (cname = "pk_control_new", has_construct_function = false)]
		public Control ();
		[CCode (cname = "pk_control_can_authorize_async")]
		public async PackageKit.Authorize can_authorize_async (string action_id, GLib.Cancellable? cancellable) throws GLib.Error;
		[NoWrapper]
		public virtual void connection_changed (bool connected);
		[CCode (cname = "pk_control_get_daemon_state_async")]
		public async string get_daemon_state_async (GLib.Cancellable? cancellable) throws GLib.Error;
		[CCode (cname = "pk_control_get_network_state_async")]
		public async PackageKit.Network get_network_state_async (GLib.Cancellable? cancellable) throws GLib.Error;
		[CCode (cname = "pk_control_get_properties")]
		public bool get_properties (GLib.Cancellable? cancellable) throws GLib.Error;
		[CCode (cname = "pk_control_get_properties_async")]
		public async bool get_properties_async (GLib.Cancellable? cancellable) throws GLib.Error;
		[CCode (cname = "pk_control_get_tid_async")]
		public async string get_tid_async (GLib.Cancellable? cancellable) throws GLib.Error;
		[CCode (cname = "pk_control_get_time_since_action_async")]
		public async uint get_time_since_action_async (PackageKit.Role role, GLib.Cancellable? cancellable) throws GLib.Error;
		[CCode (array_length = false, array_null_terminated = true, cname = "pk_control_get_transaction_list")]
		public string[] get_transaction_list (GLib.Cancellable? cancellable) throws GLib.Error;
		[CCode (array_length = false, array_null_terminated = true, cname = "pk_control_get_transaction_list_async")]
		public async string[] get_transaction_list_async (GLib.Cancellable? cancellable) throws GLib.Error;
		[NoWrapper]
		public virtual void network_state_changed ();
		[CCode (cname = "pk_control_set_proxy")]
		public bool set_proxy (string proxy_http, string proxy_ftp, GLib.Cancellable? cancellable) throws GLib.Error;
		[CCode (cname = "pk_control_set_proxy2")]
		public bool set_proxy2 (string proxy_http, string proxy_https, string proxy_ftp, string proxy_socks, string no_proxy, string pac, GLib.Cancellable? cancellable) throws GLib.Error;
		[CCode (cname = "pk_control_set_proxy2_async")]
		public async void set_proxy2_async (string proxy_http, string proxy_https, string proxy_ftp, string proxy_socks, string no_proxy, string pac, GLib.Cancellable? cancellable);
		[CCode (cname = "pk_control_set_proxy_async")]
		public async bool set_proxy_async (string proxy_http, string proxy_ftp, GLib.Cancellable? cancellable) throws GLib.Error;
		[CCode (cname = "pk_control_set_root")]
		public bool set_root (string root, GLib.Cancellable? cancellable) throws GLib.Error;
		[CCode (cname = "pk_control_set_root_async")]
		public async bool set_root_async (string root, GLib.Cancellable? cancellable) throws GLib.Error;
		[CCode (cname = "pk_control_suggest_daemon_quit")]
		public bool suggest_daemon_quit (GLib.Cancellable? cancellable) throws GLib.Error;
		[CCode (cname = "pk_control_suggest_daemon_quit_async")]
		public async bool suggest_daemon_quit_async (GLib.Cancellable? cancellable) throws GLib.Error;
		[CCode (cname = "pk_control_test")]
		public static void test (void* user_data);
		[NoAccessorMethod]
		public string backend_author { owned get; set; }
		[NoAccessorMethod]
		public string backend_description { owned get; set; }
		[NoAccessorMethod]
		public string backend_name { owned get; set; }
		[NoAccessorMethod]
		public bool connected { get; set; }
		[NoAccessorMethod]
		public string distro_id { owned get; set; }
		[NoAccessorMethod]
		public uint64 filters { get; set; }
		[NoAccessorMethod]
		public uint64 groups { get; set; }
		[NoAccessorMethod]
		public virtual bool locked { get; set; }
		[NoAccessorMethod]
		public string mime_types { owned get; set; }
		[NoAccessorMethod]
		public uint network_state { get; set; }
		[NoAccessorMethod]
		public uint64 roles { get; set; }
		[NoAccessorMethod]
		public uint version_major { get; }
		[NoAccessorMethod]
		public uint version_micro { get; }
		[NoAccessorMethod]
		public uint version_minor { get; }
		public virtual signal void repo_list_changed ();
		public virtual signal void restart_schedule ();
		public virtual signal void transaction_list_changed ([CCode (array_length = false, array_null_terminated = true)] string[] transaction_ids);
		public virtual signal void updates_changed ();
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", type_id = "pk_desktop_get_type ()")]
	public class Desktop : GLib.Object {
		[CCode (cname = "pk_desktop_new", has_construct_function = false)]
		public Desktop ();
		[CCode (cname = "pk_desktop_get_files_for_package")]
		public GLib.GenericArray<weak void*> get_files_for_package (string package) throws GLib.Error;
		[CCode (cname = "pk_desktop_get_package_for_file")]
		public string get_package_for_file (string filename) throws GLib.Error;
		[CCode (cname = "pk_desktop_get_shown_for_package")]
		public GLib.GenericArray<weak void*> get_shown_for_package (string package) throws GLib.Error;
		[CCode (cname = "pk_desktop_open_database")]
		public bool open_database () throws GLib.Error;
		[CCode (cname = "pk_desktop_test")]
		public static void test (void* user_data);
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", type_id = "pk_details_get_type ()")]
	public class Details : PackageKit.Source {
		[CCode (cname = "pk_details_new", has_construct_function = false)]
		public Details ();
		[NoAccessorMethod]
		public string description { owned get; set; }
		[NoAccessorMethod]
		public uint group { get; set; }
		[NoAccessorMethod]
		public string license { owned get; set; }
		[NoAccessorMethod]
		public string package_id { owned get; set; }
		[NoAccessorMethod]
		public uint64 size { get; set; }
		[NoAccessorMethod]
		public string url { owned get; set; }
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", type_id = "pk_distro_upgrade_get_type ()")]
	public class DistroUpgrade : PackageKit.Source {
		[CCode (cname = "pk_distro_upgrade_new", has_construct_function = false)]
		public DistroUpgrade ();
		[CCode (cname = "pk_distro_upgrade_get_id")]
		public unowned string get_id ();
		[CCode (cname = "pk_distro_upgrade_get_state")]
		public PackageKit.DistroUpgradeType get_state ();
		[CCode (cname = "pk_distro_upgrade_get_summary")]
		public unowned string get_summary ();
		[NoAccessorMethod]
		public string name { owned get; set; }
		[NoAccessorMethod]
		public uint state { get; set; }
		[NoAccessorMethod]
		public string summary { owned get; set; }
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", type_id = "pk_error_get_type ()")]
	public class Error : PackageKit.Source {
		[CCode (cname = "pk_error_new", has_construct_function = false)]
		public Error ();
		[CCode (cname = "pk_error_get_code")]
		public PackageKit.ErrorType get_code ();
		[CCode (cname = "pk_error_get_details")]
		public unowned string get_details ();
		[NoAccessorMethod]
		public uint code { get; set; }
		[NoAccessorMethod]
		public string details { owned get; set; }
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", type_id = "pk_eula_required_get_type ()")]
	public class EulaRequired : PackageKit.Source {
		[CCode (cname = "pk_eula_required_new", has_construct_function = false)]
		public EulaRequired ();
		[NoAccessorMethod]
		public string eula_id { owned get; set; }
		[NoAccessorMethod]
		public string license_agreement { owned get; set; }
		[NoAccessorMethod]
		public string package_id { owned get; set; }
		[NoAccessorMethod]
		public string vendor_name { owned get; set; }
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", type_id = "pk_files_get_type ()")]
	public class Files : PackageKit.Source {
		[CCode (cname = "pk_files_new", has_construct_function = false)]
		public Files ();
		[CCode (array_length = false, array_null_terminated = true)]
		[NoAccessorMethod]
		public string[] files { owned get; set; }
		[NoAccessorMethod]
		public string package_id { owned get; set; }
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", type_id = "pk_media_change_required_get_type ()")]
	public class MediaChangeRequired : PackageKit.Source {
		[CCode (cname = "pk_media_change_required_new", has_construct_function = false)]
		public MediaChangeRequired ();
		[NoAccessorMethod]
		public string media_id { owned get; set; }
		[NoAccessorMethod]
		public string media_text { owned get; set; }
		[NoAccessorMethod]
		public uint media_type { get; set; }
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", type_id = "pk_message_get_type ()")]
	public class Message : PackageKit.Source {
		[CCode (cname = "pk_message_new", has_construct_function = false)]
		public Message ();
		[CCode (cname = "pk_message_get_details")]
		public unowned string get_details ();
		[CCode (cname = "pk_message_get_kind")]
		public PackageKit.MessageType get_kind ();
		[NoAccessorMethod]
		public string details { owned get; set; }
		[NoAccessorMethod]
		public uint type { get; set; }
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", type_id = "pk_package_get_type ()")]
	public class Package : PackageKit.Source {
		[CCode (cname = "pk_package_new", has_construct_function = false)]
		public Package ();
		[CCode (cname = "pk_package_equal")]
		public bool equal (PackageKit.Package package2);
		[CCode (cname = "pk_package_equal_id")]
		public bool equal_id (PackageKit.Package package2);
		[CCode (cname = "pk_package_get_arch")]
		public unowned string get_arch ();
		[CCode (cname = "pk_package_get_data")]
		public unowned string get_data ();
		[CCode (cname = "pk_package_get_id")]
		public unowned string get_id ();
		[CCode (cname = "pk_package_get_info")]
		public PackageKit.Info get_info ();
		[CCode (cname = "pk_package_get_name")]
		public unowned string get_name ();
		[CCode (cname = "pk_package_get_summary")]
		public unowned string get_summary ();
		[CCode (cname = "pk_package_get_version")]
		public unowned string get_version ();
		[CCode (cname = "pk_package_id_build")]
		public static string id_build (string name, string version, string arch, string data);
		[CCode (cname = "pk_package_id_check")]
		public static bool id_check (string package_id);
		[CCode (cname = "pk_package_id_equal_fuzzy_arch")]
		public static bool id_equal_fuzzy_arch (string package_id1, string package_id2);
		[CCode (array_length = false, array_null_terminated = true, cname = "pk_package_id_split")]
		public static string[] id_split (string package_id);
		[CCode (cname = "pk_package_id_test")]
		public static void id_test (void* user_data);
		[CCode (cname = "pk_package_id_to_printable")]
		public static string id_to_printable (string package_id);
		[CCode (array_length = false, array_null_terminated = true, cname = "pk_package_ids_add_id")]
		public static string[] ids_add_id (string package_ids, string package_id);
		[CCode (array_length = false, array_null_terminated = true, cname = "pk_package_ids_add_ids")]
		public static string[] ids_add_ids (string package_ids, string package_ids_new);
		[CCode (cname = "pk_package_ids_check")]
		public static bool ids_check (string package_ids);
		[CCode (array_length = false, array_null_terminated = true, cname = "pk_package_ids_from_id")]
		public static string[] ids_from_id (string package_id);
		[CCode (array_length = false, array_null_terminated = true, cname = "pk_package_ids_from_string")]
		public static string[] ids_from_string (string package_id);
		[CCode (cname = "pk_package_ids_present_id")]
		public static bool ids_present_id (string package_ids, string package_id);
		[CCode (array_length = false, array_null_terminated = true, cname = "pk_package_ids_remove_id")]
		public static string[] ids_remove_id (string package_ids, string package_id);
		[CCode (cname = "pk_package_ids_test")]
		public static void ids_test (void* user_data);
		[CCode (cname = "pk_package_ids_to_string")]
		public static string ids_to_string (string package_ids);
		[CCode (cname = "pk_package_print")]
		public void print ();
		[CCode (cname = "pk_package_set_id")]
		public bool set_id (string package_id) throws GLib.Error;
		[CCode (cname = "pk_package_test")]
		public static void test (void* user_data);
		[NoAccessorMethod]
		public string description { owned get; set; }
		[NoAccessorMethod]
		public uint group { get; set; }
		[NoAccessorMethod]
		public uint info { get; set; }
		[NoAccessorMethod]
		public string license { owned get; set; }
		[NoAccessorMethod]
		public string package_id { owned get; }
		[NoAccessorMethod]
		public uint64 size { get; set; }
		[NoAccessorMethod]
		public string summary { owned get; set; }
		[NoAccessorMethod]
		public string update_bugzilla_url { owned get; set; }
		[NoAccessorMethod]
		public string update_changelog { owned get; set; }
		[NoAccessorMethod]
		public string update_cve_url { owned get; set; }
		[NoAccessorMethod]
		public string update_issued { owned get; set; }
		[NoAccessorMethod]
		public string update_obsoletes { owned get; set; }
		[NoAccessorMethod]
		public uint update_restart { get; set; }
		[NoAccessorMethod]
		public uint update_state { get; set; }
		[NoAccessorMethod]
		public string update_text { owned get; set; }
		[NoAccessorMethod]
		public string update_updated { owned get; set; }
		[NoAccessorMethod]
		public string update_updates { owned get; set; }
		[NoAccessorMethod]
		public string update_vendor_url { owned get; set; }
		[NoAccessorMethod]
		public string url { owned get; set; }
		public virtual signal void changed ();
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", type_id = "pk_package_sack_get_type ()")]
	public class PackageSack : GLib.Object {
		[CCode (cname = "pk_package_sack_new", has_construct_function = false)]
		public PackageSack ();
		[CCode (cname = "pk_package_sack_add_package")]
		public bool add_package (PackageKit.Package package);
		[CCode (cname = "pk_package_sack_add_package_by_id")]
		public bool add_package_by_id (string package_id) throws GLib.Error;
		[CCode (cname = "pk_package_sack_add_packages_from_file")]
		public bool add_packages_from_file (GLib.File file) throws GLib.Error;
		[NoWrapper]
		public virtual void changed ();
		[CCode (cname = "pk_package_sack_clear")]
		public void clear ();
		[CCode (cname = "pk_package_sack_filter")]
		public PackageKit.PackageSack filter (PackageKit.PackageSackFilterFunc filter_cb);
		[CCode (cname = "pk_package_sack_filter_by_info")]
		public PackageKit.PackageSack filter_by_info (PackageKit.Info info);
		[CCode (cname = "pk_package_sack_find_by_id")]
		public PackageKit.Package find_by_id (string package_id);
		[CCode (cname = "pk_package_sack_get_array")]
		public GLib.GenericArray<weak PackageKit.Package> get_array ();
		[CCode (cname = "pk_package_sack_get_details")]
		public bool get_details (GLib.Cancellable? cancellable) throws GLib.Error;
		[CCode (cname = "pk_package_sack_get_details_async")]
		public async void get_details_async (GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (array_length = false, array_null_terminated = true, cname = "pk_package_sack_get_ids")]
		public string[] get_ids ();
		[CCode (cname = "pk_package_sack_get_size")]
		public uint get_size ();
		[CCode (cname = "pk_package_sack_get_total_bytes")]
		public uint64 get_total_bytes ();
		[CCode (cname = "pk_package_sack_get_update_detail")]
		public bool get_update_detail (GLib.Cancellable? cancellable) throws GLib.Error;
		[CCode (cname = "pk_package_sack_get_update_detail_async")]
		public async void get_update_detail_async (GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_package_sack_merge_generic_finish")]
		public bool merge_generic_finish (GLib.AsyncResult res) throws GLib.Error;
		[CCode (cname = "pk_package_sack_remove_by_filter")]
		public bool remove_by_filter (PackageKit.PackageSackFilterFunc filter_cb);
		[CCode (cname = "pk_package_sack_remove_package")]
		public bool remove_package (PackageKit.Package package);
		[CCode (cname = "pk_package_sack_remove_package_by_id")]
		public bool remove_package_by_id (string package_id);
		[CCode (cname = "pk_package_sack_resolve")]
		public bool resolve (GLib.Cancellable? cancellable) throws GLib.Error;
		[CCode (cname = "pk_package_sack_resolve_async")]
		public async void resolve_async (GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_package_sack_sort")]
		public void sort (PackageKit.PackageSackSortType type);
		[CCode (cname = "pk_package_sack_test")]
		public static void test (void* user_data);
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h")]
	[Compact]
	public class PackageSackResults {
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", type_id = "pk_progress_get_type ()")]
	public class Progress : GLib.Object {
		[CCode (cname = "pk_progress_new", has_construct_function = false)]
		public Progress ();
		[CCode (cname = "pk_progress_set_allow_cancel")]
		public bool set_allow_cancel (bool allow_cancel);
		[CCode (cname = "pk_progress_set_caller_active")]
		public bool set_caller_active (bool caller_active);
		[CCode (cname = "pk_progress_set_elapsed_time")]
		public bool set_elapsed_time (uint elapsed_time);
		[CCode (cname = "pk_progress_set_item_progress")]
		public bool set_item_progress (string package_id, uint percentage);
		[CCode (cname = "pk_progress_set_package")]
		public bool set_package (PackageKit.Package package);
		[CCode (cname = "pk_progress_set_package_id")]
		public bool set_package_id (string package_id);
		[CCode (cname = "pk_progress_set_percentage")]
		public bool set_percentage (int percentage);
		[CCode (cname = "pk_progress_set_remaining_time")]
		public bool set_remaining_time (uint remaining_time);
		[CCode (cname = "pk_progress_set_role")]
		public bool set_role (PackageKit.Role role);
		[CCode (cname = "pk_progress_set_speed")]
		public bool set_speed (uint speed);
		[CCode (cname = "pk_progress_set_status")]
		public bool set_status (PackageKit.Status status);
		[CCode (cname = "pk_progress_set_subpercentage")]
		public bool set_subpercentage (int subpercentage);
		[CCode (cname = "pk_progress_set_transaction_id")]
		public bool set_transaction_id (string package_id);
		[CCode (cname = "pk_progress_set_uid")]
		public bool set_uid (uint uid);
		[CCode (cname = "pk_progress_test")]
		public static void test (void* user_data);
		[NoAccessorMethod]
		public bool allow_cancel { get; set; }
		[NoAccessorMethod]
		public bool caller_active { get; set; }
		[NoAccessorMethod]
		public uint elapsed_time { get; set; }
		[NoAccessorMethod]
		public string item_progress_id { owned get; set; }
		[NoAccessorMethod]
		public int item_progress_value { get; set; }
		[NoAccessorMethod]
		public PackageKit.Package package { owned get; set; }
		[NoAccessorMethod]
		public string package_id { owned get; set; }
		[NoAccessorMethod]
		public int percentage { get; set; }
		[NoAccessorMethod]
		public uint remaining_time { get; set; }
		[NoAccessorMethod]
		public uint role { get; set; }
		[NoAccessorMethod]
		public uint speed { get; set; }
		[NoAccessorMethod]
		public uint status { get; set; }
		[NoAccessorMethod]
		public int subpercentage { get; set; }
		[NoAccessorMethod]
		public string transaction_id { owned get; set; }
		[NoAccessorMethod]
		public uint uid { get; set; }
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", type_id = "pk_repo_detail_get_type ()")]
	public class RepoDetail : PackageKit.Source {
		[CCode (cname = "pk_repo_detail_new", has_construct_function = false)]
		public RepoDetail ();
		[NoAccessorMethod]
		public string description { owned get; set; }
		[NoAccessorMethod]
		public bool enabled { get; set; }
		[NoAccessorMethod]
		public string repo_id { owned get; set; }
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", type_id = "pk_repo_signature_required_get_type ()")]
	public class RepoSignatureRequired : PackageKit.Source {
		[CCode (cname = "pk_repo_signature_required_new", has_construct_function = false)]
		public RepoSignatureRequired ();
		[NoAccessorMethod]
		public string key_fingerprint { owned get; set; }
		[NoAccessorMethod]
		public string key_id { owned get; set; }
		[NoAccessorMethod]
		public string key_timestamp { owned get; set; }
		[NoAccessorMethod]
		public string key_url { owned get; set; }
		[NoAccessorMethod]
		public string key_userid { owned get; set; }
		[NoAccessorMethod]
		public string package_id { owned get; set; }
		[NoAccessorMethod]
		public string repository_name { owned get; set; }
		[NoAccessorMethod]
		public uint type { get; set; }
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", type_id = "pk_require_restart_get_type ()")]
	public class RequireRestart : PackageKit.Source {
		[CCode (cname = "pk_require_restart_new", has_construct_function = false)]
		public RequireRestart ();
		[NoAccessorMethod]
		public string package_id { owned get; set; }
		[NoAccessorMethod]
		public uint restart { get; set; }
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", type_id = "pk_results_get_type ()")]
	public class Results : GLib.Object {
		[CCode (cname = "pk_results_new", has_construct_function = false)]
		public Results ();
		[CCode (cname = "pk_results_add_category")]
		public bool add_category (PackageKit.Category item);
		[CCode (cname = "pk_results_add_details")]
		public bool add_details (PackageKit.Details item);
		[CCode (cname = "pk_results_add_distro_upgrade")]
		public bool add_distro_upgrade (PackageKit.DistroUpgrade item);
		[CCode (cname = "pk_results_add_eula_required")]
		public bool add_eula_required (PackageKit.EulaRequired item);
		[CCode (cname = "pk_results_add_files")]
		public bool add_files (PackageKit.Files item);
		[CCode (cname = "pk_results_add_media_change_required")]
		public bool add_media_change_required (PackageKit.MediaChangeRequired item);
		[CCode (cname = "pk_results_add_message")]
		public bool add_message (PackageKit.Message item);
		[CCode (cname = "pk_results_add_package")]
		public bool add_package (PackageKit.Package item);
		[CCode (cname = "pk_results_add_repo_detail")]
		public bool add_repo_detail (PackageKit.RepoDetail item);
		[CCode (cname = "pk_results_add_repo_signature_required")]
		public bool add_repo_signature_required (PackageKit.RepoSignatureRequired item);
		[CCode (cname = "pk_results_add_require_restart")]
		public bool add_require_restart (PackageKit.RequireRestart item);
		[CCode (cname = "pk_results_add_transaction")]
		public bool add_transaction (PackageKit.TransactionPast item);
		[CCode (cname = "pk_results_add_update_detail")]
		public bool add_update_detail (PackageKit.UpdateDetail item);
		[CCode (cname = "pk_results_get_category_array")]
		public GLib.GenericArray<weak PackageKit.Category> get_category_array ();
		[CCode (cname = "pk_results_get_details_array")]
		public GLib.GenericArray<weak PackageKit.Details> get_details_array ();
		[CCode (cname = "pk_results_get_distro_upgrade_array")]
		public GLib.GenericArray<weak PackageKit.DistroUpgrade> get_distro_upgrade_array ();
		[CCode (cname = "pk_results_get_error_code")]
		public PackageKit.Error get_error_code ();
		[CCode (cname = "pk_results_get_eula_required_array")]
		public GLib.GenericArray<weak PackageKit.EulaRequired> get_eula_required_array ();
		[CCode (cname = "pk_results_get_exit_code")]
		public PackageKit.Exit get_exit_code ();
		[CCode (cname = "pk_results_get_files_array")]
		public GLib.GenericArray<weak PackageKit.Files> get_files_array ();
		[CCode (cname = "pk_results_get_media_change_required_array")]
		public GLib.GenericArray<weak PackageKit.MediaChangeRequired> get_media_change_required_array ();
		[CCode (cname = "pk_results_get_message_array")]
		public GLib.GenericArray<weak PackageKit.Message> get_message_array ();
		[CCode (cname = "pk_results_get_package_array")]
		public GLib.GenericArray<weak PackageKit.Package> get_package_array ();
		[CCode (cname = "pk_results_get_package_sack")]
		public PackageKit.PackageSack get_package_sack ();
		[CCode (cname = "pk_results_get_repo_detail_array")]
		public GLib.GenericArray<weak PackageKit.RepoDetail> get_repo_detail_array ();
		[CCode (cname = "pk_results_get_repo_signature_required_array")]
		public GLib.GenericArray<weak PackageKit.RepoSignatureRequired> get_repo_signature_required_array ();
		[CCode (cname = "pk_results_get_require_restart_array")]
		public GLib.GenericArray<weak PackageKit.RequireRestart> get_require_restart_array ();
		[CCode (cname = "pk_results_get_require_restart_worst")]
		public PackageKit.Restart get_require_restart_worst ();
		[CCode (cname = "pk_results_get_transaction_array")]
		public GLib.GenericArray<weak PackageKit.TransactionPast> get_transaction_array ();
		[CCode (cname = "pk_results_get_update_detail_array")]
		public GLib.GenericArray<weak PackageKit.UpdateDetail> get_update_detail_array ();
		[CCode (cname = "pk_results_set_error_code")]
		public bool set_error_code (PackageKit.Error item);
		[CCode (cname = "pk_results_set_exit_code")]
		public bool set_exit_code (PackageKit.Exit exit_enum);
		[CCode (cname = "pk_results_test")]
		public static void test (void* user_data);
		[NoAccessorMethod]
		public uint inputs { get; set; }
		[NoAccessorMethod]
		public PackageKit.Progress progress { owned get; set; }
		[NoAccessorMethod]
		public uint role { get; set; }
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", type_id = "pk_service_pack_get_type ()")]
	public class ServicePack : GLib.Object {
		[CCode (cname = "pk_service_pack_new", has_construct_function = false)]
		public ServicePack ();
		[CCode (cname = "pk_service_pack_check_valid")]
		public bool check_valid (string filename) throws GLib.Error;
		[CCode (cname = "pk_service_pack_create_for_package_ids_async")]
		public async void create_for_package_ids_async (string filename, string package_ids, string package_ids_exclude, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_service_pack_create_for_updates_async")]
		public async void create_for_updates_async (string filename, string package_ids_exclude, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_service_pack_generic_finish")]
		public bool generic_finish (GLib.AsyncResult res) throws GLib.Error;
		[CCode (cname = "pk_service_pack_set_temp_directory")]
		public bool set_temp_directory (string directory);
		[CCode (cname = "pk_service_pack_test")]
		public static void test (void* user_data);
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", type_id = "pk_source_get_type ()")]
	public class Source : GLib.Object {
		[CCode (cname = "pk_source_new", has_construct_function = false)]
		public Source ();
		[NoAccessorMethod]
		public uint role { get; set; }
		[NoAccessorMethod]
		public string transaction_id { owned get; set; }
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", type_id = "pk_task_get_type ()")]
	public class Task : PackageKit.Client {
		[CCode (cname = "pk_task_new", has_construct_function = false)]
		public Task ();
		[CCode (cname = "pk_task_download_packages_async")]
		public async void download_packages_async ([CCode (array_length = false, array_null_terminated = true)] string[] package_ids, string directory, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_task_download_packages_sync")]
		public PackageKit.Results download_packages_sync ([CCode (array_length = false, array_null_terminated = true)] string[] package_ids, string directory, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[NoWrapper]
		public virtual void eula_question (uint request, PackageKit.Results results);
		[CCode (cname = "pk_task_generic_finish")]
		public PackageKit.Results generic_finish (GLib.AsyncResult res) throws GLib.Error;
		[CCode (cname = "pk_task_get_categories_async")]
		public async void get_categories_async (GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_task_get_categories_sync")]
		public PackageKit.Results get_categories_sync (GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_task_get_depends_async")]
		public async void get_depends_async (PackageKit.Bitfield filters, [CCode (array_length = false, array_null_terminated = true)] string[] package_ids, bool recursive, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_task_get_depends_sync")]
		public PackageKit.Results get_depends_sync (PackageKit.Bitfield filters, [CCode (array_length = false, array_null_terminated = true)] string[] package_ids, bool recursive, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_task_get_details_async")]
		public async void get_details_async ([CCode (array_length = false, array_null_terminated = true)] string[] package_ids, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_task_get_details_sync")]
		public PackageKit.Results get_details_sync ([CCode (array_length = false, array_null_terminated = true)] string[] package_ids, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_task_get_files_async")]
		public async void get_files_async ([CCode (array_length = false, array_null_terminated = true)] string[] package_ids, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_task_get_files_sync")]
		public PackageKit.Results get_files_sync ([CCode (array_length = false, array_null_terminated = true)] string[] package_ids, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_task_get_interactive")]
		public bool get_interactive ();
		[CCode (cname = "pk_task_get_packages_async")]
		public async void get_packages_async (PackageKit.Bitfield filters, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_task_get_packages_sync")]
		public PackageKit.Results get_packages_sync (PackageKit.Bitfield filters, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_task_get_repo_list_async")]
		public async void get_repo_list_async (PackageKit.Bitfield filters, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_task_get_repo_list_sync")]
		public PackageKit.Results get_repo_list_sync (PackageKit.Bitfield filters, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_task_get_requires_async")]
		public async void get_requires_async (PackageKit.Bitfield filters, [CCode (array_length = false, array_null_terminated = true)] string[] package_ids, bool recursive, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_task_get_requires_sync")]
		public PackageKit.Results get_requires_sync (PackageKit.Bitfield filters, [CCode (array_length = false, array_null_terminated = true)] string[] package_ids, bool recursive, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_task_get_simulate")]
		public bool get_simulate ();
		[CCode (cname = "pk_task_get_update_detail_async")]
		public async void get_update_detail_async ([CCode (array_length = false, array_null_terminated = true)] string[] package_ids, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_task_get_update_detail_sync")]
		public PackageKit.Results get_update_detail_sync ([CCode (array_length = false, array_null_terminated = true)] string[] package_ids, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_task_get_updates_async")]
		public async void get_updates_async (PackageKit.Bitfield filters, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_task_get_updates_sync")]
		public PackageKit.Results get_updates_sync (PackageKit.Bitfield filters, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_task_install_files_async")]
		public async void install_files_async ([CCode (array_length = false, array_null_terminated = true)] string[] files, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_task_install_files_sync")]
		public PackageKit.Results install_files_sync ([CCode (array_length = false, array_null_terminated = true)] string[] files, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_task_install_packages_async")]
		public async void install_packages_async ([CCode (array_length = false, array_null_terminated = true)] string[] package_ids, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_task_install_packages_sync")]
		public PackageKit.Results install_packages_sync ([CCode (array_length = false, array_null_terminated = true)] string[] package_ids, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[NoWrapper]
		public virtual void key_question (uint request, PackageKit.Results results);
		[NoWrapper]
		public virtual void media_change_question (uint request, PackageKit.Results results);
		[CCode (cname = "pk_task_refresh_cache_async")]
		public async void refresh_cache_async (bool force, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_task_refresh_cache_sync")]
		public PackageKit.Results refresh_cache_sync (bool force, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_task_remove_packages_async")]
		public async void remove_packages_async ([CCode (array_length = false, array_null_terminated = true)] string[] package_ids, bool allow_deps, bool autoremove, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_task_remove_packages_sync")]
		public PackageKit.Results remove_packages_sync ([CCode (array_length = false, array_null_terminated = true)] string[] package_ids, bool allow_deps, bool autoremove, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_task_repair_system_async")]
		public async void repair_system_async (GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_task_repair_system_sync")]
		public PackageKit.Results repair_system_sync (GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_task_repo_enable_async")]
		public async void repo_enable_async (string repo_id, bool enabled, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_task_repo_enable_sync")]
		public PackageKit.Results repo_enable_sync (string repo_id, bool enabled, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_task_resolve_async")]
		public async void resolve_async (PackageKit.Bitfield filters, string packages, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_task_resolve_sync")]
		public PackageKit.Results resolve_sync (PackageKit.Bitfield filters, string packages, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_task_rollback_async")]
		public async void rollback_async (string transaction_id, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_task_rollback_sync")]
		public PackageKit.Results rollback_sync (string transaction_id, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_task_search_details_async")]
		public async void search_details_async (PackageKit.Bitfield filters, [CCode (array_length = false, array_null_terminated = true)] string[] values, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_task_search_details_sync")]
		public PackageKit.Results search_details_sync (PackageKit.Bitfield filters, [CCode (array_length = false, array_null_terminated = true)] string[] values, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_task_search_files_async")]
		public async void search_files_async (PackageKit.Bitfield filters, [CCode (array_length = false, array_null_terminated = true)] string[] values, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_task_search_files_sync")]
		public PackageKit.Results search_files_sync (PackageKit.Bitfield filters, [CCode (array_length = false, array_null_terminated = true)] string[] values, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_task_search_groups_async")]
		public async void search_groups_async (PackageKit.Bitfield filters, [CCode (array_length = false, array_null_terminated = true)] string[] values, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_task_search_groups_sync")]
		public PackageKit.Results search_groups_sync (PackageKit.Bitfield filters, [CCode (array_length = false, array_null_terminated = true)] string[] values, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_task_search_names_async")]
		public async void search_names_async (PackageKit.Bitfield filters, [CCode (array_length = false, array_null_terminated = true)] string[] values, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_task_search_names_sync")]
		public PackageKit.Results search_names_sync (PackageKit.Bitfield filters, [CCode (array_length = false, array_null_terminated = true)] string[] values, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_task_set_interactive")]
		public void set_interactive (bool interactive);
		[CCode (cname = "pk_task_set_simulate")]
		public void set_simulate (bool simulate);
		[NoWrapper]
		public virtual void simulate_question (uint request, PackageKit.Results results);
		[CCode (cname = "pk_task_test")]
		public static void test (void* user_data);
		[NoWrapper]
		public virtual void untrusted_question (uint request, PackageKit.Results results);
		[CCode (cname = "pk_task_update_packages_async")]
		public async void update_packages_async ([CCode (array_length = false, array_null_terminated = true)] string[] package_ids, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_task_update_packages_sync")]
		public PackageKit.Results update_packages_sync ([CCode (array_length = false, array_null_terminated = true)] string[] package_ids, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_task_update_system_async")]
		public async void update_system_async (GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_task_update_system_sync")]
		public PackageKit.Results update_system_sync (GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[CCode (cname = "pk_task_user_accepted")]
		public bool user_accepted (uint request);
		[CCode (cname = "pk_task_user_declined")]
		public bool user_declined (uint request);
		[CCode (cname = "pk_task_what_provides_async")]
		public async void what_provides_async (PackageKit.Bitfield filters, PackageKit.Provides provides, [CCode (array_length = false, array_null_terminated = true)] string[] values, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback);
		[CCode (cname = "pk_task_what_provides_sync")]
		public PackageKit.Results what_provides_sync (PackageKit.Bitfield filters, PackageKit.Provides provides, [CCode (array_length = false, array_null_terminated = true)] string[] values, GLib.Cancellable? cancellable, PackageKit.ProgressCallback progress_callback) throws GLib.Error;
		[NoAccessorMethod]
		public bool interactive { get; set; }
		[NoAccessorMethod]
		public bool simulate { get; set; }
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", type_id = "pk_transaction_list_get_type ()")]
	public class TransactionList : GLib.Object {
		[CCode (cname = "pk_transaction_list_new", has_construct_function = false)]
		public TransactionList ();
		[CCode (array_length = false, array_null_terminated = true, cname = "pk_transaction_list_get_ids")]
		public string[] get_ids ();
		[CCode (cname = "pk_transaction_list_test")]
		public static void test (void* user_data);
		public virtual signal void added (string tid);
		public virtual signal void removed (string tid);
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", type_id = "pk_transaction_past_get_type ()")]
	public class TransactionPast : PackageKit.Source {
		[CCode (cname = "pk_transaction_past_new", has_construct_function = false)]
		public TransactionPast ();
		[NoAccessorMethod]
		public string cmdline { owned get; set; }
		[NoAccessorMethod]
		public string data { owned get; set; }
		[NoAccessorMethod]
		public uint duration { get; set; }
		[NoAccessorMethod]
		public uint role { get; set; }
		[NoAccessorMethod]
		public bool succeeded { get; set; }
		[NoAccessorMethod]
		public string tid { owned get; set; }
		[NoAccessorMethod]
		public string timespec { owned get; set; }
		[NoAccessorMethod]
		public uint uid { get; set; }
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", type_id = "pk_update_detail_get_type ()")]
	public class UpdateDetail : PackageKit.Source {
		[CCode (cname = "pk_update_detail_new", has_construct_function = false)]
		public UpdateDetail ();
		[NoAccessorMethod]
		public string bugzilla_url { owned get; set; }
		[NoAccessorMethod]
		public string changelog { owned get; set; }
		[NoAccessorMethod]
		public string cve_url { owned get; set; }
		[NoAccessorMethod]
		public string issued { owned get; set; }
		[NoAccessorMethod]
		public string obsoletes { owned get; set; }
		[NoAccessorMethod]
		public string package_id { owned get; set; }
		[NoAccessorMethod]
		public uint restart { get; set; }
		[NoAccessorMethod]
		public uint state { get; set; }
		[NoAccessorMethod]
		public string update_text { owned get; set; }
		[NoAccessorMethod]
		public string updated { owned get; set; }
		[NoAccessorMethod]
		public string updates { owned get; set; }
		[NoAccessorMethod]
		public string vendor_url { owned get; set; }
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h")]
	[SimpleType]
	public struct Bitfield : uint64 {
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", has_type_id = false)]
	public struct EnumMatch {
		public uint value;
		public weak global::string string;
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PkAuthorizeEnum", cprefix = "PK_AUTHORIZE_ENUM_")]
	[GIR (name = "AuthorizeEnum")]
	public enum Authorize {
		UNKNOWN,
		YES,
		NO,
		INTERACTIVE,
		LAST
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PkDistroUpgradeEnum", cprefix = "PK_DISTRO_UPGRADE_ENUM_")]
	[GIR (name = "DistroUpgradeEnum")]
	public enum DistroUpgradeType {
		UNKNOWN,
		STABLE,
		UNSTABLE,
		LAST
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PkErrorEnum", cprefix = "PK_ERROR_ENUM_")]
	[GIR (name = "ErrorEnum")]
	public enum ErrorType {
		UNKNOWN,
		OOM,
		NO_NETWORK,
		NOT_SUPPORTED,
		INTERNAL_ERROR,
		GPG_FAILURE,
		PACKAGE_ID_INVALID,
		PACKAGE_NOT_INSTALLED,
		PACKAGE_NOT_FOUND,
		PACKAGE_ALREADY_INSTALLED,
		PACKAGE_DOWNLOAD_FAILED,
		GROUP_NOT_FOUND,
		GROUP_LIST_INVALID,
		DEP_RESOLUTION_FAILED,
		FILTER_INVALID,
		CREATE_THREAD_FAILED,
		TRANSACTION_ERROR,
		TRANSACTION_CANCELLED,
		NO_CACHE,
		REPO_NOT_FOUND,
		CANNOT_REMOVE_SYSTEM_PACKAGE,
		PROCESS_KILL,
		FAILED_INITIALIZATION,
		FAILED_FINALISE,
		FAILED_CONFIG_PARSING,
		CANNOT_CANCEL,
		CANNOT_GET_LOCK,
		NO_PACKAGES_TO_UPDATE,
		CANNOT_WRITE_REPO_CONFIG,
		LOCAL_INSTALL_FAILED,
		BAD_GPG_SIGNATURE,
		MISSING_GPG_SIGNATURE,
		CANNOT_INSTALL_SOURCE_PACKAGE,
		REPO_CONFIGURATION_ERROR,
		NO_LICENSE_AGREEMENT,
		FILE_CONFLICTS,
		PACKAGE_CONFLICTS,
		REPO_NOT_AVAILABLE,
		INVALID_PACKAGE_FILE,
		PACKAGE_INSTALL_BLOCKED,
		PACKAGE_CORRUPT,
		ALL_PACKAGES_ALREADY_INSTALLED,
		FILE_NOT_FOUND,
		NO_MORE_MIRRORS_TO_TRY,
		NO_DISTRO_UPGRADE_DATA,
		INCOMPATIBLE_ARCHITECTURE,
		NO_SPACE_ON_DEVICE,
		MEDIA_CHANGE_REQUIRED,
		NOT_AUTHORIZED,
		UPDATE_NOT_FOUND,
		CANNOT_INSTALL_REPO_UNSIGNED,
		CANNOT_UPDATE_REPO_UNSIGNED,
		CANNOT_GET_FILELIST,
		CANNOT_GET_REQUIRES,
		CANNOT_DISABLE_REPOSITORY,
		RESTRICTED_DOWNLOAD,
		PACKAGE_FAILED_TO_CONFIGURE,
		PACKAGE_FAILED_TO_BUILD,
		PACKAGE_FAILED_TO_INSTALL,
		PACKAGE_FAILED_TO_REMOVE,
		UPDATE_FAILED_DUE_TO_RUNNING_PROCESS,
		PACKAGE_DATABASE_CHANGED,
		PROVIDE_TYPE_NOT_SUPPORTED,
		INSTALL_ROOT_INVALID,
		CANNOT_FETCH_SOURCES,
		CANCELLED_PRIORITY,
		UNFINISHED_TRANSACTION,
		LAST
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PkExitEnum", cprefix = "PK_EXIT_ENUM_")]
	[GIR (name = "ExitEnum")]
	public enum Exit {
		UNKNOWN,
		SUCCESS,
		FAILED,
		CANCELLED,
		KEY_REQUIRED,
		EULA_REQUIRED,
		KILLED,
		MEDIA_CHANGE_REQUIRED,
		NEED_UNTRUSTED,
		CANCELLED_PRIORITY,
		SKIP_TRANSACTION,
		REPAIR_REQUIRED,
		LAST
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PkFilterEnum", cprefix = "PK_FILTER_ENUM_")]
	[GIR (name = "FilterEnum")]
	public enum Filter {
		UNKNOWN,
		NONE,
		INSTALLED,
		NOT_INSTALLED,
		DEVELOPMENT,
		NOT_DEVELOPMENT,
		GUI,
		NOT_GUI,
		FREE,
		NOT_FREE,
		VISIBLE,
		NOT_VISIBLE,
		SUPPORTED,
		NOT_SUPPORTED,
		BASENAME,
		NOT_BASENAME,
		NEWEST,
		NOT_NEWEST,
		ARCH,
		NOT_ARCH,
		SOURCE,
		NOT_SOURCE,
		COLLECTIONS,
		NOT_COLLECTIONS,
		APPLICATION,
		NOT_APPLICATION,
		LAST
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PkGroupEnum", cprefix = "PK_GROUP_ENUM_")]
	[GIR (name = "GroupEnum")]
	public enum Group {
		UNKNOWN,
		ACCESSIBILITY,
		ACCESSORIES,
		ADMIN_TOOLS,
		COMMUNICATION,
		DESKTOP_GNOME,
		DESKTOP_KDE,
		DESKTOP_OTHER,
		DESKTOP_XFCE,
		EDUCATION,
		FONTS,
		GAMES,
		GRAPHICS,
		INTERNET,
		LEGACY,
		LOCALIZATION,
		MAPS,
		MULTIMEDIA,
		NETWORK,
		OFFICE,
		OTHER,
		POWER_MANAGEMENT,
		PROGRAMMING,
		PUBLISHING,
		REPOS,
		SECURITY,
		SERVERS,
		SYSTEM,
		VIRTUALIZATION,
		SCIENCE,
		DOCUMENTATION,
		ELECTRONICS,
		COLLECTIONS,
		VENDOR,
		NEWEST,
		LAST
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PkInfoEnum", cprefix = "PK_INFO_ENUM_")]
	[GIR (name = "InfoEnum")]
	public enum Info {
		UNKNOWN,
		INSTALLED,
		AVAILABLE,
		LOW,
		ENHANCEMENT,
		NORMAL,
		BUGFIX,
		IMPORTANT,
		SECURITY,
		BLOCKED,
		DOWNLOADING,
		UPDATING,
		INSTALLING,
		REMOVING,
		CLEANUP,
		OBSOLETING,
		COLLECTION_INSTALLED,
		COLLECTION_AVAILABLE,
		FINISHED,
		REINSTALLING,
		DOWNGRADING,
		PREPARING,
		DECOMPRESSING,
		UNTRUSTED,
		TRUSTED,
		LAST
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PkMediaTypeEnum", cprefix = "PK_MEDIA_TYPE_ENUM_")]
	[GIR (name = "MediaTypeEnum")]
	public enum MediaType {
		UNKNOWN,
		CD,
		DVD,
		DISC,
		LAST
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PkMessageEnum", cprefix = "PK_MESSAGE_ENUM_")]
	[GIR (name = "MessageEnum")]
	public enum MessageType {
		UNKNOWN,
		BROKEN_MIRROR,
		CONNECTION_REFUSED,
		PARAMETER_INVALID,
		PRIORITY_INVALID,
		BACKEND_ERROR,
		DAEMON_ERROR,
		CACHE_BEING_REBUILT,
		UNTRUSTED_PACKAGE,
		NEWER_PACKAGE_EXISTS,
		COULD_NOT_FIND_PACKAGE,
		CONFIG_FILES_CHANGED,
		PACKAGE_ALREADY_INSTALLED,
		AUTOREMOVE_IGNORED,
		REPO_METADATA_DOWNLOAD_FAILED,
		REPO_FOR_DEVELOPERS_ONLY,
		OTHER_UPDATES_HELD_BACK,
		LAST
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PkNetworkEnum", cprefix = "PK_NETWORK_ENUM_")]
	[GIR (name = "NetworkEnum")]
	public enum Network {
		UNKNOWN,
		OFFLINE,
		ONLINE,
		WIRED,
		WIFI,
		MOBILE,
		LAST
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cprefix = "PK_PACKAGE_SACK_SORT_TYPE_")]
	public enum PackageSackSortType {
		NAME,
		INFO,
		PACKAGE_ID,
		SUMMARY,
		LAST
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cprefix = "PK_PROGRESS_TYPE_")]
	public enum ProgressType {
		PACKAGE_ID,
		TRANSACTION_ID,
		PERCENTAGE,
		SUBPERCENTAGE,
		ALLOW_CANCEL,
		STATUS,
		ROLE,
		CALLER_ACTIVE,
		ELAPSED_TIME,
		REMAINING_TIME,
		SPEED,
		UID,
		PACKAGE,
		ITEM_PROGRESS,
		INVALID
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PkProvidesEnum", cprefix = "PK_PROVIDES_ENUM_")]
	[GIR (name = "ProvidesEnum")]
	public enum Provides {
		UNKNOWN,
		ANY,
		MODALIAS,
		CODEC,
		MIMETYPE,
		FONT,
		HARDWARE_DRIVER,
		POSTSCRIPT_DRIVER,
		PLASMA_SERVICE,
		SHARED_LIB,
		PYTHON,
		LANGUAGE_SUPPORT,
		LAST
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PkRestartEnum", cprefix = "PK_RESTART_ENUM_")]
	[GIR (name = "RestartEnum")]
	public enum Restart {
		UNKNOWN,
		NONE,
		APPLICATION,
		SESSION,
		SYSTEM,
		SECURITY_SESSION,
		SECURITY_SYSTEM,
		LAST
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PkRoleEnum", cprefix = "PK_ROLE_ENUM_")]
	[GIR (name = "RoleEnum")]
	public enum Role {
		UNKNOWN,
		CANCEL,
		GET_DEPENDS,
		GET_DETAILS,
		GET_FILES,
		GET_PACKAGES,
		GET_REPO_LIST,
		GET_REQUIRES,
		GET_UPDATE_DETAIL,
		GET_UPDATES,
		INSTALL_FILES,
		INSTALL_PACKAGES,
		INSTALL_SIGNATURE,
		REFRESH_CACHE,
		REMOVE_PACKAGES,
		REPO_ENABLE,
		REPO_SET_DATA,
		RESOLVE,
		ROLLBACK,
		SEARCH_DETAILS,
		SEARCH_FILE,
		SEARCH_GROUP,
		SEARCH_NAME,
		UPDATE_PACKAGES,
		UPDATE_SYSTEM,
		WHAT_PROVIDES,
		ACCEPT_EULA,
		DOWNLOAD_PACKAGES,
		GET_DISTRO_UPGRADES,
		GET_CATEGORIES,
		GET_OLD_TRANSACTIONS,
		SIMULATE_INSTALL_FILES,
		SIMULATE_INSTALL_PACKAGES,
		SIMULATE_REMOVE_PACKAGES,
		SIMULATE_UPDATE_PACKAGES,
		UPGRADE_SYSTEM,
		REPAIR_SYSTEM,
		SIMULATE_REPAIR_SYSTEM,
		LAST
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PkSigTypeEnum", cprefix = "PK_SIGTYPE_ENUM_")]
	[GIR (name = "SigTypeEnum")]
	public enum SigType {
		UNKNOWN,
		GPG,
		LAST
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PkStatusEnum", cprefix = "PK_STATUS_ENUM_")]
	[GIR (name = "StatusEnum")]
	public enum Status {
		UNKNOWN,
		WAIT,
		SETUP,
		RUNNING,
		QUERY,
		INFO,
		REMOVE,
		REFRESH_CACHE,
		DOWNLOAD,
		INSTALL,
		UPDATE,
		CLEANUP,
		OBSOLETE,
		DEP_RESOLVE,
		SIG_CHECK,
		ROLLBACK,
		TEST_COMMIT,
		COMMIT,
		REQUEST,
		FINISHED,
		CANCEL,
		DOWNLOAD_REPOSITORY,
		DOWNLOAD_PACKAGELIST,
		DOWNLOAD_FILELIST,
		DOWNLOAD_CHANGELOG,
		DOWNLOAD_GROUP,
		DOWNLOAD_UPDATEINFO,
		REPACKAGING,
		LOADING_CACHE,
		SCAN_APPLICATIONS,
		GENERATE_PACKAGE_LIST,
		WAITING_FOR_LOCK,
		WAITING_FOR_AUTH,
		SCAN_PROCESS_LIST,
		CHECK_EXECUTABLE_FILES,
		CHECK_LIBRARIES,
		COPY_FILES,
		LAST
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PkUpdateStateEnum", cprefix = "PK_UPDATE_STATE_ENUM_")]
	[GIR (name = "UpdateStateEnum")]
	public enum UpdateState {
		UNKNOWN,
		STABLE,
		UNSTABLE,
		TESTING,
		LAST
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PkUpgradeKindEnum", cprefix = "PK_UPGRADE_KIND_ENUM_")]
	[GIR (name = "UpgradeKindEnum")]
	public enum UpgradeKind {
		UNKNOWN,
		MINIMAL,
		DEFAULT,
		COMPLETE,
		LAST
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cprefix = "PK_CATALOG_ERROR_")]
	public errordomain CatalogError {
		FAILED
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cprefix = "PK_CLIENT_ERROR_")]
	public errordomain ClientError {
		FAILED,
		FAILED_AUTH,
		NO_TID,
		ALREADY_TID,
		ROLE_UNKNOWN,
		CANNOT_START_DAEMON,
		INVALID_INPUT,
		INVALID_FILE,
		NOT_SUPPORTED,
		DECLINED_SIMULATION,
		LAST
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cprefix = "PK_CONTROL_ERROR_")]
	public errordomain ControlError {
		FAILED,
		CANNOT_START_DAEMON
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cprefix = "PK_SERVICE_PACK_ERROR_")]
	public errordomain ServicePackError {
		FAILED_SETUP,
		FAILED_DOWNLOAD,
		FAILED_EXTRACTION,
		FAILED_CREATE,
		NOTHING_TO_DO,
		NOT_COMPATIBLE
	}
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", instance_pos = 1.9)]
	public delegate bool PackageSackFilterFunc (PackageKit.Package package);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", instance_pos = 2.9)]
	public delegate void ProgressCallback (PackageKit.Progress progress, PackageKit.ProgressType type);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PK_CATALOG_FILE_EXTENSION")]
	public const string CATALOG_FILE_EXTENSION;
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PK_CATALOG_FILE_HEADER")]
	public const string CATALOG_FILE_HEADER;
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PK_DBUS_INTERFACE")]
	public const string DBUS_INTERFACE;
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PK_DBUS_INTERFACE_TRANSACTION")]
	public const string DBUS_INTERFACE_TRANSACTION;
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PK_DBUS_PATH")]
	public const string DBUS_PATH;
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PK_DBUS_SERVICE")]
	public const string DBUS_SERVICE;
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PK_DESKTOP_DEFAULT_APPLICATION_DIR")]
	public const string DESKTOP_DEFAULT_APPLICATION_DIR;
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PK_MAJOR_VERSION")]
	public const int MAJOR_VERSION;
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PK_MICRO_VERSION")]
	public const int MICRO_VERSION;
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PK_MINOR_VERSION")]
	public const int MINOR_VERSION;
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PK_PACKAGE_IDS_DELIM")]
	public const string PACKAGE_IDS_DELIM;
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PK_PACKAGE_ID_ARCH")]
	public const int PACKAGE_ID_ARCH;
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PK_PACKAGE_ID_DATA")]
	public const int PACKAGE_ID_DATA;
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PK_PACKAGE_ID_NAME")]
	public const int PACKAGE_ID_NAME;
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PK_PACKAGE_ID_VERSION")]
	public const int PACKAGE_ID_VERSION;
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PK_SERVICE_PACK_FILE_EXTENSION")]
	public const string SERVICE_PACK_FILE_EXTENSION;
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PK_SERVICE_PACK_GROUP_NAME")]
	public const string SERVICE_PACK_GROUP_NAME;
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "PK_SYSTEM_PACKAGE_LIST_FILENAME")]
	public const string SYSTEM_PACKAGE_LIST_FILENAME;
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_authorize_type_enum_from_string")]
	public static PackageKit.Authorize authorize_type_enum_from_string (string authorize_type);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_authorize_type_enum_to_string")]
	public static unowned string authorize_type_enum_to_string (PackageKit.Authorize authorize_type);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_bitfield_test")]
	public static void bitfield_test (void* user_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_catalog_error_quark")]
	public static GLib.Quark catalog_error_quark ();
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_client_error_quark")]
	public static GLib.Quark client_error_quark ();
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_common_test")]
	public static void common_test (void* user_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_control_error_quark")]
	public static GLib.Quark control_error_quark ();
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_debug_add_log_domain")]
	public static void debug_add_log_domain (string log_domain);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_debug_is_verbose")]
	public static bool debug_is_verbose ();
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_debug_set_verbose")]
	public static void debug_set_verbose (bool verbose);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_distro_upgrade_enum_from_string")]
	public static PackageKit.DistroUpgradeType distro_upgrade_enum_from_string (string upgrade);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_distro_upgrade_enum_to_string")]
	public static unowned string distro_upgrade_enum_to_string (PackageKit.DistroUpgradeType upgrade);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_enum_find_string")]
	public static unowned string enum_find_string (PackageKit.EnumMatch table, uint value);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_enum_find_value")]
	public static uint enum_find_value (PackageKit.EnumMatch table, string string);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_enum_test")]
	public static void enum_test (void* user_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_error_enum_from_string")]
	public static PackageKit.ErrorType error_enum_from_string (string code);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_error_enum_to_string")]
	public static unowned string error_enum_to_string (PackageKit.ErrorType code);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_exit_enum_from_string")]
	public static PackageKit.Exit exit_enum_from_string (string exit);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_exit_enum_to_string")]
	public static unowned string exit_enum_to_string (PackageKit.Exit exit);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_filter_bitfield_from_string")]
	public static PackageKit.Bitfield filter_bitfield_from_string (string filters);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_filter_bitfield_to_string")]
	public static string filter_bitfield_to_string (PackageKit.Bitfield filters);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_filter_enum_from_string")]
	public static PackageKit.Filter filter_enum_from_string (string filter);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_filter_enum_to_string")]
	public static unowned string filter_enum_to_string (PackageKit.Filter filter);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_get_distro_id")]
	public static string get_distro_id ();
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_group_bitfield_from_string")]
	public static PackageKit.Bitfield group_bitfield_from_string (string groups);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_group_bitfield_to_string")]
	public static string group_bitfield_to_string (PackageKit.Bitfield groups);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_group_enum_from_string")]
	public static PackageKit.Group group_enum_from_string (string group);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_group_enum_to_string")]
	public static unowned string group_enum_to_string (PackageKit.Group group);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_info_enum_from_string")]
	public static PackageKit.Info info_enum_from_string (string info);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_info_enum_to_localised_past")]
	public static unowned string info_enum_to_localised_past (PackageKit.Info info);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_info_enum_to_localised_present")]
	public static unowned string info_enum_to_localised_present (PackageKit.Info info);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_info_enum_to_string")]
	public static unowned string info_enum_to_string (PackageKit.Info info);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_iso8601_from_date")]
	public static string iso8601_from_date (GLib.Date date);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_iso8601_present")]
	public static string iso8601_present ();
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_marshal_VOID__POINTER_UINT_STRING")]
	public static void marshal_VOID__POINTER_UINT_STRING (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_marshal_VOID__POINTER_UINT_UINT")]
	public static void marshal_VOID__POINTER_UINT_UINT (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_marshal_VOID__STRING_BOOLEAN")]
	public static void marshal_VOID__STRING_BOOLEAN (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_marshal_VOID__STRING_BOXED")]
	public static void marshal_VOID__STRING_BOXED (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_marshal_VOID__STRING_STRING")]
	public static void marshal_VOID__STRING_STRING (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_marshal_VOID__STRING_STRING_BOOLEAN")]
	public static void marshal_VOID__STRING_STRING_BOOLEAN (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_marshal_VOID__STRING_STRING_BOOLEAN_STRING_UINT_STRING_UINT_STRING")]
	public static void marshal_VOID__STRING_STRING_BOOLEAN_STRING_UINT_STRING_UINT_STRING (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_marshal_VOID__STRING_STRING_BOOLEAN_UINT_UINT_STRING_UINT_STRING")]
	public static void marshal_VOID__STRING_STRING_BOOLEAN_UINT_UINT_STRING_UINT_STRING (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_marshal_VOID__STRING_STRING_STRING")]
	public static void marshal_VOID__STRING_STRING_STRING (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_marshal_VOID__STRING_STRING_STRING_BOOLEAN")]
	public static void marshal_VOID__STRING_STRING_STRING_BOOLEAN (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_marshal_VOID__STRING_STRING_STRING_BOOLEAN_STRING_UINT_STRING_UINT_STRING")]
	public static void marshal_VOID__STRING_STRING_STRING_BOOLEAN_STRING_UINT_STRING_UINT_STRING (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_marshal_VOID__STRING_STRING_STRING_STRING")]
	public static void marshal_VOID__STRING_STRING_STRING_STRING (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_marshal_VOID__STRING_STRING_STRING_STRING_STRING")]
	public static void marshal_VOID__STRING_STRING_STRING_STRING_STRING (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_marshal_VOID__STRING_STRING_STRING_STRING_STRING_STRING")]
	public static void marshal_VOID__STRING_STRING_STRING_STRING_STRING_STRING (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_marshal_VOID__STRING_STRING_STRING_STRING_STRING_STRING_STRING")]
	public static void marshal_VOID__STRING_STRING_STRING_STRING_STRING_STRING_STRING (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_marshal_VOID__STRING_STRING_STRING_STRING_STRING_STRING_STRING_STRING")]
	public static void marshal_VOID__STRING_STRING_STRING_STRING_STRING_STRING_STRING_STRING (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_marshal_VOID__STRING_STRING_STRING_STRING_STRING_STRING_STRING_STRING_STRING")]
	public static void marshal_VOID__STRING_STRING_STRING_STRING_STRING_STRING_STRING_STRING_STRING (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_marshal_VOID__STRING_STRING_STRING_STRING_STRING_STRING_STRING_STRING_STRING_STRING")]
	public static void marshal_VOID__STRING_STRING_STRING_STRING_STRING_STRING_STRING_STRING_STRING_STRING (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_marshal_VOID__STRING_STRING_STRING_STRING_STRING_STRING_STRING_STRING_STRING_STRING_STRING")]
	public static void marshal_VOID__STRING_STRING_STRING_STRING_STRING_STRING_STRING_STRING_STRING_STRING_STRING (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_marshal_VOID__STRING_STRING_STRING_STRING_STRING_STRING_STRING_STRING_STRING_STRING_STRING_STRING")]
	public static void marshal_VOID__STRING_STRING_STRING_STRING_STRING_STRING_STRING_STRING_STRING_STRING_STRING_STRING (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_marshal_VOID__STRING_STRING_STRING_STRING_STRING_STRING_STRING_UINT")]
	public static void marshal_VOID__STRING_STRING_STRING_STRING_STRING_STRING_STRING_UINT (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_marshal_VOID__STRING_STRING_STRING_STRING_STRING_STRING_UINT")]
	public static void marshal_VOID__STRING_STRING_STRING_STRING_STRING_STRING_UINT (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_marshal_VOID__STRING_STRING_STRING_STRING_STRING_STRING_UINT64")]
	public static void marshal_VOID__STRING_STRING_STRING_STRING_STRING_STRING_UINT64 (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_marshal_VOID__STRING_STRING_STRING_STRING_STRING_STRING_UINT_STRING")]
	public static void marshal_VOID__STRING_STRING_STRING_STRING_STRING_STRING_UINT_STRING (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_marshal_VOID__STRING_STRING_STRING_STRING_STRING_UINT64")]
	public static void marshal_VOID__STRING_STRING_STRING_STRING_STRING_UINT64 (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_marshal_VOID__STRING_STRING_UINT")]
	public static void marshal_VOID__STRING_STRING_UINT (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_marshal_VOID__STRING_STRING_UINT_STRING_STRING_UINT64")]
	public static void marshal_VOID__STRING_STRING_UINT_STRING_STRING_UINT64 (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_marshal_VOID__STRING_STRING_UINT_UINT_UINT")]
	public static void marshal_VOID__STRING_STRING_UINT_UINT_UINT (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_marshal_VOID__STRING_UINT")]
	public static void marshal_VOID__STRING_UINT (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_marshal_VOID__STRING_UINT_STRING_STRING")]
	public static void marshal_VOID__STRING_UINT_STRING_STRING (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_marshal_VOID__STRING_UINT_UINT_UINT_UINT")]
	public static void marshal_VOID__STRING_UINT_UINT_UINT_UINT (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_marshal_VOID__UINT_STRING")]
	public static void marshal_VOID__UINT_STRING (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_marshal_VOID__UINT_STRING_STRING")]
	public static void marshal_VOID__UINT_STRING_STRING (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_marshal_VOID__UINT_STRING_UINT")]
	public static void marshal_VOID__UINT_STRING_UINT (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_marshal_VOID__UINT_UINT")]
	public static void marshal_VOID__UINT_UINT (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_marshal_VOID__UINT_UINT_UINT_UINT")]
	public static void marshal_VOID__UINT_UINT_UINT_UINT (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_media_type_enum_from_string")]
	public static PackageKit.MediaType media_type_enum_from_string (string media_type);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_media_type_enum_to_string")]
	public static unowned string media_type_enum_to_string (PackageKit.MediaType media_type);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_message_enum_from_string")]
	public static PackageKit.MessageType message_enum_from_string (string message);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_message_enum_to_string")]
	public static unowned string message_enum_to_string (PackageKit.MessageType message);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_network_enum_from_string")]
	public static PackageKit.Network network_enum_from_string (string network);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_network_enum_to_string")]
	public static unowned string network_enum_to_string (PackageKit.Network network);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_provides_enum_from_string")]
	public static PackageKit.Provides provides_enum_from_string (string provides);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_provides_enum_to_string")]
	public static unowned string provides_enum_to_string (PackageKit.Provides provides);
	[CCode (array_length = false, array_null_terminated = true, cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_ptr_array_to_strv")]
	public static string[] ptr_array_to_strv (GLib.GenericArray<void*> array);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_restart_enum_from_string")]
	public static PackageKit.Restart restart_enum_from_string (string restart);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_restart_enum_to_string")]
	public static unowned string restart_enum_to_string (PackageKit.Restart restart);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_role_bitfield_from_string")]
	public static PackageKit.Bitfield role_bitfield_from_string (string roles);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_role_bitfield_to_string")]
	public static string role_bitfield_to_string (PackageKit.Bitfield roles);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_role_enum_from_string")]
	public static PackageKit.Role role_enum_from_string (string role);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_role_enum_to_localised_present")]
	public static unowned string role_enum_to_localised_present (PackageKit.Role role);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_role_enum_to_string")]
	public static unowned string role_enum_to_string (PackageKit.Role role);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_service_pack_error_quark")]
	public static GLib.Quark service_pack_error_quark ();
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_sig_type_enum_from_string")]
	public static PackageKit.SigType sig_type_enum_from_string (string sig_type);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_sig_type_enum_to_string")]
	public static unowned string sig_type_enum_to_string (PackageKit.SigType sig_type);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_status_enum_from_string")]
	public static PackageKit.Status status_enum_from_string (string status);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_status_enum_to_localised_text")]
	public static unowned string status_enum_to_localised_text (PackageKit.Status status);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_status_enum_to_string")]
	public static unowned string status_enum_to_string (PackageKit.Status status);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_update_state_enum_from_string")]
	public static PackageKit.UpdateState update_state_enum_from_string (string update_state);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_update_state_enum_to_string")]
	public static unowned string update_state_enum_to_string (PackageKit.UpdateState update_state);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_upgrade_kind_enum_from_string")]
	public static PackageKit.UpgradeKind upgrade_kind_enum_from_string (string upgrade_kind);
	[CCode (cheader_filename = "packagekit-glib2/packagekit.h", cname = "pk_upgrade_kind_enum_to_string")]
	public static unowned string upgrade_kind_enum_to_string (PackageKit.UpgradeKind upgrade_kind);
}
