/* Generated by GOB (v2.0.15)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 15

#define selfp (self->_priv)

#include "lm-applet.h"

#include "lm-applet-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 30 "src/lm-applet.gob"

#include <string.h>
#include <glib/gi18n.h>
#include <panel-applet-gconf.h>
#include "lm-util.h"
#include "lm-preferences-dialog.h"
#include "lm-about-dialog.h"
#include "lm-icmp.h"
#include "lm-host-frontend.h"
#include "lm-bar-graph.h"
#include "lm-line-graph.h"
#include "lm-line-graph-icon.h"
#include "lm-color-generator.h"

#define ICON_PADDING			1

#define BAR_SPACING			3

#define NUM_HOST_COLORS			500

#define CONF_HOSTS			"hosts"
#define CONF_DELAY			"delay"
#define CONF_SCALE			"scale"
#define CONF_TOOLTIP_GRAPH_SPAN		"tooltip_graph_span"
#define CONF_PREFERENCES_WIDTH		"preferences_width"
#define CONF_PREFERENCES_HEIGHT		"preferences_height"

/* keep in sync with link-monitor-applet.schemas */

#define DEFAULT_DELAY			1000
#define DEFAULT_SCALE			500
#define DEFAULT_TOOLTIP_GRAPH_SPAN	60
#define DEFAULT_PREFERENCES_WIDTH	-1
#define DEFAULT_PREFERENCES_HEIGHT	400

/* keep in sync with preferences.glade and LMPreferencesDialog */

#define MIN_DELAY			200
#define MIN_SCALE			1
#define MIN_TOOLTIP_GRAPH_SPAN		10

#line 66 "lm-applet.c"
/* self casting macros */
#define SELF(x) LM_APPLET(x)
#define SELF_CONST(x) LM_APPLET_CONST(x)
#define IS_SELF(x) LM_IS_APPLET(x)
#define TYPE_SELF LM_TYPE_APPLET
#define SELF_CLASS(x) LM_APPLET_CLASS(x)

#define SELF_GET_CLASS(x) LM_APPLET_GET_CLASS(x)

/* self typedefs */
typedef LMApplet Self;
typedef LMAppletClass SelfClass;

/* here are local prototypes */
static void ___object_set_property (GObject *object, guint property_id, const GValue *value, GParamSpec *pspec);
static void ___object_get_property (GObject *object, guint property_id, GValue *value, GParamSpec *pspec);
#line 0 "src/lm-applet.gob"
static void lm_applet_init (LMApplet * o);
#line 85 "lm-applet.c"
static void ___real_lm_applet_activate (LMApplet * self);
#line 146 "src/lm-applet.gob"
static void lm_applet_activate (LMApplet * self);
#line 89 "lm-applet.c"
static void ___real_lm_applet_activate_preferences (LMApplet * self);
#line 152 "src/lm-applet.gob"
static void lm_applet_activate_preferences (LMApplet * self);
#line 93 "lm-applet.c"
#line 158 "src/lm-applet.gob"
static void lm_applet_class_init (LMAppletClass * class);
#line 96 "lm-applet.c"
#line 173 "src/lm-applet.gob"
static gboolean lm_applet_factory_cb (PanelApplet * applet, const char * iid, gpointer data);
#line 99 "lm-applet.c"
#line 267 "src/lm-applet.gob"
static void lm_applet_destroy_h (GtkObject * object, gpointer user_data);
#line 102 "lm-applet.c"
#line 289 "src/lm-applet.gob"
static void lm_applet_reconfigure (LMApplet * self);
#line 105 "lm-applet.c"
#line 300 "src/lm-applet.gob"
static gboolean lm_applet_reconfigure_timeout_cb (gpointer data);
#line 108 "lm-applet.c"
#line 311 "src/lm-applet.gob"
static void lm_applet_change_background_h (PanelApplet * applet, PanelAppletBackgroundType type, GdkColor * color, GdkPixmap * pixmap, gpointer user_data);
#line 111 "lm-applet.c"
#line 350 "src/lm-applet.gob"
static void lm_applet_style_set_h (GtkWidget * widget, GtkStyle * previous_style, gpointer user_data);
#line 114 "lm-applet.c"
#line 365 "src/lm-applet.gob"
static gboolean lm_applet_button_press_event_h (GtkWidget * widget, GdkEventButton * event, gpointer user_data);
#line 117 "lm-applet.c"
#line 379 "src/lm-applet.gob"
static void lm_applet_preferences_cb (BonoboUIComponent * component, gpointer user_data, const char * cname);
#line 120 "lm-applet.c"
#line 389 "src/lm-applet.gob"
static void lm_applet_help_cb (BonoboUIComponent * component, gpointer user_data, const char * cname);
#line 123 "lm-applet.c"
#line 397 "src/lm-applet.gob"
static void lm_applet_about_cb (BonoboUIComponent * component, gpointer user_data, const char * cname);
#line 126 "lm-applet.c"
#line 407 "src/lm-applet.gob"
static void lm_applet_show_preferences_dialog (LMApplet * self, guint32 timestamp);
#line 129 "lm-applet.c"
#line 413 "src/lm-applet.gob"
static void lm_applet_show_window (LMApplet * self, GType type, GtkWidget ** ptr, guint32 timestamp);
#line 132 "lm-applet.c"
#line 441 "src/lm-applet.gob"
static void lm_applet_update (LMApplet * self);
#line 135 "lm-applet.c"
#line 448 "src/lm-applet.gob"
static GtkWidget * lm_applet_create_icon (LMApplet * self);
#line 138 "lm-applet.c"
#line 468 "src/lm-applet.gob"
static void lm_applet_update_applet (LMApplet * self);
#line 141 "lm-applet.c"
#line 518 "src/lm-applet.gob"
static void lm_applet_update_tooltip (LMApplet * self);
#line 144 "lm-applet.c"
#line 581 "src/lm-applet.gob"
static void lm_applet_save_hosts (LMApplet * self);
#line 147 "lm-applet.c"
#line 602 "src/lm-applet.gob"
static void lm_applet_add_host_internal (LMApplet * self, LMHostFrontend * host);
#line 150 "lm-applet.c"
#line 616 "src/lm-applet.gob"
static void lm_applet_replace_host_internal (LMApplet * self, LMHostFrontend * old, LMHostFrontend * new);
#line 153 "lm-applet.c"
#line 632 "src/lm-applet.gob"
static void lm_applet_reorder_hosts_internal (LMApplet * self, GSList * new_hosts);
#line 156 "lm-applet.c"
#line 649 "src/lm-applet.gob"
static void lm_applet_remove_host_internal (LMApplet * self, LMHostFrontend * host);
#line 159 "lm-applet.c"

/*
 * Signal connection wrapper macro shortcuts
 */
#define self_connect__activate(object,func,data)	lm_applet_connect__activate((object),(func),(data))
#define self_connect_after__activate(object,func,data)	lm_applet_connect_after__activate((object),(func),(data))
#define self_connect_data__activate(object,func,data,destroy_data,flags)	lm_applet_connect_data__activate((object),(func),(data),(destroy_data),(flags))
#define self_connect__activate_preferences(object,func,data)	lm_applet_connect__activate_preferences((object),(func),(data))
#define self_connect_after__activate_preferences(object,func,data)	lm_applet_connect_after__activate_preferences((object),(func),(data))
#define self_connect_data__activate_preferences(object,func,data,destroy_data,flags)	lm_applet_connect_data__activate_preferences((object),(func),(data),(destroy_data),(flags))

enum {
	ACTIVATE_SIGNAL,
	ACTIVATE_PREFERENCES_SIGNAL,
	LAST_SIGNAL
};

enum {
	PROP_0,
	PROP_DELAY,
	PROP_SCALE,
	PROP_TOOLTIP_GRAPH_SPAN,
	PROP_PREFERENCES_WIDTH,
	PROP_PREFERENCES_HEIGHT
};

static guint object_signals[LAST_SIGNAL] = {0};

/* pointer to the class of our parent */
static PanelAppletClass *parent_class = NULL;

/* Short form macros */
#define self_get_delay lm_applet_get_delay
#define self_set_delay lm_applet_set_delay
#define self_get_scale lm_applet_get_scale
#define self_set_scale lm_applet_set_scale
#define self_get_tooltip_graph_span lm_applet_get_tooltip_graph_span
#define self_set_tooltip_graph_span lm_applet_set_tooltip_graph_span
#define self_get_preferences_width lm_applet_get_preferences_width
#define self_set_preferences_width lm_applet_set_preferences_width
#define self_get_preferences_height lm_applet_get_preferences_height
#define self_set_preferences_height lm_applet_set_preferences_height
#define self_activate lm_applet_activate
#define self_activate_preferences lm_applet_activate_preferences
#define self_factory_cb lm_applet_factory_cb
#define self_destroy_h lm_applet_destroy_h
#define self_reconfigure lm_applet_reconfigure
#define self_reconfigure_timeout_cb lm_applet_reconfigure_timeout_cb
#define self_change_background_h lm_applet_change_background_h
#define self_style_set_h lm_applet_style_set_h
#define self_button_press_event_h lm_applet_button_press_event_h
#define self_preferences_cb lm_applet_preferences_cb
#define self_help_cb lm_applet_help_cb
#define self_about_cb lm_applet_about_cb
#define self_show_preferences_dialog lm_applet_show_preferences_dialog
#define self_show_window lm_applet_show_window
#define self_update lm_applet_update
#define self_create_icon lm_applet_create_icon
#define self_update_applet lm_applet_update_applet
#define self_update_tooltip lm_applet_update_tooltip
#define self_factory_main lm_applet_factory_main
#define self_save_hosts lm_applet_save_hosts
#define self_add_host_internal lm_applet_add_host_internal
#define self_replace_host_internal lm_applet_replace_host_internal
#define self_reorder_hosts_internal lm_applet_reorder_hosts_internal
#define self_remove_host_internal lm_applet_remove_host_internal
#define self_add_host lm_applet_add_host
#define self_replace_host lm_applet_replace_host
#define self_reorder_hosts lm_applet_reorder_hosts
#define self_remove_host lm_applet_remove_host
#define self_get_host_color lm_applet_get_host_color
GType
lm_applet_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (LMAppletClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) lm_applet_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (LMApplet),
			0 /* n_preallocs */,
			(GInstanceInitFunc) lm_applet_init,
			NULL
		};

		type = g_type_register_static (PANEL_TYPE_APPLET, "LMApplet", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((LMApplet *)g_object_new(lm_applet_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static LMApplet * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static LMApplet *
GET_NEW_VARG (const char *first, ...)
{
	LMApplet *ret;
	va_list ap;
	va_start (ap, first);
	ret = (LMApplet *)g_object_new_valist (lm_applet_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "LM:Applet::finalize"
	LMApplet *self G_GNUC_UNUSED = LM_APPLET (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#define host_colors (self->_priv->host_colors)
#define VAR host_colors
	{
#line 134 "src/lm-applet.gob"
	
      if (VAR)
	g_array_free(VAR, TRUE);
    }
#line 290 "lm-applet.c"
	memset(&host_colors, 0, sizeof(host_colors));
#undef VAR
#undef host_colors
}
#undef __GOB_FUNCTION__

static void 
lm_applet_init (LMApplet * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "LM:Applet::init"
	o->_priv = G_TYPE_INSTANCE_GET_PRIVATE(o,LM_TYPE_APPLET,LMAppletPrivate);
#line 75 "src/lm-applet.gob"
	o->hosts =  g_ptr_array_new() ;
#line 304 "lm-applet.c"
}
#undef __GOB_FUNCTION__
#line 158 "src/lm-applet.gob"
static void 
lm_applet_class_init (LMAppletClass * class G_GNUC_UNUSED)
{
#line 311 "lm-applet.c"
#define __GOB_FUNCTION__ "LM:Applet::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) class;

	g_type_class_add_private(class,sizeof(LMAppletPrivate));

	parent_class = g_type_class_ref (PANEL_TYPE_APPLET);

	object_signals[ACTIVATE_SIGNAL] =
		g_signal_new ("activate",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (LMAppletClass, activate),
			NULL, NULL,
			g_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE, 0);
	object_signals[ACTIVATE_PREFERENCES_SIGNAL] =
		g_signal_new ("activate_preferences",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (LMAppletClass, activate_preferences),
			NULL, NULL,
			g_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE, 0);

#line 146 "src/lm-applet.gob"
	class->activate = ___real_lm_applet_activate;
#line 152 "src/lm-applet.gob"
	class->activate_preferences = ___real_lm_applet_activate_preferences;
#line 340 "lm-applet.c"
	g_object_class->finalize = ___finalize;
	g_object_class->get_property = ___object_get_property;
	g_object_class->set_property = ___object_set_property;
    {
	GParamSpec   *param_spec;

	param_spec = g_param_spec_int
		("delay" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 MIN_DELAY /* minimum */,
		 G_MAXINT /* maximum */,
		 DEFAULT_DELAY /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_DELAY,
		param_spec);
	param_spec = g_param_spec_int
		("scale" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 MIN_SCALE /* minimum */,
		 G_MAXINT /* maximum */,
		 DEFAULT_SCALE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_SCALE,
		param_spec);
	param_spec = g_param_spec_int
		("tooltip_graph_span" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 MIN_TOOLTIP_GRAPH_SPAN /* minimum */,
		 G_MAXINT /* maximum */,
		 DEFAULT_TOOLTIP_GRAPH_SPAN /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_TOOLTIP_GRAPH_SPAN,
		param_spec);
	param_spec = g_param_spec_int
		("preferences_width" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 -1 /* minimum */,
		 G_MAXINT /* maximum */,
		 DEFAULT_PREFERENCES_WIDTH /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_PREFERENCES_WIDTH,
		param_spec);
	param_spec = g_param_spec_int
		("preferences_height" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 -1 /* minimum */,
		 G_MAXINT /* maximum */,
		 DEFAULT_PREFERENCES_HEIGHT /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_PREFERENCES_HEIGHT,
		param_spec);
    }
 {
#line 159 "src/lm-applet.gob"

    GtkBindingSet *binding_set;

    binding_set = gtk_binding_set_by_class(class);

    gtk_binding_entry_add_signal(binding_set, GDK_Return, 0, "activate", 0);
    gtk_binding_entry_add_signal(binding_set, GDK_ISO_Enter, 0, "activate", 0);
    gtk_binding_entry_add_signal(binding_set, GDK_KP_Enter, 0, "activate", 0);

    gtk_binding_entry_add_signal(binding_set, GDK_Return, GDK_MOD1_MASK, "activate-preferences", 0);
    gtk_binding_entry_add_signal(binding_set, GDK_ISO_Enter, GDK_MOD1_MASK, "activate-preferences", 0);
    gtk_binding_entry_add_signal(binding_set, GDK_KP_Enter, GDK_MOD1_MASK, "activate-preferences", 0);
  
#line 418 "lm-applet.c"
 }
}
#undef __GOB_FUNCTION__

static void
___object_set_property (GObject *object,
	guint property_id,
	const GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "LM:Applet::set_property"
{
	LMApplet *self G_GNUC_UNUSED;

	self = LM_APPLET (object);

	switch (property_id) {
	case PROP_DELAY:
		{
#line 80 "src/lm-applet.gob"

      panel_applet_gconf_set_int(PANEL_APPLET(self), CONF_DELAY, self->delay = g_value_get_int(VAL), NULL);
    
#line 441 "lm-applet.c"
		}
		break;
	case PROP_SCALE:
		{
#line 91 "src/lm-applet.gob"

      panel_applet_gconf_set_int(PANEL_APPLET(self), CONF_SCALE, self->scale = g_value_get_int(VAL), NULL);
    
#line 450 "lm-applet.c"
		}
		break;
	case PROP_TOOLTIP_GRAPH_SPAN:
		{
#line 102 "src/lm-applet.gob"

      panel_applet_gconf_set_int(PANEL_APPLET(self), CONF_TOOLTIP_GRAPH_SPAN, self->tooltip_graph_span = g_value_get_int(VAL), NULL);
    
#line 459 "lm-applet.c"
		}
		break;
	case PROP_PREFERENCES_WIDTH:
		{
#line 113 "src/lm-applet.gob"

      panel_applet_gconf_set_int(PANEL_APPLET(self), CONF_PREFERENCES_WIDTH, self->preferences_width = g_value_get_int(VAL), NULL);
    
#line 468 "lm-applet.c"
		}
		break;
	case PROP_PREFERENCES_HEIGHT:
		{
#line 124 "src/lm-applet.gob"

      panel_applet_gconf_set_int(PANEL_APPLET(self), CONF_PREFERENCES_HEIGHT, self->preferences_height = g_value_get_int(VAL), NULL);
    
#line 477 "lm-applet.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__

static void
___object_get_property (GObject *object,
	guint property_id,
	GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "LM:Applet::get_property"
{
	LMApplet *self G_GNUC_UNUSED;

	self = LM_APPLET (object);

	switch (property_id) {
	case PROP_DELAY:
		{
#line 84 "src/lm-applet.gob"

      g_value_set_int(VAL, self->delay);
    
#line 510 "lm-applet.c"
		}
		break;
	case PROP_SCALE:
		{
#line 95 "src/lm-applet.gob"

      g_value_set_int(VAL, self->scale);
    
#line 519 "lm-applet.c"
		}
		break;
	case PROP_TOOLTIP_GRAPH_SPAN:
		{
#line 106 "src/lm-applet.gob"

      g_value_set_int(VAL, self->tooltip_graph_span);
    
#line 528 "lm-applet.c"
		}
		break;
	case PROP_PREFERENCES_WIDTH:
		{
#line 117 "src/lm-applet.gob"

      g_value_set_int(VAL, self->preferences_width);
    
#line 537 "lm-applet.c"
		}
		break;
	case PROP_PREFERENCES_HEIGHT:
		{
#line 128 "src/lm-applet.gob"

      g_value_set_int(VAL, self->preferences_height);
    
#line 546 "lm-applet.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__


#line 84 "src/lm-applet.gob"
gint 
lm_applet_get_delay (LMApplet * self)
{
#line 566 "lm-applet.c"
#define __GOB_FUNCTION__ "LM:Applet::get_delay"
{
#line 78 "src/lm-applet.gob"
		gint val; g_object_get (G_OBJECT (self), "delay", &val, NULL); return val;
}}
#line 572 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 80 "src/lm-applet.gob"
void 
lm_applet_set_delay (LMApplet * self, gint val)
{
#line 579 "lm-applet.c"
#define __GOB_FUNCTION__ "LM:Applet::set_delay"
{
#line 78 "src/lm-applet.gob"
		g_object_set (G_OBJECT (self), "delay", val, NULL);
}}
#line 585 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 95 "src/lm-applet.gob"
gint 
lm_applet_get_scale (LMApplet * self)
{
#line 592 "lm-applet.c"
#define __GOB_FUNCTION__ "LM:Applet::get_scale"
{
#line 89 "src/lm-applet.gob"
		gint val; g_object_get (G_OBJECT (self), "scale", &val, NULL); return val;
}}
#line 598 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 91 "src/lm-applet.gob"
void 
lm_applet_set_scale (LMApplet * self, gint val)
{
#line 605 "lm-applet.c"
#define __GOB_FUNCTION__ "LM:Applet::set_scale"
{
#line 89 "src/lm-applet.gob"
		g_object_set (G_OBJECT (self), "scale", val, NULL);
}}
#line 611 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 106 "src/lm-applet.gob"
gint 
lm_applet_get_tooltip_graph_span (LMApplet * self)
{
#line 618 "lm-applet.c"
#define __GOB_FUNCTION__ "LM:Applet::get_tooltip_graph_span"
{
#line 100 "src/lm-applet.gob"
		gint val; g_object_get (G_OBJECT (self), "tooltip_graph_span", &val, NULL); return val;
}}
#line 624 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 102 "src/lm-applet.gob"
void 
lm_applet_set_tooltip_graph_span (LMApplet * self, gint val)
{
#line 631 "lm-applet.c"
#define __GOB_FUNCTION__ "LM:Applet::set_tooltip_graph_span"
{
#line 100 "src/lm-applet.gob"
		g_object_set (G_OBJECT (self), "tooltip_graph_span", val, NULL);
}}
#line 637 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 117 "src/lm-applet.gob"
gint 
lm_applet_get_preferences_width (LMApplet * self)
{
#line 644 "lm-applet.c"
#define __GOB_FUNCTION__ "LM:Applet::get_preferences_width"
{
#line 111 "src/lm-applet.gob"
		gint val; g_object_get (G_OBJECT (self), "preferences_width", &val, NULL); return val;
}}
#line 650 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 113 "src/lm-applet.gob"
void 
lm_applet_set_preferences_width (LMApplet * self, gint val)
{
#line 657 "lm-applet.c"
#define __GOB_FUNCTION__ "LM:Applet::set_preferences_width"
{
#line 111 "src/lm-applet.gob"
		g_object_set (G_OBJECT (self), "preferences_width", val, NULL);
}}
#line 663 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 128 "src/lm-applet.gob"
gint 
lm_applet_get_preferences_height (LMApplet * self)
{
#line 670 "lm-applet.c"
#define __GOB_FUNCTION__ "LM:Applet::get_preferences_height"
{
#line 122 "src/lm-applet.gob"
		gint val; g_object_get (G_OBJECT (self), "preferences_height", &val, NULL); return val;
}}
#line 676 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 124 "src/lm-applet.gob"
void 
lm_applet_set_preferences_height (LMApplet * self, gint val)
{
#line 683 "lm-applet.c"
#define __GOB_FUNCTION__ "LM:Applet::set_preferences_height"
{
#line 122 "src/lm-applet.gob"
		g_object_set (G_OBJECT (self), "preferences_height", val, NULL);
}}
#line 689 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 146 "src/lm-applet.gob"
static void 
lm_applet_activate (LMApplet * self)
{
#line 696 "lm-applet.c"
	GValue ___param_values[1];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 146 "src/lm-applet.gob"
	g_return_if_fail (self != NULL);
#line 146 "src/lm-applet.gob"
	g_return_if_fail (LM_IS_APPLET (self));
#line 707 "lm-applet.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	g_signal_emitv (___param_values,
		object_signals[ACTIVATE_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
}
#line 146 "src/lm-applet.gob"
static void 
___real_lm_applet_activate (LMApplet * self)
{
#line 724 "lm-applet.c"
#define __GOB_FUNCTION__ "LM:Applet::activate"
{
#line 148 "src/lm-applet.gob"
	
    self_show_preferences_dialog(self, gtk_get_current_event_time());
  }}
#line 731 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 152 "src/lm-applet.gob"
static void 
lm_applet_activate_preferences (LMApplet * self)
{
#line 738 "lm-applet.c"
	GValue ___param_values[1];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 152 "src/lm-applet.gob"
	g_return_if_fail (self != NULL);
#line 152 "src/lm-applet.gob"
	g_return_if_fail (LM_IS_APPLET (self));
#line 749 "lm-applet.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	g_signal_emitv (___param_values,
		object_signals[ACTIVATE_PREFERENCES_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
}
#line 152 "src/lm-applet.gob"
static void 
___real_lm_applet_activate_preferences (LMApplet * self)
{
#line 766 "lm-applet.c"
#define __GOB_FUNCTION__ "LM:Applet::activate_preferences"
{
#line 154 "src/lm-applet.gob"
	
    self_show_preferences_dialog(self, gtk_get_current_event_time());
  }}
#line 773 "lm-applet.c"
#undef __GOB_FUNCTION__


#line 173 "src/lm-applet.gob"
static gboolean 
lm_applet_factory_cb (PanelApplet * applet, const char * iid, gpointer data)
{
#line 781 "lm-applet.c"
#define __GOB_FUNCTION__ "LM:Applet::factory_cb"
{
#line 175 "src/lm-applet.gob"
	
    Self *self = SELF(applet);
    static const BonoboUIVerb menu_verbs[] = {
      BONOBO_UI_VERB("LinkMonitorPreferences", self_preferences_cb),
      BONOBO_UI_VERB("LinkMonitorHelp", self_help_cb),
      BONOBO_UI_VERB("LinkMonitorAbout", self_about_cb),
      BONOBO_UI_VERB_END
    };
    GSList *gconf_hosts;
    GSList *l;
    int num_hosts = 0;

    if (strcmp(iid, "OAFIID:GNOME_LinkMonitorApplet"))
      return FALSE;

    GDK_THREADS_ENTER();

    lm_shell->applets = g_slist_append(lm_shell->applets, self);

    panel_applet_set_flags(applet, PANEL_APPLET_EXPAND_MINOR);
    panel_applet_add_preferences(applet, "/schemas/apps/link-monitor-applet/prefs", NULL);
    panel_applet_setup_menu_from_file(applet, DATADIR, "GNOME_LinkMonitorApplet.xml", NULL, menu_verbs, applet);

    self->delay = panel_applet_gconf_get_int(applet, CONF_DELAY, NULL);
    if (self->delay < MIN_DELAY)
      self->delay = DEFAULT_DELAY;

    self->scale = panel_applet_gconf_get_int(applet, CONF_SCALE, NULL);
    if (self->scale < MIN_SCALE)
      self->scale = DEFAULT_SCALE;

    self->tooltip_graph_span = panel_applet_gconf_get_int(applet, CONF_TOOLTIP_GRAPH_SPAN, NULL);
    if (self->tooltip_graph_span < MIN_TOOLTIP_GRAPH_SPAN)
      self->tooltip_graph_span = DEFAULT_TOOLTIP_GRAPH_SPAN;

    self->preferences_width = panel_applet_gconf_get_int(applet, CONF_PREFERENCES_WIDTH, NULL);
    if (! self->preferences_width)
      self->preferences_width = DEFAULT_PREFERENCES_WIDTH;

    self->preferences_height = panel_applet_gconf_get_int(applet, CONF_PREFERENCES_HEIGHT, NULL);
    if (! self->preferences_height)
      self->preferences_height = DEFAULT_PREFERENCES_HEIGHT;

    selfp->tooltip_flag_size_group = gtk_size_group_new(GTK_SIZE_GROUP_HORIZONTAL);

    gconf_hosts = panel_applet_gconf_get_list(applet, CONF_HOSTS, GCONF_VALUE_STRING, NULL);
    LM_LIST_FOREACH(l, gconf_hosts)
      {
	const char *entry = l->data;
	LMHostFrontend *host;

	if (++num_hosts > LM_MAX_HOSTS)
	  {
	    /* unlikely, not worth a translation */
	    g_warning("too many hosts configured, excess hosts ignored");
	    break;
	  }

	host = lm_host_frontend_parse_gconf_entry(self, entry);
	if (host)
	  {
	    self_add_host_internal(self, host);
	    g_object_unref(host);
	  }
	else
	  g_warning("cannot parse GConf host entry \"%s\"", entry);
      }
    lm_g_slist_free_deep(gconf_hosts);

    self_update(self);

    g_object_connect(self,
		     "signal::destroy", self_destroy_h, NULL,
		     "signal::button-press-event", self_button_press_event_h, NULL,
		     "signal::change-orient", self_reconfigure, NULL,
		     "signal::change-size", self_reconfigure, NULL,
		     "signal::change-background", self_change_background_h, NULL,
		     "signal::style-set", self_style_set_h, NULL,
		     NULL);

    gtk_widget_show(GTK_WIDGET(self));

    GDK_THREADS_LEAVE();

    return TRUE;
  }}
#line 871 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 267 "src/lm-applet.gob"
static void 
lm_applet_destroy_h (GtkObject * object, gpointer user_data)
{
#line 878 "lm-applet.c"
#define __GOB_FUNCTION__ "LM:Applet::destroy_h"
{
#line 269 "src/lm-applet.gob"
	
    Self *self = SELF(object);

    lm_shell->applets = g_slist_remove(lm_shell->applets, self);

    if (selfp->reconfigure_timeout_id)
      g_source_remove(selfp->reconfigure_timeout_id);

    lm_g_object_array_free(self->hosts);

    g_object_unref(selfp->tooltip_flag_size_group);

    if (selfp->preferences_dialog)
      gtk_widget_destroy(selfp->preferences_dialog);
    if (selfp->about_dialog)
      gtk_widget_destroy(selfp->about_dialog);

    gtk_widget_destroy(GTK_WIDGET(object));
  }}
#line 901 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 289 "src/lm-applet.gob"
static void 
lm_applet_reconfigure (LMApplet * self)
{
#line 908 "lm-applet.c"
#define __GOB_FUNCTION__ "LM:Applet::reconfigure"
#line 289 "src/lm-applet.gob"
	g_return_if_fail (self != NULL);
#line 289 "src/lm-applet.gob"
	g_return_if_fail (LM_IS_APPLET (self));
#line 914 "lm-applet.c"
{
#line 291 "src/lm-applet.gob"
	
    if (selfp->reconfigure_timeout_id)
      /* cancel the previously queued reconfigure */
      g_source_remove(selfp->reconfigure_timeout_id);

    /* do not flood the panel with reconfigures, queue it */
    selfp->reconfigure_timeout_id = gdk_threads_add_timeout(10, self_reconfigure_timeout_cb, self);
  }}
#line 925 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 300 "src/lm-applet.gob"
static gboolean 
lm_applet_reconfigure_timeout_cb (gpointer data)
{
#line 932 "lm-applet.c"
#define __GOB_FUNCTION__ "LM:Applet::reconfigure_timeout_cb"
{
#line 302 "src/lm-applet.gob"
	
    Self *self = data;

    self_update_applet(self);

    return FALSE;		/* remove source */
  }}
#line 943 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 311 "src/lm-applet.gob"
static void 
lm_applet_change_background_h (PanelApplet * applet, PanelAppletBackgroundType type, GdkColor * color, GdkPixmap * pixmap, gpointer user_data)
{
#line 950 "lm-applet.c"
#define __GOB_FUNCTION__ "LM:Applet::change_background_h"
{
#line 317 "src/lm-applet.gob"
	
    GtkRcStyle *rc_style;

    /* reset style */
    gtk_widget_set_style(GTK_WIDGET(applet), NULL);
    rc_style = gtk_rc_style_new();
    gtk_widget_modify_style(GTK_WIDGET(applet), rc_style);
    g_object_unref(rc_style);

    switch (type)
      {
      case PANEL_NO_BACKGROUND:
	break;

      case PANEL_COLOR_BACKGROUND:
	gtk_widget_modify_bg(GTK_WIDGET(applet), GTK_STATE_NORMAL, color);
	break;

      case PANEL_PIXMAP_BACKGROUND:
	{
	  GtkStyle *style;

	  style = gtk_style_copy(GTK_WIDGET(applet)->style);
	  if (style->bg_pixmap[GTK_STATE_NORMAL])
	    g_object_unref(style->bg_pixmap[GTK_STATE_NORMAL]);
	  style->bg_pixmap[GTK_STATE_NORMAL] = g_object_ref(pixmap);
	  gtk_widget_set_style(GTK_WIDGET(applet), style);
	  g_object_unref(style);
	}
	break;
      }
  }}
#line 986 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 350 "src/lm-applet.gob"
static void 
lm_applet_style_set_h (GtkWidget * widget, GtkStyle * previous_style, gpointer user_data)
{
#line 993 "lm-applet.c"
#define __GOB_FUNCTION__ "LM:Applet::style_set_h"
{
#line 354 "src/lm-applet.gob"
	
    Self *self = SELF(widget);

    /* invalidate the colors since they refer to style->base */
    if (selfp->host_colors)
      {
	g_array_free(selfp->host_colors, TRUE);
	selfp->host_colors = NULL;
      }
  }}
#line 1007 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 365 "src/lm-applet.gob"
static gboolean 
lm_applet_button_press_event_h (GtkWidget * widget, GdkEventButton * event, gpointer user_data)
{
#line 1014 "lm-applet.c"
#define __GOB_FUNCTION__ "LM:Applet::button_press_event_h"
{
#line 369 "src/lm-applet.gob"
	
    if (event->button == 1)
      {
	self_activate(SELF(widget));
	return TRUE;		/* do not propagate event */
      }

    return FALSE;		/* propagate event */
  }}
#line 1027 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 379 "src/lm-applet.gob"
static void 
lm_applet_preferences_cb (BonoboUIComponent * component, gpointer user_data, const char * cname)
{
#line 1034 "lm-applet.c"
#define __GOB_FUNCTION__ "LM:Applet::preferences_cb"
{
#line 383 "src/lm-applet.gob"
	
    Self *self = user_data;

    self_activate_preferences(self);
  }}
#line 1043 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 389 "src/lm-applet.gob"
static void 
lm_applet_help_cb (BonoboUIComponent * component, gpointer user_data, const char * cname)
{
#line 1050 "lm-applet.c"
#define __GOB_FUNCTION__ "LM:Applet::help_cb"
{
#line 393 "src/lm-applet.gob"
	
    lm_show_help(NULL);
  }}
#line 1057 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 397 "src/lm-applet.gob"
static void 
lm_applet_about_cb (BonoboUIComponent * component, gpointer user_data, const char * cname)
{
#line 1064 "lm-applet.c"
#define __GOB_FUNCTION__ "LM:Applet::about_cb"
{
#line 401 "src/lm-applet.gob"
	
    Self *self = user_data;

    self_show_window(self, LM_TYPE_ABOUT_DIALOG, &selfp->about_dialog, gtk_get_current_event_time());
  }}
#line 1073 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 407 "src/lm-applet.gob"
static void 
lm_applet_show_preferences_dialog (LMApplet * self, guint32 timestamp)
{
#line 1080 "lm-applet.c"
#define __GOB_FUNCTION__ "LM:Applet::show_preferences_dialog"
#line 407 "src/lm-applet.gob"
	g_return_if_fail (self != NULL);
#line 407 "src/lm-applet.gob"
	g_return_if_fail (LM_IS_APPLET (self));
#line 1086 "lm-applet.c"
{
#line 409 "src/lm-applet.gob"
	
    self_show_window(self, LM_TYPE_PREFERENCES_DIALOG, &selfp->preferences_dialog, timestamp);
  }}
#line 1092 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 413 "src/lm-applet.gob"
static void 
lm_applet_show_window (LMApplet * self, GType type, GtkWidget ** ptr, guint32 timestamp)
{
#line 1099 "lm-applet.c"
#define __GOB_FUNCTION__ "LM:Applet::show_window"
#line 413 "src/lm-applet.gob"
	g_return_if_fail (self != NULL);
#line 413 "src/lm-applet.gob"
	g_return_if_fail (LM_IS_APPLET (self));
#line 413 "src/lm-applet.gob"
	g_return_if_fail (type != 0);
#line 413 "src/lm-applet.gob"
	g_return_if_fail (ptr != NULL);
#line 1109 "lm-applet.c"
{
#line 418 "src/lm-applet.gob"
	
    GObjectClass *class;

    if (*ptr)
      {
	if (timestamp)
	  gtk_window_present_with_time(GTK_WINDOW(*ptr), timestamp);
	else
	  gtk_window_present(GTK_WINDOW(*ptr));
	return;
      }

    class = g_type_class_ref(type);
    if (g_object_class_find_property(class, "applet"))
      *ptr = g_object_new(type, "applet", self, NULL);
    else
      *ptr = g_object_new(type, NULL);
    g_type_class_unref(class);

    lm_add_weak_pointer(ptr);
    gtk_widget_show(*ptr);
  }}
#line 1134 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 441 "src/lm-applet.gob"
static void 
lm_applet_update (LMApplet * self)
{
#line 1141 "lm-applet.c"
#define __GOB_FUNCTION__ "LM:Applet::update"
#line 441 "src/lm-applet.gob"
	g_return_if_fail (self != NULL);
#line 441 "src/lm-applet.gob"
	g_return_if_fail (LM_IS_APPLET (self));
#line 1147 "lm-applet.c"
{
#line 443 "src/lm-applet.gob"
	
    self_update_applet(self);
    self_update_tooltip(self);
  }}
#line 1154 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 448 "src/lm-applet.gob"
static GtkWidget * 
lm_applet_create_icon (LMApplet * self)
{
#line 1161 "lm-applet.c"
#define __GOB_FUNCTION__ "LM:Applet::create_icon"
#line 448 "src/lm-applet.gob"
	g_return_val_if_fail (self != NULL, (GtkWidget * )0);
#line 448 "src/lm-applet.gob"
	g_return_val_if_fail (LM_IS_APPLET (self), (GtkWidget * )0);
#line 1167 "lm-applet.c"
{
#line 450 "src/lm-applet.gob"
	
    GdkPixbuf *pixbuf;
    int size;
    GdkPixbuf *scaled;
    GtkWidget *icon;

    pixbuf = lm_pixbuf_new(GNOMEPIXMAPSDIR G_DIR_SEPARATOR_S "link-monitor-applet.png");

    size = panel_applet_get_size(PANEL_APPLET(self)) - (ICON_PADDING * 2);
    scaled = gdk_pixbuf_scale_simple(pixbuf, size, size, GDK_INTERP_BILINEAR);
    g_object_unref(pixbuf);

    icon = gtk_image_new_from_pixbuf(scaled);
    g_object_unref(scaled);

    return icon;
  }}
#line 1187 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 468 "src/lm-applet.gob"
static void 
lm_applet_update_applet (LMApplet * self)
{
#line 1194 "lm-applet.c"
#define __GOB_FUNCTION__ "LM:Applet::update_applet"
#line 468 "src/lm-applet.gob"
	g_return_if_fail (self != NULL);
#line 468 "src/lm-applet.gob"
	g_return_if_fail (LM_IS_APPLET (self));
#line 1200 "lm-applet.c"
{
#line 470 "src/lm-applet.gob"
	
    GtkWidget *bar_graph = NULL;
    GtkWidget *box;
    GtkWidget *icon;
    GtkWidget *old_box;

    if (self->hosts->len != 0)
      bar_graph = lm_bar_graph_new(self);

    switch (panel_applet_get_orient(PANEL_APPLET(self)))
      {
      case PANEL_APPLET_ORIENT_UP:
      case PANEL_APPLET_ORIENT_DOWN:
	box = gtk_hbox_new(FALSE, BAR_SPACING);
	if (bar_graph)
	  lm_bar_graph_set_orientation(LM_BAR_GRAPH(bar_graph), LM_BAR_GRAPH_ORIENTATION_VERTICAL);
	break;

      case PANEL_APPLET_ORIENT_LEFT:
      case PANEL_APPLET_ORIENT_RIGHT:
	box = gtk_vbox_new(FALSE, BAR_SPACING);
	if (bar_graph)
	  lm_bar_graph_set_orientation(LM_BAR_GRAPH(bar_graph), LM_BAR_GRAPH_ORIENTATION_HORIZONTAL);
	break;

      default:
	g_assert_not_reached();
	break;
      }

    icon = self_create_icon(self);
    gtk_box_pack_start(GTK_BOX(box), icon, FALSE, FALSE, 0);
    gtk_widget_show(icon);

    if (bar_graph)
      {
	gtk_box_pack_start(GTK_BOX(box), bar_graph, FALSE, FALSE, 0);
	gtk_widget_show(bar_graph);
      }

    old_box = gtk_bin_get_child(GTK_BIN(self));
    if (old_box)
      gtk_container_remove(GTK_CONTAINER(self), old_box);

    gtk_container_add(GTK_CONTAINER(self), box);
    gtk_widget_show(box);
  }}
#line 1250 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 518 "src/lm-applet.gob"
static void 
lm_applet_update_tooltip (LMApplet * self)
{
#line 1257 "lm-applet.c"
#define __GOB_FUNCTION__ "LM:Applet::update_tooltip"
#line 518 "src/lm-applet.gob"
	g_return_if_fail (self != NULL);
#line 518 "src/lm-applet.gob"
	g_return_if_fail (LM_IS_APPLET (self));
#line 1263 "lm-applet.c"
{
#line 520 "src/lm-applet.gob"
	
    if (self->hosts->len != 0)
      {
	GtkWidget *vbox;
	GtkWidget *hosts_vbox;
	GtkWidget *line_graph;
	int i;

	vbox = gtk_vbox_new(FALSE, 12);
	hosts_vbox = gtk_vbox_new(TRUE, 6);
	line_graph = lm_line_graph_new(self);

	LM_ARRAY_FOREACH(i, self->hosts)
	  {
	    LMHostFrontend *host = g_ptr_array_index(self->hosts, i);
	    GtkWidget *hbox;
	    GtkWidget *graph_icon;

	    hbox = gtk_hbox_new(FALSE, 6);

	    if (self->hosts->len != 1)
	      {
		graph_icon = lm_line_graph_icon_new(host);
		gtk_box_pack_start(GTK_BOX(hbox), graph_icon, FALSE, FALSE, 0);
		gtk_widget_show(graph_icon);
	      }

	    lm_widget_remove_from_container(host->tooltip_flag);
	    gtk_box_pack_start(GTK_BOX(hbox), host->tooltip_flag, FALSE, FALSE, 0);
	    gtk_widget_show(host->tooltip_flag);

	    lm_widget_remove_from_container(host->tooltip_status);
	    gtk_box_pack_start(GTK_BOX(hbox), host->tooltip_status, FALSE, FALSE, 0);
	    gtk_widget_show(host->tooltip_status);

	    gtk_box_pack_start(GTK_BOX(hosts_vbox), hbox, FALSE, FALSE, 0);
	    gtk_widget_show(hbox);
	  }

	gtk_box_pack_start(GTK_BOX(vbox), line_graph, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vbox), hosts_vbox, FALSE, FALSE, 0);

	gtk_widget_show(line_graph);
	gtk_widget_show(hosts_vbox);

	lm_tooltips_set_tip_widget(lm_shell->tooltips, GTK_WIDGET(self), vbox);
	gtk_widget_show(vbox);
      }
    else
      lm_tooltips_set_tip(lm_shell->tooltips, GTK_WIDGET(self), _("No host is being monitored."));
  }}
#line 1317 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 572 "src/lm-applet.gob"
int 
lm_applet_factory_main (void)
{
#line 1324 "lm-applet.c"
#define __GOB_FUNCTION__ "LM:Applet::factory_main"
{
#line 574 "src/lm-applet.gob"
	
    return panel_applet_factory_main("OAFIID:GNOME_LinkMonitorApplet_Factory",
				     TYPE_SELF,
				     self_factory_cb,
				     NULL);
  }}
#line 1334 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 581 "src/lm-applet.gob"
static void 
lm_applet_save_hosts (LMApplet * self)
{
#line 1341 "lm-applet.c"
#define __GOB_FUNCTION__ "LM:Applet::save_hosts"
#line 581 "src/lm-applet.gob"
	g_return_if_fail (self != NULL);
#line 581 "src/lm-applet.gob"
	g_return_if_fail (LM_IS_APPLET (self));
#line 1347 "lm-applet.c"
{
#line 583 "src/lm-applet.gob"
	
    int i;
    GSList *gconf_hosts = NULL;

    LM_ARRAY_FOREACH(i, self->hosts)
      {
	LMHostFrontend *host = g_ptr_array_index(self->hosts, i);
	gconf_hosts = g_slist_append(gconf_hosts, lm_host_frontend_build_gconf_entry(host));
      }

    panel_applet_gconf_set_list(PANEL_APPLET(self),
				CONF_HOSTS,
				GCONF_VALUE_STRING,
				gconf_hosts,
				NULL);

    lm_g_slist_free_deep(gconf_hosts);
  }}
#line 1368 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 602 "src/lm-applet.gob"
static void 
lm_applet_add_host_internal (LMApplet * self, LMHostFrontend * host)
{
#line 1375 "lm-applet.c"
#define __GOB_FUNCTION__ "LM:Applet::add_host_internal"
#line 602 "src/lm-applet.gob"
	g_return_if_fail (self != NULL);
#line 602 "src/lm-applet.gob"
	g_return_if_fail (LM_IS_APPLET (self));
#line 602 "src/lm-applet.gob"
	g_return_if_fail (host != NULL);
#line 602 "src/lm-applet.gob"
	g_return_if_fail (LM_IS_HOST_FRONTEND (host));
#line 1385 "lm-applet.c"
{
#line 604 "src/lm-applet.gob"
	
    g_ptr_array_add(self->hosts, g_object_ref(host));

    lm_g_object_connect(self, host,
			"swapped-signal::notify::color", self_save_hosts, self,
			NULL);

    gtk_size_group_add_widget(selfp->tooltip_flag_size_group, host->tooltip_flag);

    self_update(self);
  }}
#line 1399 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 616 "src/lm-applet.gob"
static void 
lm_applet_replace_host_internal (LMApplet * self, LMHostFrontend * old, LMHostFrontend * new)
{
#line 1406 "lm-applet.c"
#define __GOB_FUNCTION__ "LM:Applet::replace_host_internal"
#line 616 "src/lm-applet.gob"
	g_return_if_fail (self != NULL);
#line 616 "src/lm-applet.gob"
	g_return_if_fail (LM_IS_APPLET (self));
#line 616 "src/lm-applet.gob"
	g_return_if_fail (old != NULL);
#line 616 "src/lm-applet.gob"
	g_return_if_fail (LM_IS_HOST_FRONTEND (old));
#line 616 "src/lm-applet.gob"
	g_return_if_fail (new != NULL);
#line 616 "src/lm-applet.gob"
	g_return_if_fail (LM_IS_HOST_FRONTEND (new));
#line 1420 "lm-applet.c"
{
#line 620 "src/lm-applet.gob"
	
    int idx;

    idx = lm_g_ptr_array_find(self->hosts, old);
    g_assert(idx != -1);

    g_object_unref(old);
    g_ptr_array_index(self->hosts, idx) = g_object_ref(new);

    self_update(self);
  }}
#line 1434 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 632 "src/lm-applet.gob"
static void 
lm_applet_reorder_hosts_internal (LMApplet * self, GSList * new_hosts)
{
#line 1441 "lm-applet.c"
#define __GOB_FUNCTION__ "LM:Applet::reorder_hosts_internal"
#line 632 "src/lm-applet.gob"
	g_return_if_fail (self != NULL);
#line 632 "src/lm-applet.gob"
	g_return_if_fail (LM_IS_APPLET (self));
#line 1447 "lm-applet.c"
{
#line 634 "src/lm-applet.gob"
	
    GSList *l;

    lm_g_object_array_free(self->hosts);
    self->hosts = g_ptr_array_new();

    LM_LIST_FOREACH(l, new_hosts)
      {
	LMHostFrontend *host = l->data;
	g_ptr_array_add(self->hosts, g_object_ref(host));
      }

    self_update(self);
  }}
#line 1464 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 649 "src/lm-applet.gob"
static void 
lm_applet_remove_host_internal (LMApplet * self, LMHostFrontend * host)
{
#line 1471 "lm-applet.c"
#define __GOB_FUNCTION__ "LM:Applet::remove_host_internal"
#line 649 "src/lm-applet.gob"
	g_return_if_fail (self != NULL);
#line 649 "src/lm-applet.gob"
	g_return_if_fail (LM_IS_APPLET (self));
#line 649 "src/lm-applet.gob"
	g_return_if_fail (host != NULL);
#line 649 "src/lm-applet.gob"
	g_return_if_fail (LM_IS_HOST_FRONTEND (host));
#line 1481 "lm-applet.c"
{
#line 651 "src/lm-applet.gob"
	
    gboolean status;

    status = g_ptr_array_remove(self->hosts, host);
    g_assert(status == TRUE);

    g_object_unref(host);

    self_update(self);
  }}
#line 1494 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 662 "src/lm-applet.gob"
void 
lm_applet_add_host (LMApplet * self, LMHostFrontend * host)
{
#line 1501 "lm-applet.c"
#define __GOB_FUNCTION__ "LM:Applet::add_host"
#line 662 "src/lm-applet.gob"
	g_return_if_fail (self != NULL);
#line 662 "src/lm-applet.gob"
	g_return_if_fail (LM_IS_APPLET (self));
#line 662 "src/lm-applet.gob"
	g_return_if_fail (host != NULL);
#line 662 "src/lm-applet.gob"
	g_return_if_fail (LM_IS_HOST_FRONTEND (host));
#line 1511 "lm-applet.c"
{
#line 664 "src/lm-applet.gob"
	
    self_add_host_internal(self, host);
    self_save_hosts(self);
  }}
#line 1518 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 669 "src/lm-applet.gob"
void 
lm_applet_replace_host (LMApplet * self, LMHostFrontend * old, LMHostFrontend * new)
{
#line 1525 "lm-applet.c"
#define __GOB_FUNCTION__ "LM:Applet::replace_host"
#line 669 "src/lm-applet.gob"
	g_return_if_fail (self != NULL);
#line 669 "src/lm-applet.gob"
	g_return_if_fail (LM_IS_APPLET (self));
#line 669 "src/lm-applet.gob"
	g_return_if_fail (old != NULL);
#line 669 "src/lm-applet.gob"
	g_return_if_fail (LM_IS_HOST_FRONTEND (old));
#line 669 "src/lm-applet.gob"
	g_return_if_fail (new != NULL);
#line 669 "src/lm-applet.gob"
	g_return_if_fail (LM_IS_HOST_FRONTEND (new));
#line 1539 "lm-applet.c"
{
#line 673 "src/lm-applet.gob"
	
    self_replace_host_internal(self, old, new);
    self_save_hosts(self);
  }}
#line 1546 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 678 "src/lm-applet.gob"
void 
lm_applet_reorder_hosts (LMApplet * self, GSList * new_hosts)
{
#line 1553 "lm-applet.c"
#define __GOB_FUNCTION__ "LM:Applet::reorder_hosts"
#line 678 "src/lm-applet.gob"
	g_return_if_fail (self != NULL);
#line 678 "src/lm-applet.gob"
	g_return_if_fail (LM_IS_APPLET (self));
#line 1559 "lm-applet.c"
{
#line 680 "src/lm-applet.gob"
	
    self_reorder_hosts_internal(self, new_hosts);
    self_save_hosts(self);
  }}
#line 1566 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 685 "src/lm-applet.gob"
void 
lm_applet_remove_host (LMApplet * self, LMHostFrontend * host)
{
#line 1573 "lm-applet.c"
#define __GOB_FUNCTION__ "LM:Applet::remove_host"
#line 685 "src/lm-applet.gob"
	g_return_if_fail (self != NULL);
#line 685 "src/lm-applet.gob"
	g_return_if_fail (LM_IS_APPLET (self));
#line 685 "src/lm-applet.gob"
	g_return_if_fail (host != NULL);
#line 685 "src/lm-applet.gob"
	g_return_if_fail (LM_IS_HOST_FRONTEND (host));
#line 1583 "lm-applet.c"
{
#line 687 "src/lm-applet.gob"
	
    self_remove_host_internal(self, host);
    self_save_hosts(self);
  }}
#line 1590 "lm-applet.c"
#undef __GOB_FUNCTION__

#line 692 "src/lm-applet.gob"
void 
lm_applet_get_host_color (LMApplet * self, const char * name, GdkColor * color)
{
#line 1597 "lm-applet.c"
#define __GOB_FUNCTION__ "LM:Applet::get_host_color"
#line 692 "src/lm-applet.gob"
	g_return_if_fail (self != NULL);
#line 692 "src/lm-applet.gob"
	g_return_if_fail (LM_IS_APPLET (self));
#line 692 "src/lm-applet.gob"
	g_return_if_fail (name != NULL);
#line 692 "src/lm-applet.gob"
	g_return_if_fail (color != NULL);
#line 1607 "lm-applet.c"
{
#line 696 "src/lm-applet.gob"
	
    GtkWidget *widget = GTK_WIDGET(self);

    if (! selfp->host_colors)
      {
	gtk_widget_ensure_style(widget);
	selfp->host_colors = lm_color_generator_generate(NUM_HOST_COLORS, &widget->style->base[GTK_STATE_NORMAL]);
      }

    *color = g_array_index(selfp->host_colors, GdkColor, g_str_hash(name) % selfp->host_colors->len);
  }}
#line 1621 "lm-applet.c"
#undef __GOB_FUNCTION__
