#!/bin/sh

#
# Line6 Linux USB driver - 0.6
#
# Copyright (C) 2004-2006 Markus Grabner (grabner@icg.tugraz.at)
#
#	This program is free software; you can redistribute it and/or
#	modify it under the terms of the GNU General Public License as
#	published by the Free Software Foundation, version 2.
#

# simultaneous playback of a pilot track and a previously recorded guitar track
# ALSA card number of PODxt Pro (type "aplay -l" to find the number)

CARD=1

# amplification factor of guitar signal (in %)
AMP=200

if test -z $2; then
    echo "usage: play.sh <pilot-track> <guitar-track>"
    exit 1
fi

ecasound \
-b:256 \
-a:chain_pilot -i:$1, \
-a:chain_guitar -ea:$AMP -i:$2, \
-a:chain_pilot,chain_guitar -o:alsaplugin,$CARD,0,0
