/* -*- mode: c++ -*-

  This file is part of the Life library

  Author(s): Christophe Prud'homme <christophe.prudhomme@ujf-grenoble.fr>
       Date: 2009-02-17

  Copyright (C) 2009 Universit Joseph Fourier (Grenoble I)

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 3.0 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
/**
   \file discontinuous.hpp
   \author Christophe Prud'homme <christophe.prudhomme@ujf-grenoble.fr>
   \date 2009-02-17
 */
#ifndef __Discontinuous_H
#define __Discontinuous_H 1

#include <boost/fusion/sequence.hpp>
#include <life/lifediscr/continuity.hpp>

namespace Life
{
// import fusion namespace in Life
namespace fusion = boost::fusion;

/**
 * \class Continuous
 * \brief describe continuous functions
 *
 * @author Christophe Prud'homme
 * @see
 */
class Discontinuous
    :
        // necessary for boost.parameters
        public detail::continuity_base
{
public:


    /** @name Constants
     */
    //@{

    static const bool is_continuous = false;
    static const bool is_discontinuous_locally = false;
    static const bool is_discontinuous_totally = true;


    //@}

    /** @name Typedefs
     */
    //@{
    typedef fusion::vector<> discontinuity_markers_type;

    //@}

    /** @name Constructors, destructor
     */
    //@{

    //! default constructor
    Discontinuous();
    //! copy constructor
    Discontinuous( Continuous const & );
    //! destructor
    ~Discontinuous();

    //@}

    /** @name Operator overloads
     */
    //@{

    //! copy operator
    Discontinuous& operator=( Discontinuous const & o)
    {
        if (this != &o )
            {
            }
        return *this;
    }
    //@}

    /** @name Accessors
     */
    //@{


    //@}

    /** @name  Mutators
     */
    //@{


    //@}

    /** @name  Methods
     */
    //@{


    //@}

    template<typename MeshType, typename DofType>
    class apply
    {
    public:
        typedef size_type result_type;
        typedef MeshType mesh_type;
        typedef DofType dof_type;
        typedef typename dof_type::fe_type fe_type;

        apply( MeshType& M, DofType& D )
            :
            M_mesh( M ),
            M_dof( D )
        {}
        template<typename T>
        result_type operator()(const T& t, const size_type& start ) const
        {
            //return build( T::value, start );
            return start;
        }
    private:
    private:
        MeshType& M_mesh;
        DofType M_dof;
    };

protected:

private:

};

} // Life
#endif /* __Discontinuous_H */

