package latexDraw.ui.listeners;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.*;

import latexDraw.ui.DrawPanel;
import latexDraw.ui.LaTeXDrawFrame;

/** 
 * Defines a listener for the latexdraw toolbar.<br>
 * <br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 * <br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.<br>
 * <br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 * <br>
 * 08/14/07<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
public class ToolbarListener extends AbstractListener implements ActionListener
{

	public static final String LABEL_ALIGN_LEFT 	= "alignLeft"; 		//$NON-NLS-1$
	public static final String LABEL_ALIGN_RIGHT 	= "alignRight"; 	//$NON-NLS-1$
	public static final String LABEL_ALIGN_TOP 		= "alignTop"; 		//$NON-NLS-1$
	public static final String LABEL_ALIGN_BOTTOM	= "alignBottom"; 	//$NON-NLS-1$
	public static final String LABEL_ALIGN_MIDDLE_H	= "alignMiddleH"; 	//$NON-NLS-1$
	public static final String LABEL_ALIGN_MIDDLE_V	= "alignMiddleV"; 	//$NON-NLS-1$
	
	public static final String LABEL_DISTRIB_H_EQ 		= "distribHEq";	//$NON-NLS-1$
	public static final String LABEL_DISTRIB_H_LEFT		= "distribHLe";	//$NON-NLS-1$
	public static final String LABEL_DISTRIB_H_RIGHT	= "distribHRi";	//$NON-NLS-1$
	public static final String LABEL_DISTRIB_H_MID		= "distribHMi";	//$NON-NLS-1$
	public static final String LABEL_DISTRIB_V_EQ 		= "distribVEq";	//$NON-NLS-1$
	public static final String LABEL_DISTRIB_V_BOTTOM	= "distribVBo";	//$NON-NLS-1$
	public static final String LABEL_DISTRIB_V_TOP		= "distribVTo";	//$NON-NLS-1$
	public static final String LABEL_DISTRIB_V_MID		= "distribVMi";	//$NON-NLS-1$
	
	
	/**
	 * The constructor.
	 * @param frame The latexdraw frame.
	 */
	public ToolbarListener(LaTeXDrawFrame frame)
	{
		super(frame);
	}

	
	public void actionPerformed(ActionEvent e)
	{
    	Object src = e.getSource();
    	
    	if(src instanceof JMenuItem || src instanceof JButton || src instanceof JToggleButton || src instanceof JCheckBox)
    	{
    		String label 		= ((AbstractButton)src).getActionCommand();
    		DrawPanel drawPanel = mainFrame.getDrawPanel();
    		
    		if(label.equals(LABEL_ALIGN_LEFT))
    		{
    			drawPanel.getDraw().align(0);
    			drawPanel.updateDraw(true);
    			mainFrame.requestFocus();
    			
    			return ;
    		}
    		
    		if(label.equals(LABEL_ALIGN_RIGHT))
    		{
    			drawPanel.getDraw().align(1);
    			drawPanel.updateDraw(true);
    			mainFrame.requestFocus();
    			
    			return ;
    		}
    		
    		if(label.equals(LABEL_ALIGN_TOP))
    		{
    			drawPanel.getDraw().align(2);
    			drawPanel.updateDraw(true);
    			mainFrame.requestFocus();
    			
    			return ;
    		}
    		
    		if(label.equals(LABEL_ALIGN_BOTTOM))
    		{
    			drawPanel.getDraw().align(3);
    			drawPanel.updateDraw(true);
    			mainFrame.requestFocus();
    			
    			return ;
    		}
    		
    		if(label.equals(LABEL_ALIGN_MIDDLE_H))
    		{
    			drawPanel.getDraw().align(5);
    			drawPanel.updateDraw(true);
    			mainFrame.requestFocus();
    			
    			return ;
    		}
    		
    		if(label.equals(LABEL_ALIGN_MIDDLE_V))
    		{
    			drawPanel.getDraw().align(4);
    			drawPanel.updateDraw(true);
    			mainFrame.requestFocus();
    			
    			return ;
    		}
    		
    		if(label.equals(LABEL_DISTRIB_H_LEFT))
    		{
    			drawPanel.getDraw().distribute(4);
    			drawPanel.updateDraw(true);
    			mainFrame.requestFocus();
    			
    			return ;
    		}
    		
    		if(label.equals(LABEL_DISTRIB_H_MID))
    		{
    			drawPanel.getDraw().distribute(5);
    			drawPanel.updateDraw(true);
    			mainFrame.requestFocus();
    			
    			return ;
    		}
    		
    		if(label.equals(LABEL_DISTRIB_H_RIGHT))
    		{
    			drawPanel.getDraw().distribute(6);
    			drawPanel.updateDraw(true);
    			mainFrame.requestFocus();
    			
    			return ;
    		}
    		
    		if(label.equals(LABEL_DISTRIB_H_EQ))
    		{
    			drawPanel.getDraw().distribute(7);
    			drawPanel.updateDraw(true);
    			mainFrame.requestFocus();
    			
    			return ;
    		}
    		
    		if(label.equals(LABEL_DISTRIB_V_BOTTOM))
    		{
    			drawPanel.getDraw().distribute(0);
    			drawPanel.updateDraw(true);
    			mainFrame.requestFocus();
    			
    			return ;
    		}
    		
    		if(label.equals(LABEL_DISTRIB_V_MID))
    		{
    			drawPanel.getDraw().distribute(1);
    			drawPanel.updateDraw(true);
    			mainFrame.requestFocus();
    			
    			return ;
    		}
    		
    		if(label.equals(LABEL_DISTRIB_V_TOP))
    		{
    			drawPanel.getDraw().distribute(2);
    			drawPanel.updateDraw(true);
    			mainFrame.requestFocus();
    			
    			return ;
    		}
    		
    		if(label.equals(LABEL_DISTRIB_V_EQ))
    		{
    			drawPanel.getDraw().distribute(3);
    			drawPanel.updateDraw(true);
    			mainFrame.requestFocus();
    			
    			return ;
    		}
    	}
	}
}
