//LabPlot : OverlayPlotDialog.h

#ifndef OVERLAYPLOTDIALOG_H
#define OVERLAYPLOTDIALOG_H

#include <qfont.h>
#include <qcheckbox.h>
#include "Worksheet.h"
#include "PlotDialog.h"

class OverlayPlotDialog: public PlotDialog
{
	Q_OBJECT
public:
	OverlayPlotDialog(MainWin *mw, const char *name);
public slots:
	void setFirst(int i) { ani->setValue(i); }	//!< set first plot
	void setSecond(int i) { bni->setValue(i); }	//!< set second plot
	void Apply() { apply_clicked(); }
private:
	KIntNumInput *ani, *bni;
private slots:
	void ok_clicked() { apply_clicked(); accept(); }
	void saveSettings();
	void apply_clicked();
};

#endif //OVERLAYPLOTDIALOG_H
