//LabPlot : ImportDialog.h

#ifndef IMPORTDIALOG_H
#define IMPORTDIALOG_H

#include "FilterKexiDB.h"
#include "Dialog.h"

/*! Main class for Data Import*/
class ImportDialog: public Dialog
{
	Q_OBJECT
public:
	ImportDialog(MainWin *mw, QString filename="", InputFilter filter=FUSER, const char *name=0);
public slots :
	void setNewSpreadsheet(bool e=true) { newspread->setChecked(e); }
	void Apply() { if (!apply_clicked()) accept(); }
private:
	int importKEXIDB();
	int importHP41XX(QIODevice *file);
	int importAUDIOFILE(QString filename, Spreadsheet *ss, int startRow, int endRow);
	int importHDF5(QString filename, Spreadsheet *ss, int startRow, int endRow);
	int importNETCDF(QString filename, Spreadsheet *ss, int startRow, int endRow);
	int importCDF(QString filename, Spreadsheet *ss, int startRow, int endRow);
	int importBINARY(QIODevice *file, QTable *table, int startRow, int endRow);
	int importASCII(QIODevice *file, QTable *table, int startRow, int endRow, int column, QStringList::iterator it);
	FilterKexiDB *kexi;					//KexiDB
	KComboBox *driver, *databases, *tables;
	QLabel *connectionlabel, *tablelabel;
	KLineEdit *host, *user, *password;
	QCheckBox *newspread, *namespread;					// importWidget
private slots :	
	int apply_clicked();
	void saveSettings();
	void wizardKexiDB(const QString &name);
	void finishKexiDB();
};
#endif //IMPORTDIALOG_H
