//LabPlot : ConfigureDialog.cc

#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <qhbuttongroup.h>
#include <qvbuttongroup.h>
#include <qlayout.h>
#include <qradiobutton.h>
#include <qhbox.h>
#include <qvalidator.h>
#include <qtabwidget.h>
#include <qfontdialog.h>

#include <klocale.h>
#include <kiconloader.h>
#include <kcombobox.h>
#include <klineedit.h>
#include "ConfigureDialog.h"
#include "WorksheetDialog.h"
#include "Dialog.h"

using namespace std;

const char* pageSize[] = { "ISO A4","ISO B5", "US Letter", "US Legal", "US Executive",
			"ISO A0", "ISO A1", "ISO A2", "ISO A3", "ISO A5", "ISO A6", "ISO A7",
			"ISO A8", "ISO A9", "ISO B0", "ISO B1","ISO B10", "ISO B2", "ISO B3",
			"ISO B4", "ISO B6", "ISO B7", "ISO B8","ISO B9", "ISO C5", "US Common 10",
			"ISO DL", "US Folio", "US Ledger", "US Tabloid"};

ConfigureDialog::ConfigureDialog(MainWin *m, KConfig *c)
	: KDialogBase (KDialogBase::IconList, i18n("Configure LabPlot"),
	KDialogBase::Ok|KDialogBase::Apply|KDialogBase::Cancel, KDialogBase::Ok),
	mw(m),config(c)
{
	config->setGroup( "General Options" );
	QFrame* general = addPage(i18n("General Options"),i18n("General Options"), BarIcon(QString("edit"), KIcon::SizeMedium));
	QVBoxLayout *genLayout = new QVBoxLayout(general);

	QVButtonGroup *fsbg = new QVButtonGroup(general);
	QHBox *hb = new QHBox(fsbg);
	new QLabel(i18n("Number of Recent Files : "),hb);
	recentnr = new KIntNumInput(config->readNumEntry("NrRecentFiles",10),hb);
	recentnr->setRange(0, 100, 1, false);

	// autosave
	QVButtonGroup *asbg = new QVButtonGroup(general);
	hb = new QHBox(asbg);
	autosave = new QCheckBox(hb, "Autosave");
	autosave->setText(i18n("Auto&save"));
	autosave->setChecked(config->readBoolEntry("Autosave",true));
	auto_original = new QCheckBox(hb, "AutoOriginal");
	auto_original->setText(i18n("Use orginal project for autosave"));
	auto_original->setChecked(config->readBoolEntry("AutoOriginal",true));

	hb = new QHBox(asbg);
	QLabel *lb = new QLabel(i18n("Interval &time in minutes (1 - 9999) : "),hb);
	asIntervalInput = new KIntNumInput(config->readLongNumEntry("AutosaveInterval",600000)/60000,hb);
	asIntervalInput->setRange(1, 9999, 1, false);
	lb->setBuddy(asIntervalInput);

	// speedmode
	speedmode = new QCheckBox(asbg, "SpeedMode");
	speedmode->setText(i18n("Speed Mode"));
	speedmode->setChecked(config->readBoolEntry("SpeedMode",false));
	hb = new QHBox(asbg);
	new QLabel(i18n("Speed Mode Number : "),hb);
	speedmodevalue = new KIntNumInput(config->readNumEntry("SpeedModeValue",1000),hb);
	speedmodevalue->setRange(1, 100000, 100, false);

	// keyboard datamode
	hb = new QHBox(asbg);
	keydatamode = new QCheckBox(asbg, "KeyboardDataMode");
	keydatamode->setText(i18n("Use Arrow Keys for Data Mode"));
	keydatamode->setChecked(config->readBoolEntry("KeyboardDataMode",false));

	// default font for label
	QVButtonGroup *fontbg = new QVButtonGroup(general);
	new QLabel(i18n("Default Font : "),fontbg);
	hb = new QHBox(fontbg);
	defaultfont = mw->defaultFont();
	fontle = new KLineEdit(defaultfont.family() + " " + QString::number(defaultfont.pointSize()),hb);
	KPushButton *newFont = new KPushButton(i18n("New"),hb);
	QObject::connect(newFont,SIGNAL(clicked()),SLOT(selectFont()));

	genLayout->addWidget(fsbg);
	genLayout->addWidget(asbg);
	genLayout->addWidget(fontbg);

	// Printer Settings
	config->setGroup("KPrinter Settings" );
	QFrame* pp = addPage(i18n("Print Preview"),i18n("Print Preview"), BarIcon(QString("printer"), KIcon::SizeMedium));
	QVBoxLayout *printLayout = new QVBoxLayout(pp);

	QVButtonGroup *printbg = new QVButtonGroup(i18n("Printer settings"),pp);
	color = new QRadioButton(i18n("Print in color if available") , printbg);
	color->setChecked(true);
	grayscale = new QRadioButton(i18n("Print in grayscale") , printbg);
	if (!config->readBoolEntry("ColorMode",true))
		grayscale->setChecked(true);

	printLayout->addWidget(printbg);

	QVButtonGroup *paperbg = new QVButtonGroup(i18n("Paper Format"),pp);

	originalsize = new QCheckBox(paperbg, "UseOriginalSize");
	originalsize->setText(i18n("Keep original size"));
	originalsize->setChecked(config->readBoolEntry("UseOriginalSize",true));

	ps2eps = new QCheckBox(paperbg, "UsePS2EPS");
	ps2eps->setText(i18n("Use ps2eps for exporting EPS"));
	ps2eps->setChecked(config->readBoolEntry("UsePS2EPS",true));

	ps2pdf = new QCheckBox(paperbg, "UsePS2PDF");
	ps2pdf->setText(i18n("Use ps2pdf for exporting PDF"));
	ps2pdf->setChecked(config->readBoolEntry("UsePS2PDF",true));

	orientation = new KComboBox(paperbg);
	QStringList olst;
	olst += i18n("Portrait");
	olst += i18n("Landscape");
	orientation->insertStringList(olst);
	orientation->setCurrentItem(config->readNumEntry("Orientation",1));

	pagesize = new KComboBox(paperbg);
	QStringList slst;
	for ( int i = 0 ; i < 30 ; ++i )
		slst << i18n( pageSize[ i ] );
	pagesize->insertStringList(slst);
	pagesize->setCurrentItem(config->readNumEntry("PageSize",9));

	printLayout->addWidget(paperbg);

	// simple plot style tab
	QFrame* pss = addPage(i18n("Simple Plot"),i18n("Simple Plot Style"), BarIcon(QString("LabPlot"), KIcon::SizeLarge));
	QVBoxLayout *plotsimpleLayout = new QVBoxLayout(pss);

	// bad
	resize(650,550);

	QTabWidget *tw1 = new QTabWidget(pss);
	Style *style=0;
	Symbol *symbol=0;
	dialog = new Dialog(mw,0);
	QVBox *styletab1 = dialog->simpleStyle(tw1, style, symbol);
	styletab1->reparent((QWidget *)pss,0,QPoint(0,0));
	styletab1->resize(this->size()-QSize(170,100));
	plotsimpleLayout->addWidget(tw1);

	// surface plot style tab
	QFrame* pus = addPage(i18n("Surface Plot"),i18n("Surface Plot Style"), BarIcon(QString("LabPlot"), KIcon::SizeLarge));
	QVBoxLayout *plotsurfaceLayout = new QVBoxLayout(pus);

	QTabWidget *tw2 = new QTabWidget(pus);
	QVBox *styletab2 = dialog->surfaceStyle(tw2,true);
	styletab2->reparent((QWidget *)pus,0,QPoint(0,0));
	styletab2->resize(this->size()-QSize(170,100));
	plotsurfaceLayout->addWidget(tw2);

	// errorbar style tab
	QFrame* pes = addPage(i18n("Errorbars"),i18n("Errorbar Style"), BarIcon(QString("LabPlot"), KIcon::SizeLarge));
	QVBoxLayout *errorbarLayout = new QVBoxLayout(pes);

	QTabWidget *tw3 = new QTabWidget(pes);
	QVBox *styletab3 = dialog->errorbarTab(tw2,0);
	styletab3->reparent((QWidget *)pes,0,QPoint(0,0));
	styletab3->resize(this->size()-QSize(170,100));
	errorbarLayout->addWidget(tw3);

	QObject::connect(this,SIGNAL(okClicked()),SLOT(ok_clicked()));
	QObject::connect(this,SIGNAL(applyClicked()),SLOT(apply_clicked()));
}

void ConfigureDialog::selectFont() {
	bool ok;
	QFont f = QFontDialog::getFont( &ok, defaultfont, this );
	if ( ok ) {
		defaultfont = f;
		fontle->setText(f.family());
	}
}

void ConfigureDialog::apply_clicked() {
	config->setGroup("KPrinter Settings" );
	config->writeEntry("ColorMode",color->isChecked());
	config->writeEntry("Orientation",orientation->currentItem());
	config->writeEntry("PageSize",pagesize->currentItem());
	config->writeEntry("UseOriginalSize",originalsize->isChecked());
	config->writeEntry("UsePS2EPS",ps2eps->isChecked());
	config->writeEntry("UsePS2PDF",ps2pdf->isChecked());

	config->setGroup( "General Options" );
	config->writeEntry("NrRecentFiles",recentnr->value());
	config->writeEntry("Autosave",autosave->isChecked());
	config->writeEntry("AutoOriginal",auto_original->isChecked());
	config->writeEntry("AutosaveInterval",asIntervalInput->value()*60000);
	config->writeEntry("SpeedMode",speedmode->isChecked());
	config->writeEntry("SpeedModeValue",speedmodevalue->value());
	config->writeEntry("KeyboardDataMode",keydatamode->isChecked());
	config->writeEntry("DefaultFont",defaultfont);
	mw->setDefaultFont(defaultfont);

	dialog->saveSimpleStyle();
	dialog->saveSurfaceStyle();
	dialog->saveErrorbarSettings();
}

void ConfigureDialog::ok_clicked() {
	apply_clicked();
	accept();
}
