/***************************************************************************
 *
 *  $Id: kzencategories.h,v 1.3 2005/05/31 06:54:02 muszilla Exp $
 *
 *  Copyright (C) 2005 by Andreas Mussgiller
 *  muszilla@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the
 *  Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#ifndef KZENCATEGORIES_H
#define KZENCATEGORIES_H

#include <qdatastream.h>
#include <qstringlist.h>

/**
@author Andreas Mussgiller
*/
class KZenCategories {
  
 public:
  
  KZenCategories();
  ~KZenCategories();

  const QString &             category(uint idx) { return fCategoryList[idx]; }
  uint                        count() { return fCategoryList.count(); }
  void                        addCategory(const QString & cat) { fCategoryList.append(cat); }
  QStringList &               categories() { return fCategoryList; }

 protected:

  QStringList                 fCategoryList;
};

extern KZenCategories * gCategories;

QDataStream & operator<<(QDataStream & s, KZenCategories & cat);
QDataStream & operator>>(QDataStream & s, KZenCategories & cat);

#endif
