/***************************************************************************
 *   Copyright (C) 2003 by Stephen Allewell                                *
 *   stephen@mirramar.fsnet.co.uk                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef __KXSTITCHMIMESOURCE_H
#define __KXSTITCHMIMESOURCE_H

#include <qmime.h>
#include <qstrlist.h>

/** Derived from QMimeSource to allow cut/copy/paste within and between applications
  */
class KXStitchMimeSource : public QMimeSource
{
public:
  KXStitchMimeSource(QByteArray data);
  virtual ~KXStitchMimeSource();

  virtual const char* format(int n=0) const;
  virtual bool provides(const char* mimeType) const;
  virtual QByteArray encodedData(const char* mimeType) const;

private:
  QByteArray  m_data;
  QStrList    m_outputFormats;
};

#endif
