/***************************************************************************
 *   Copyright (C) 2007-2008 by Giovanni Venturi                           *
 *   giovanni@ksniffer.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02110-1301, USA.          *
 ***************************************************************************/

#include <qcheckbox.h>
#include <qradiobutton.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

#include <kuniqueapplication.h>
#include <kconfig.h>
#include <klocale.h>

#include "guioptiontab.h"
#include "captureoptions.h"

GuiOptionTab::GuiOptionTab(QWidget *parent, const char *name)
 : base_guiOptionTab(parent,name)
{
  QToolTip::add( m_afterDisplay, i18n("The packets will be displayed just when you stop capturing them") );
  QWhatsThis::add( m_afterDisplay,
    i18n("<p>The default option is <i>showing packets when you capture it</i>. "\
         "If you check this, when KSniffer will capture packets it will not display them. "\
         "Just when you stop capturing all captured packets will be displayed.</p>"
         "<p>You can change this option during sniffing, but the effect will "\
         "take effect after you make a <b>New capture</b>. If you want simply "\
         "to stop packet-capture for a while you can use the <i>Pause Capture</i> "\
         "feature from the <i>Capture</i> menu.</p>") );

  QToolTip::add( m_trayBar, i18n("KSniffer can be added to the KDE tray bar clicking here") );
  QWhatsThis::add( m_trayBar,
    i18n("<p>The default option is <i>not showing KSniffer icon in the tray bar</i>."\
         "If you want to add KSniffer to the tray bar you have to click here. "\
         "In this way you can access some useful KSniffer functions like start a new "\
         "capure, stop it, pause/continue it directly from the tray bar.</p>") );

  connect( m_checkWarning, SIGNAL(clicked()), this, SLOT(checkWarning()) );
  QWhatsThis::add( m_checkWarning,
     i18n("<p>If you check this, you will be warn when the capture stops and you got no packets. "\
          "You can choose if you want to be warned with a modal window or with a pop up one "\
          "checking or not the following sub option.</p>") );

  QToolTip::add( m_checkWarning, i18n("Warning when the capture stops and you got no packets") );

  QWhatsThis::add( m_checkPassiveWarn,
     i18n("<p>If you check this, you will be warn when the capture stops and you got no packets "\
          "with a passive pop up, otherwise you will warn by a modal window that stops the "\
          "application till when you click on the OK button.</p>") );

  QToolTip::add( m_checkPassiveWarn, i18n("Warning with a passive pop up when the capture stops and you got no packets") );

  QWhatsThis::add( m_checkShowSplash,
     i18n("<p>If you check this, you will see a splash screen for some seconds at the KSniffer startup.</p>") );

  QToolTip::add( m_checkShowSplash, i18n("It will show a splash screen at the startup") );

  QToolTip::add( m_checkShowProtocolName, i18n("The <b>Protocol</b> column is referred to the packets list. "\
      "Changes are applied just to the new packets"));
  QWhatsThis::add( m_checkShowProtocolName, i18n("<p>If you check this, when KSniffer will detect the service application "\
      "as could be an IMAP, SMTP, POP3, DNS protocol you will see that names "\
      "in place of just TCP or UDP (according to the relative protocol) "\
      "in the <b>Protocol</b> column in the packets list.</p><p>This option "\
      "has effect only on the new packets. If you want to apply the change "\
      "to all packets you need to reload the file if you loaded one, or just "\
      "restart KSniffer to have this option enabled for all packets.</p>"\
      "<p>The protocol name is obtained from your OS from the file "\
      "<b>/etc/services</b>.</p>"));
}


GuiOptionTab::~GuiOptionTab()
{
}


void GuiOptionTab::getShowAfterOptions( CaptureOptions *options )
{
  // get just the Show After configuration
  KConfig* c = kapp->config();
  c->setGroup( "General Options" );
  options->setShowAfter( c->readBoolEntry( "Show packets after stopped capture" , false ) );
}


void GuiOptionTab::getRawFramePosition( CaptureOptions *options )
{
  // get just the Show Raw Frame On the
  KConfig* c = kapp->config();
  c->setGroup( "General Options" );
  options->setShowAfter( c->readBoolEntry( "Show Raw Frame On the" , false ) );
}


void GuiOptionTab::getOptions( CaptureOptions *options )
{
  KConfig* c = kapp->config();
  c->setGroup( "General Options" );
  options->setShowAfter( c->readBoolEntry( "Show packets after stopped capture" , false ) );

  options->setTrayBar( c->readBoolEntry( "Show Tray Bar", false ) );
  options->setWarning( c->readBoolEntry( "Warn with no packets", true ) );
  options->setPassiveWarn( c->readBoolEntry( "Passive pop up warning with no packets", false ) );
  options->setShowSplash( c->readBoolEntry( "Show splash", true ) );
  options->setRawFramePosition( c->readEntry( "Show Raw Frame On the", "under" ) );

  options->setShowProtocolName( c->readBoolEntry( "Show Protocol Name", true ) );
}


void GuiOptionTab::readSettings()
{
  KConfig* c = kapp->config();
  c->setGroup( "General Options" );
  m_afterDisplay->setChecked( c->readBoolEntry( "Show packets after stopped capture" , false ) );
  m_trayBar->setChecked( c->readBoolEntry( "Show Tray Bar", false ) );

  m_checkWarning->setChecked( c->readBoolEntry( "Warn with no packets", true ) );
  if (!m_checkWarning->isChecked())
    m_checkPassiveWarn->setEnabled( false );
  else
    m_checkPassiveWarn->setChecked( c->readBoolEntry( "Passive pop up warning with no packets", false ) );

  // check if the Splashscreen has to be displayed
  m_checkShowSplash->setChecked( c->readBoolEntry("Show splash", true) );

  if (c->readEntry( "Show Raw Frame On the", "under" ) == "right")
    assignRightPositionRaw();
  else
    assignUnderPositionRaw();

  m_checkShowProtocolName->setChecked( c->readBoolEntry( "Show Protocol Name", true ) );
}


bool GuiOptionTab::saveSettings()
{
  KConfig* c = kapp->config();
  c->setGroup( "General Options" );
  c->writeEntry( "Show splash", m_checkShowSplash->isChecked() );

  c->writeEntry( "Version", "0.3.2" );
  c->writeEntry( "Show packets after stopped capture", m_afterDisplay->isChecked() );
  c->writeEntry( "Show Tray Bar", m_trayBar->isChecked() );

  c->writeEntry( "Warn with no packets", m_checkWarning->isChecked() );
  c->writeEntry( "Passive pop up warning with no packets", m_checkPassiveWarn->isChecked() );

  if (m_radioRight->isChecked())
    c->writeEntry( "Show Raw Frame On the", "right");
  else
    c->writeEntry( "Show Raw Frame On the", "under");

  c->writeEntry( "Show Protocol Name", m_checkShowProtocolName->isChecked() );

  emit trayBarShown( m_trayBar->isChecked() );
  emit changedRawFormPosition( m_radioRight->isChecked() );

  return true;
}


void GuiOptionTab::checkWarning()
{
  m_checkPassiveWarn->setEnabled(m_checkWarning->isChecked());
}


void GuiOptionTab::assignRightPositionRaw()
{
  m_radioRight->setChecked(true);
  m_radioUnder->setChecked(false);
}


void GuiOptionTab::assignUnderPositionRaw()
{
  m_radioRight->setChecked(false);
  m_radioUnder->setChecked(true);
}

#include "guioptiontab.moc"
