//
// C++ Interface: kpglinklabel
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGLINKLABEL_H
#define KPGLINKLABEL_H

// include files for libpgxx 
#include <pqxx/util> 

#include <qlabel.h>
//#include <kactivelabel.h>

/**
Label for OID and their object name. Used in property pages to browse PostgreSQL catalog using OIDs.

@author Lumir Vanek
*/

class KPGLinkLabel : public QLabel //KActiveLabel
{
	Q_OBJECT
public:
	KPGLinkLabel(QWidget *parent, const char *name = 0);
    ~KPGLinkLabel();
		
	// Set object name and OID
	void setValues(pqxx::oid, const QString &);

	// Return PostgreSQL row identifier
	pqxx::oid oid() const { return m_oid; }
		
//public slots:
//   virtual void openLink(const QString &);

protected:

	// PostgreSQL row identifier
	pqxx::oid m_oid;		
};

#endif
