/***************************************************************************
                          kxetexteditordialog.h  -  description
                             -------------------
    begin                : Ne pro 14 2003
    copyright            : (C) 2003-2005 by The KXMLEditor Team
    email                : lvanek.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KXETEXTEDITORDIALOG_H
#define KXETEXTEDITORDIALOG_H

#include "kxetexteditordialogbase.h"

#include <qstring.h>

#include "kxesyntaxhighlighter.h"

/**
  *	Dialog for editing raw XML as text. Borrowed from
  * KXMLEditor
  * 
  *
  * @author Lumir Vanek
  */
class KXETextEditorDialog : public KXETextEditorDialogBase
{
  Q_OBJECT
public:
  KXETextEditorDialog(QWidget *parent);
  ~KXETextEditorDialog();

  const QString editorText() const;
  void setEditorText(const QString &);

protected:

  bool validateXml(bool);
  
public slots:

  /**
   * Changes syntax highlighting colors.
   */
  void slotTextViewSettingsChanged();
  
protected slots:

  // fired, when user press Validate button
  virtual void slotValidate();

  // fired, when user change text editor contents
  void slotTextChanged();

  // fired, when user press OK button
  virtual void accept();
  
private:

  KXESyntaxHighlighter *m_pSyntaxHighlighter;
};

#endif
