//
// C++ Implementation: kpgmodifygroupwizard
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgmodifygroupwizard.h"

// include files for Qt
#include <qlayout.h>

// include files for KDE
#include <kdebug.h>
#include <ktextedit.h>
#include <kmessagebox.h>
#include <klocale.h>

// application specific includes
#include "../DbObjects/kpgtreeitem.h"
#include "../DbObjects/kpgusersfolder.h"
#include "../DbObjects/kpggroup.h"
#include "kpgmodifygroupwidget1.h"


KPGModifyGroupWizard::KPGModifyGroupWizard(QWidget *parent, const char *name, KPGGroup *pGroup, KPGUsersFolder *pUsersFolder)
 : KPG3StepsWizard(parent, name)
{
	KPGModifyGroupWidget1 *pModifyGroupWidget1 = new KPGModifyGroupWidget1(WizardPage1, "KPGModifyGroupWidget1", pGroup, pUsersFolder);
	m_pPageWidget1 = pModifyGroupWidget1;
	WizardPage1Layout->addWidget(m_pPageWidget1, 0, 0);
	connect(pModifyGroupWidget1, SIGNAL(sigEnableNextButton(bool)), this, SLOT(slotEnableNextButton1(bool)));
	
	setNextEnabled(WizardPage1, false);
	
	languageChange();
}


KPGModifyGroupWizard::~KPGModifyGroupWizard()
{
}

void KPGModifyGroupWizard::languageChange()
{
    KPG3StepsWizard::languageChange();
		
		setCaption( i18n( "Modify group" ) );
		
    setTitle( WizardPage1, i18n( "Step 1 - Group name and list of users" ) );
    setTitle( WizardPage2, i18n( "Step 2 - Review SQL statement" ) );
    setTitle( WizardPage3, i18n( "Step 3 - Check operation result" ) );
}

// When this function called, initialize appropriate Wizard page
void KPGModifyGroupWizard::showPage(QWidget *pPage)
{
	if(pPage == WizardPage2) // Step 2 - Review SQL statement
	{
		// prepare SQL statement
		QString strSQL((static_cast <KPGModifyGroupWidget1 *> (m_pPageWidget1))->getSQL());
		m_pTextEditSQL->setText(strSQL);
		
		setNextEnabled(WizardPage2, strSQL.length() > 0);
	}
	
	if(pPage == WizardPage3) // Step 3 - Check operation result
	{
		runQuery();
	}
	
	// call parent
	KPG3StepsWizard::showPage(pPage);
}


#include "kpgmodifygroupwizard.moc"
