//
// C++ Interface: kpgcreatetablewidget4
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGCREATETABLEWIDGET4_H
#define KPGCREATETABLEWIDGET4_H

#include "kpgcreatetablewidget4base.h"

#include "kpgtablecolumnwizinfo.h"

class KPGDatabase;
class QListBoxItem;

/**
Widget for create table wizard - define indexes

http://www.postgresql.org/docs/current/static/sql-createindex.html

@author Lumir Vanek
*/

class KPGCreateTableWidget4 : public KPGCreateTableWidget4Base
{
Q_OBJECT
public:
    KPGCreateTableWidget4(QWidget *parent, const char *name, KPGDatabase *);
    ~KPGCreateTableWidget4();

	KPGListTableColumnWizInfo & getListOfAvailableColumns() { return m_listOfAvailableColumns; }
	void setListOfAvailableColumns(KPGListTableColumnWizInfo &);
	void setTableName(const QString &strTableName) { m_strTableName = strTableName; }
	void setNamespace(const QString &strNamespaceName) { m_strNamespaceName = strNamespaceName; }
	const QString getSQL() const;

protected:
		
	void enableAddIndexButton(bool);
	void setDefaultIndexName();
	void refreshListOfFunctions(int);
				
protected:
	KPGDatabase *m_pDatabase;
    QString m_strTableName; 	// name of the created table
	QString m_strNamespaceName; // name of the namespace
	KPGListTableColumnWizInfo m_listOfAvailableColumns;
	QString m_strSavedWherePredicate;
	bool m_bWhereSaved;
		
protected slots:

	virtual void slotIndexNameChanged(const QString&);
		
	virtual void slotColumnAdded(QListBoxItem *);
    virtual void slotColumnRemoved(QListBoxItem *);
    virtual void slotIndexesSelectionChanged(QListViewItem *);
    virtual void slotIndexesCurrentChanged(QListViewItem *);
	virtual void slotCurrentFunctionChanged(int);
		
	virtual void slotIndexAdd();
    virtual void slotIndexDelete();
						
signals:
	void sigEnableNextButton(bool);		
};

#endif
