//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgcreatetablespacewidget2.h"

// include files for Qt
#include <qlabel.h>
#include <qcheckbox.h>
#include <qheader.h>
#include <qlistview.h>
#include <qpushbutton.h>
#include <qstringlist.h> 

// include files for KDE
#include <klistbox.h>
#include <kdebug.h>
#include <klocale.h>

// application specific includes
#include "../DbObjects/kpgitemsfolder.h"
#include "../kpgutil.h"


KPGCreateTablespaceWidget2::KPGCreateTablespaceWidget2(QWidget *parent, const char *name, bool bGrantOrRevoke)
 : KPGCreateTablespaceWidget2Base(parent, name)
{
  m_bGrantOrRevoke = bGrantOrRevoke;
  
  if(bGrantOrRevoke)
  {
    strGR = strGR + "GRANT ";
    strTF = strTF + " TO ";
    m_pCheckBoxCascade->hide();
  }
  else
  {
    strGR = "REVOKE ";
    strTF = " FROM ";
    m_pCheckBoxGrantOptions->setText(i18n("Only revoke &GRANT privilege"));
  }
  
  m_pListViewGrants->setSortColumn(-1);
}


KPGCreateTablespaceWidget2::~KPGCreateTablespaceWidget2()
{
}

void KPGCreateTablespaceWidget2::slotCheckBoxPublicToggled(bool bState)
{
  m_pListBoxUsersGroups->setEnabled(!bState);
  m_pCheckBoxGrantOptions->setEnabled(!bState); // Grant options can only be granted to individual users, not to groups or PUBLIC.
  enableAddGrantButton();
}

void KPGCreateTablespaceWidget2::slotGrantOptionsToggled(bool bState)
{
  m_pCheckBoxCascade->setEnabled(!m_bGrantOrRevoke && bState);
}

void KPGCreateTablespaceWidget2::slotListBoxUsersSelectionChanged()
{
  enableAddGrantButton();
}

void KPGCreateTablespaceWidget2::enableAddGrantButton()
{
  bool bAnyUserOrGroupChecked = false;        
  
  if(m_pCheckBoxPublic->isChecked()) 
    bAnyUserOrGroupChecked = true;
  else
    {
      if(m_pListBoxUsersGroups->count() > 0)
      {
        for(unsigned int i = 0; i <m_pListBoxUsersGroups->count(); i++)
        if(m_pListBoxUsersGroups->isSelected(i))
          {
            bAnyUserOrGroupChecked = true;
            break;
          }
      }
    }
  m_pPushButtonGrantAdd->setEnabled(bAnyUserOrGroupChecked);
}

/////////////////////////////////////////////////////////////////////
//                     COMMON FUNCTIONS
///////////////////////////////////////////////////////////////////// 

void KPGCreateTablespaceWidget2::slotGrantAdd()
{
  QListViewItem *pLastItem = 0;
  
  QListViewItem * pItem = m_pListViewGrants->firstChild();
  while(pItem)
  {
    pLastItem = pItem;
    pItem = pItem->nextSibling();
  }
  
  QStringList strListOfSQLs; // string list for SQL clauses GRANT ...
  
  QString strWGO((m_bGrantOrRevoke && m_pCheckBoxGrantOptions->isChecked()) ? " WITH GRANT OPTION" : "");
  QString strGOF((!m_bGrantOrRevoke && m_pCheckBoxGrantOptions->isChecked()) ? "GRANT OPTION FOR " : "");
  QString strC((!m_bGrantOrRevoke && m_pCheckBoxCascade->isChecked()) ? " CASCADE" : "");
  
  if(m_pCheckBoxPublic->isChecked())
  {
    strListOfSQLs.append(strGR + "CREATE ON TABLESPACE " + KPGUtil::quotedName(m_strTablespaceName) + strTF + "PUBLIC");
  }
  else
  {
    for(unsigned int i = 0; i < m_pListBoxUsersGroups->count(); i++)
    {
      if(m_pListBoxUsersGroups->isSelected(i))
      {
        QListBoxItem * pLbItem = m_pListBoxUsersGroups->item(i);
        
        if(pLbItem->rtti() != RTTI_KPGLISTBOXITEM)
        {
          kdError() << k_funcinfo << " Bad object type !" << endl;
          return;
        }
        
        KPGListBoxItem *pListBoxItem = static_cast <KPGListBoxItem *> (pLbItem);        
               
                
        if(pListBoxItem->type() == KPGTreeItem::nodeGroup)
          strListOfSQLs.append(strGR + "CREATE ON TABLESPACE " + KPGUtil::quotedName(m_strTablespaceName) + strTF + "GROUP " + pListBoxItem->text());
        else
          strListOfSQLs.append(strGR + strGOF + "CREATE ON TABLESPACE " + KPGUtil::quotedName(m_strTablespaceName) + strTF + pListBoxItem->text() + strWGO + strC);
        
      }
    }
  }
      
  // Create items for new grants
  for ( QStringList::Iterator it = strListOfSQLs.begin(); it != strListOfSQLs.end(); ++it ) 
  {
    QString strSQL(*it);
    QListViewItem *pNewItem;
    
    if(pLastItem == 0) 
      pNewItem = new QListViewItem(m_pListViewGrants, strSQL);
    else
      pLastItem = pNewItem = new QListViewItem(m_pListViewGrants, pLastItem, strSQL); 
  }
  
  emit sigEnableNextButton(true);
}

void KPGCreateTablespaceWidget2::slotGrantDelete()
{
  QListViewItem *pSelectedItem = m_pListViewGrants->selectedItem();
  if(pSelectedItem)
      delete pSelectedItem;
      
  if(m_pListViewGrants->childCount() == 0)
     emit sigEnableNextButton(false);
  
  m_pPushButtonGrantDel->setEnabled(false);
  
  enableAddGrantButton();
}

void KPGCreateTablespaceWidget2::slotGrantsSelectionChanged(QListViewItem* pItem)
{
  m_pPushButtonGrantDel->setEnabled(pItem != 0);
}

void KPGCreateTablespaceWidget2::slotGrantsCurrentChanged(QListViewItem* pItem)
{
  m_pPushButtonGrantDel->setEnabled(pItem != 0);
}

// Return part of SQL statement for GRANT CREATE
const QString KPGCreateTablespaceWidget2::getSQL() const
{
  QString strSQL;
  
  QListViewItem * pItem = m_pListViewGrants->firstChild();
  while(pItem)
  {
    strSQL.append(pItem->text(0));
    strSQL.append(";\n");
            
    pItem = pItem->nextSibling();
  }
  
  return strSQL;
}

#include "kpgcreatetablespacewidget2.moc"
