//
// C++ Interface: %{MODULE}
//
// Description: 
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KONSOLEVIEWWIDGET_H
#define KONSOLEVIEWWIDGET_H

#include <qwidget.h>
#include <qstring.h>
#include <qstrlist.h>

#include <kurl.h>

/**
  * Widget that display Konsole using KParts
  *
  * @author Lumir Vanek
  */
namespace KParts 
{
  class ReadOnlyPart;
  class Part;
  class PartManager; 
}

class QVBoxLayout;
class ExtTerminalInterface;
class KProcess;

class KonsoleViewWidget : public QWidget
{
    Q_OBJECT
public:
    KonsoleViewWidget(KParts::PartManager *, QWidget *);
    virtual ~KonsoleViewWidget();

    virtual void show();
    
    void startProgram(const QString &, const QStrList &);
    
public slots:
    void setDirectory(const KURL &dirUrl);
    void activePartChanged(KParts::Part *activatedPart);
        
protected slots:
    void slotProcessExited(KProcess *);
    void slotPartDestroyed();
        
signals:     
    void sigProcessExited();
    
private:
    void activate();

    KParts::ReadOnlyPart *m_pConcolePart;
    ExtTerminalInterface *m_pTerminalInterface;
    
    QVBoxLayout *vbox;
    KParts::PartManager *m_pPartManager;
};

#endif
