//
// C++ Implementation: kpgviewproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgviewproppage.h"

// include files for Qt
#include <qiconset.h>
#include <qtable.h>  

// include files for KDE
#include <ktabwidget.h>
#include <kiconloader.h>
#include <kpushbutton.h>
#include <klistview.h>
#include <klineedit.h>
#include <kpushbutton.h>
#include <kdebug.h>
#include <ktextedit.h>
#include <klocale.h>

// application specific includes
#include "../kpglinklabel.h"
#include "../QueryResult/kpgsyntaxhighlighter.h"
#include "../kpogreview.h"
#include "../kpgconfiguration.h"
#include "../QueryResult/kpgsqleditorsettings.h"
#include "../DbObjects/kpgview.h"
#include "../DbObjects/kpgschema.h"
#include "../kpgutil.h"


KPGViewPropPage::KPGViewPropPage(QWidget *parent, KPGView * pView)
 : KPGViewPropPageBase(parent, "KPGViewPropPage")
{
	m_pView = pView;
  	m_pSyntaxHighlighter = new KPGSyntaxHighlighter(m_pTextEditDefinition);
	
	// Apply current configuration
	slotSqlEditorSettingsChanged();
 	// and make sure to be informed about its changes.
	connect( KPoGreView::configuration()->sqleditor(), SIGNAL(sigChanged()), this, SLOT(slotSqlEditorSettingsChanged()) );
  
  	m_pTabWidget->setTabIconSet(tabACL, QIconSet(QPixmap(UserIcon("group")))); 
  	
  	displayProperties();
}


KPGViewPropPage::~KPGViewPropPage()
{
	disconnect( KPoGreView::configuration()->sqleditor(), SIGNAL(sigChanged()), this, SLOT(slotSqlEditorSettingsChanged()) );
  
  	delete m_pSyntaxHighlighter;
}

void KPGViewPropPage::displayProperties()
{
	QHeader* pHeader = m_pTableProperties->horizontalHeader();

  	pHeader->setLabel(0, i18n("Name"));
	pHeader->setLabel(1, i18n("Value"));
	pHeader->setLabel(2, i18n("Description"));
	
	int iRow = 0;
  	
	//--- OID
	m_pTableProperties->setText(iRow, 0, i18n("OID"));
  	m_pTableProperties->setText(iRow, 1, QString("%1").arg(m_pView->oid()));
	m_pTableProperties->setText(iRow++, 2, i18n("PostgreSQL row identifier"));
	
	//--- Name
	m_pTableProperties->setText(iRow, 0, i18n("Name"));
  	m_pTableProperties->setText(iRow, 1, m_pView->text(0));
	m_pTableProperties->setText(iRow++, 2, i18n("Name of the view"));
	
	//--- Description
	m_pTableProperties->setText(iRow, 0, i18n("Description"));
  	m_pTableProperties->setText(iRow, 1, m_pView->description());
	m_pTableProperties->setText(iRow++, 2, i18n("Description of the view"));
	
	//--- Owner
	m_pTableProperties->setText(iRow, 0, i18n("Owner"));
  	m_pTableProperties->setText(iRow, 1, m_pView->owner());
	m_pTableProperties->setText(iRow++, 2, i18n("Owner of the view"));
	
	//--- ACL
	setACL(m_pView->acl());
				
	for(int nCol = 0; nCol < 3; nCol++)
	{
		m_pTableProperties->adjustColumn(nCol);
	}
	
	m_pTextEditDefinition->setText(m_pView->definition());
}

void KPGViewPropPage::slotSqlEditorSettingsChanged()
{
    m_pTextEditDefinition->setFont( KPoGreView::configuration()->sqleditor()->font() );
	
    m_pSyntaxHighlighter->setColorDefaultText( KPoGreView::configuration()->sqleditor()->colorDefaultText() );
	m_pSyntaxHighlighter->setColorKeyWords( KPoGreView::configuration()->sqleditor()->colorKeyWords() );
	m_pSyntaxHighlighter->setColorDataTypes( KPoGreView::configuration()->sqleditor()->colorDataTypes() );
	m_pSyntaxHighlighter->setColorOperators( KPoGreView::configuration()->sqleditor()->colorOperators() );
	m_pSyntaxHighlighter->setColorQuotedStrings( KPoGreView::configuration()->sqleditor()->colorQuotedStrings() );
	m_pSyntaxHighlighter->setColorNumbers( KPoGreView::configuration()->sqleditor()->colorNumbers() );
    m_pSyntaxHighlighter->setColorComments( KPoGreView::configuration()->sqleditor()->colorComments() );
	
	m_pSyntaxHighlighter->rehighlight();
}

void KPGViewPropPage::slotTablePropDblClicked(int iRow, int iCol, int /*iButton*/, const QPoint & /*ptMousePos*/)
{
    QWidget *w = m_pTableProperties->cellWidget(iRow, iCol);
	if(w == 0)
		return;
					
	KPGLinkLabel *pLabel = static_cast <KPGLinkLabel *> (w);
	pqxx::oid _oid = pLabel->oid();
			
	if(_oid != 0)
		emit sigSearchObject(_oid);
}


void KPGViewPropPage::setACL(const QString &strACL)
{
	m_pListViewACL->clear();
	m_listOfAclItems.clear();
	m_pLineEditACL->setText(strACL);
	
	QString strAclItem; // string for one ACL item, e.g. miriam=arwdRxt/miriam
	for(unsigned int i = 0; i < strACL.length(); i++)
	{
		if(strACL[i] == '{')
		continue;
		
		if((strACL[i] == ',') || (strACL[i] == ','))
		{
		m_listOfAclItems.append(KPGAclItem(strAclItem)); // create new ACL item
		strAclItem.truncate(0); // clear ACL string
		}
		else
		{
		strAclItem.append(strACL[i]);
		}
	}
	
	if(!strAclItem.isEmpty())
		m_listOfAclItems.append(KPGAclItem(strAclItem)); // create new ACL item
	
	// Traverse list of ACL items
	KPGAclItemList::iterator it;
	for ( it = m_listOfAclItems.begin(); it != m_listOfAclItems.end(); ++it )
	{   
		QListViewItem * pItem = new QListViewItem( m_pListViewACL, 0 );
		(*it).setListViewItem(pItem);
		
		pItem->setText( 0, (*it).grantee() );
		pItem->setText( 1, (*it).grantor() );
		
		pItem->setPixmap(2, UserIcon((*it).canSelect() ? "box_checked" : "box_clear"));
		pItem->setPixmap(3, UserIcon((*it).canInsert() ? "box_checked" : "box_clear"));
		pItem->setPixmap(4, UserIcon((*it).canUpdate() ? "box_checked" : "box_clear"));
		pItem->setPixmap(5, UserIcon((*it).canDelete() ? "box_checked" : "box_clear"));
		pItem->setPixmap(6, UserIcon((*it).canCreateRule() ? "box_checked" : "box_clear"));
		pItem->setPixmap(7, UserIcon((*it).canCreateReference() ? "box_checked" : "box_clear"));
		pItem->setPixmap(8, UserIcon((*it).canCreateTrigger() ? "box_checked" : "box_clear"));
		
		if((*it).canPassGrantToOther())
		{  
		pItem->setPixmap(9, UserIcon((*it).canGrantSelect() ? "box_checked" : "box_clear"));
		pItem->setPixmap(10, UserIcon((*it).canGrantInsert() ? "box_checked" : "box_clear"));
		pItem->setPixmap(11, UserIcon((*it).canGrantUpdate() ? "box_checked" : "box_clear"));
		pItem->setPixmap(12, UserIcon((*it).canGrantDelete() ? "box_checked" : "box_clear"));
		pItem->setPixmap(13, UserIcon((*it).canGrantCreateRule() ? "box_checked" : "box_clear"));
		pItem->setPixmap(14, UserIcon((*it).canGrantCreateReference() ? "box_checked" : "box_clear"));
		pItem->setPixmap(15, UserIcon((*it).canGrantCreateTrigger() ? "box_checked" : "box_clear")); 
		}
	} 
}

void KPGViewPropPage::slotAclListViewClicked(QListViewItem *pItem, const QPoint &, int iColumn)
{
	// Find KPGAclItem using pItem value
	KPGAclItemList::iterator it;
	for ( it = m_listOfAclItems.begin(); it != m_listOfAclItems.end(); ++it )
	{   
		if(pItem == (*it).getListViewItem())
		{
		// found ...
		
		switch(iColumn)
		{
			case 0:
			case 1: // do nothing on first 2 columns
				break;
			
			case 2:
				pItem->setPixmap(2, UserIcon((*it).toggleSelect() ? "box_checked" : "box_clear"));
				break;
		
			case 3:
				pItem->setPixmap(3, UserIcon((*it).toggleInsert() ? "box_checked" : "box_clear"));
				break;
				
			case 4:
				pItem->setPixmap(4, UserIcon((*it).toggleUpdate() ? "box_checked" : "box_clear"));
				break;
				
			case 5:
				pItem->setPixmap(5, UserIcon((*it).toggleDelete() ? "box_checked" : "box_clear"));
				break;
				
			case 6:
				pItem->setPixmap(6, UserIcon((*it).toggleCreateRule() ? "box_checked" : "box_clear"));
				break;         
				
			case 7:
				pItem->setPixmap(7, UserIcon((*it).toggleCreateReference() ? "box_checked" : "box_clear"));
				break;
				
			case 8:
				pItem->setPixmap(8, UserIcon((*it).toggleCreateTrigger() ? "box_checked" : "box_clear"));
				break;
						
			case 9:
				if((*it).canPassGrantToOther())
				pItem->setPixmap(9, UserIcon((*it).toggleGrantSelect() ? "box_checked" : "box_clear"));
				
				break;
				
			case 10:
				if((*it).canPassGrantToOther())
				pItem->setPixmap(10, UserIcon((*it).toggleGrantInsert() ? "box_checked" : "box_clear"));
				
				break;
				
			case 11:
				if((*it).canPassGrantToOther())
				pItem->setPixmap(11, UserIcon((*it).toggleGrantUpdate() ? "box_checked" : "box_clear"));
				
				break;
				
			case 12:
				if((*it).canPassGrantToOther())
				pItem->setPixmap(12, UserIcon((*it).toggleGrantDelete() ? "box_checked" : "box_clear"));
				
				break;
				
			case 13:
				if((*it).canPassGrantToOther())
				pItem->setPixmap(13, UserIcon((*it).toggleGrantCreateRule() ? "box_checked" : "box_clear"));
				
				break;         
				
			case 14:
				if((*it).canPassGrantToOther())
				pItem->setPixmap(14, UserIcon((*it).toggleGrantCreateReference() ? "box_checked" : "box_clear"));
				
				break;
				
			case 15:
				if((*it).canPassGrantToOther())
				pItem->setPixmap(15, UserIcon((*it).toggleGrantCreateTrigger() ? "box_checked" : "box_clear"));
				
				break;    
				
			default:
					kdError() << k_funcinfo << " Unexpected column !" << endl;
					break;      
		}
		
			m_pPushButtonUpdateACL->setEnabled(true);
			return;
		}
	}
}

void KPGViewPropPage::slotUpdateACL()
{
	QString strSQL;
	
	KPGSchema *pSchema = static_cast <KPGSchema *> (m_pView->parent()->parent());
		
	// Traverse all items and get their SQL's
	KPGAclItemList::iterator it;
	for ( it = m_listOfAclItems.begin(); it != m_listOfAclItems.end(); ++it )
	{   
		strSQL.append((*it).getSQL("TABLE " + KPGUtil::fullyQualifiedName(pSchema->text(0), m_pView->text(0))));
	}
	
	if(!strSQL.isEmpty())
		emit sigRunWizard(strSQL);
}

// Consumes request for context menu for property table
void KPGViewPropPage::slotTablePropContextMenuRequested(int row, int col, const QPoint & pos)
{
	emit sigTablePropContextMenuRequested(row, col, pos);	
}

#include "kpgviewproppage.moc"
