//
// C++ Implementation: kpgtriggerproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgtriggerproppage.h"

#include <qtable.h> 

// include files for KDE
#include <kdebug.h>
#include <klocale.h>

#include "../kpglinklabel.h"
#include "../DbObjects/kpgtrigger.h"
#include "../kpgutil.h"
#include "../kpglinklabel.h"


KPGTriggerPropPage::KPGTriggerPropPage(QWidget *parent, KPGTrigger * pTrigger)
 : KPGTriggerPropPageBase(parent, "KPGTriggerPropPage")
{
	m_pTrigger = pTrigger;
	displayProperties();
}


KPGTriggerPropPage::~KPGTriggerPropPage()
{
}

void KPGTriggerPropPage::displayProperties()
{
	QHeader* pHeader = m_pTableProperties->horizontalHeader();

  	pHeader->setLabel(0, i18n("Name"));
	pHeader->setLabel(1, i18n("Value"));
	pHeader->setLabel(2, i18n("Description"));
	
	int iRow = 0;
  	
	//--- OID
	m_pTableProperties->setText(iRow, 0, i18n("OID"));
  	m_pTableProperties->setText(iRow, 1, QString("%1").arg(m_pTrigger->oid()));
	m_pTableProperties->setText(iRow++, 2, i18n("PostgreSQL row identifier"));
	
	//--- Name
	m_pTableProperties->setText(iRow, 0, i18n("Name"));
  	m_pTableProperties->setText(iRow, 1, m_pTrigger->text(0));
	m_pTableProperties->setText(iRow++, 2, i18n("Trigger name (must be unique among triggers of same table)"));
	
	//--- Description
	m_pTableProperties->setText(iRow, 0, i18n("Description"));
  	m_pTableProperties->setText(iRow, 1, m_pTrigger->description());
	m_pTableProperties->setText(iRow++, 2, i18n("Description of the trigger"));
		
	//--- Is Enabled
	m_pTableProperties->setText(iRow, 0, i18n("Is Enabled"));
  	m_pTableProperties->setText(iRow, 1, m_pTrigger->enabled()); // TODO 8.3 changed !
	m_pTableProperties->setText(iRow++, 2, i18n("True if trigger is enabled (not presently checked everywhere it should be, so disabling a trigger by setting this false does not work reliably)"));
	
	//--- Is Deferrable
	m_pTableProperties->setText(iRow, 0, i18n("Is Deferrable"));
  	m_pTableProperties->setPixmap(iRow, 1, (m_pTrigger->isDeferrable()) ? i18n("True") : i18n("False"));
	m_pTableProperties->setText(iRow++, 2, i18n("True if deferrable"));
	
	//--- Is Is initially Deferred
	m_pTableProperties->setText(iRow, 0, i18n("Is initially Deferred"));
 	m_pTableProperties->setPixmap(iRow, 1, (m_pTrigger->isInitiallyDeferred()) ? i18n("True") : i18n("False"));
	m_pTableProperties->setText(iRow++, 2, i18n("True if initially deferred"));
	
	//--- Number of argument
	m_pTableProperties->setText(iRow, 0, i18n("Number of arguments"));
  	m_pTableProperties->setText(iRow, 1, QString("%1").arg(m_pTrigger->numArguments()));
	m_pTableProperties->setText(iRow++, 2, i18n("Number of argument strings passed to trigger function"));
	
	//--- Arguments
	m_pTableProperties->setText(iRow, 0, i18n("Arguments"));
  	m_pTableProperties->setText(iRow, 1, m_pTrigger->arguments());
	m_pTableProperties->setText(iRow++, 2, i18n("Argument strings to pass to trigger, each null-terminated"));
	
	//--- Namespace
	m_pTableProperties->setText(iRow, 0, i18n("Namespace"));
  	m_pTableProperties->setText(iRow, 1, m_pTrigger->nameSpace());
	m_pTableProperties->setText(iRow++, 2, i18n("Name of the namespace"));
	
	//--- Procedure name
	m_pTableProperties->setText(iRow, 0, i18n("Procedure name"));
  	KPGLinkLabel *pLabel = new KPGLinkLabel( m_pTableProperties, "Procedure name" );
	pLabel->setValues(m_pTrigger->oidProcedure(), m_pTrigger->procName());
	m_pTableProperties->setCellWidget(iRow, 1, pLabel);
	m_pTableProperties->setText(iRow++, 2, i18n("Name of the trigger procedure, to be called"));
	
	for(int nCol = 0; nCol < 3; nCol++)
	{
		m_pTableProperties->adjustColumn(nCol);
	}
}

void KPGTriggerPropPage::slotTablePropDblClicked(int iRow, int iCol, int /*iButton*/, const QPoint & /*ptMousePos*/)
{
    QWidget *w = m_pTableProperties->cellWidget(iRow, iCol);
	if(w == 0)
		return;
					
	KPGLinkLabel *pLabel = static_cast <KPGLinkLabel *> (w);
	pqxx::oid _oid = pLabel->oid();
			
	if(_oid != 0)
		emit sigSearchObject(_oid);
}

// Consumes request for context menu for property table
void KPGTriggerPropPage::slotTablePropContextMenuRequested(int row, int col, const QPoint & pos)
{
	emit sigTablePropContextMenuRequested(row, col, pos);	
}

#include "kpgtriggerproppage.moc"
