//
// C++ Interface: kpgprimarykeyconstrproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGPRIMARYKEYCONSTRPROPPAGE_H
#define KPGPRIMARYKEYCONSTRPROPPAGE_H

#include "kpgprimarykeyconstrproppagebase.h"

// application specific includes
#include "kpgabstractpropertypage.h"

// include files for libpgxx 
#include <pqxx/util> 

class KPGPrimaryKeyConstr;

/**
  * Primary Key Constraint properties
  *
  * @author Lumir Vanek
  */
class KPGPrimaryKeyConstrPropPage : public KPGPrimaryKeyConstrPropPageBase, public KPGAbstractPropertyPage
{
	Q_OBJECT
public:
    KPGPrimaryKeyConstrPropPage(QWidget *, KPGPrimaryKeyConstr *);
    ~KPGPrimaryKeyConstrPropPage();

	// Display properties of underlying database object
	virtual void displayProperties();
	
	// Return Result table for clipboard actions and export. 
	virtual QTable* tableResult() { return m_pTableProperties; }
	
protected:

	KPGPrimaryKeyConstr * m_pPrimaryKeyConstr;
	
protected slots:	
            
	// Consumes request for context menu for property table
	virtual void slotTablePropContextMenuRequested(int, int, const QPoint &);    
	
signals:
	void sigSearchObject(pqxx::oid);
	            
    // Emit request for context menu for property table
	void sigTablePropContextMenuRequested(int, int, const QPoint &);
};

#endif
