//
// C++ Implementation: kpgdomainsfolderproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgdomainsfolderproppage.h"


#include <qtable.h>

#include <klocale.h>

#include "../kpgutil.h"
#include "../DbObjects/kpgdomainsfolder.h"
#include "../DbObjects/kpgconnection.h"

KPGDomainsFolderPropPage::KPGDomainsFolderPropPage(QWidget *pParent, KPGDomainsFolder *pDomainsFolder)
 : KPGPropertyPage(pParent, "KPGDomainsFolderPropPage")
{
	m_pDomainsFolder = pDomainsFolder;
	displayProperties();
}

KPGDomainsFolderPropPage::~KPGDomainsFolderPropPage()
{
}

void KPGDomainsFolderPropPage::displayProperties()
{
	QHeader* pHeader = m_pTableItems->horizontalHeader();

  	int nCol = 0;
	pHeader->setLabel(nCol++, i18n("Name"));
  	pHeader->setLabel(nCol++, i18n("Description"));
	pHeader->setLabel(nCol++, i18n("Base type"));
  	pHeader->setLabel(nCol++, i18n("Type length"));
	pHeader->setLabel(nCol++, i18n("Not null"));
	pHeader->setLabel(nCol++, i18n("Default value"));
	pHeader->setLabel(nCol++, i18n("Dimensions"));
	pHeader->setLabel(nCol++, i18n("Array delimiter"));
	pHeader->setLabel(nCol++, i18n("Owner"));
	
	QTextCodec * pTextCodec = m_pDomainsFolder->connection()->textCodec();
	
    KPGUtil::fillPropertiesTable(m_pDomainsFolder->resultDomains(), m_pTableItems, pTextCodec);
}
