//
// C++ Implementation: kpgdatatablechildview
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgdatatablechildview.h"

#include <qlayout.h>

#include <kiconloader.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kdebug.h>

// application specific includes
//#include "../DbObjects/kpgconnection.h"
#include "../DbObjects/kpgtable.h"
#include "../kpogreview.h"
#include "kpgdatatable.h"
#include "kpgkatexmleditordialog.h"

KPGDataTableChildView::KPGDataTableChildView(KPoGreView *pPoGreView, 
	KXMLGUIFactory *pXmlGuiFactory,
 	const PGSTD::string& strConnectionOptions,
	const QString & strNamespace,
	const QString & strTableName,
	const ListTableColumns & listTableColumns,
	const MapIndexKey & mapIndexKey,
	const QString &strWherePredicate,
	const QString & strOrderByPredicate,
	KPGKateXmlEditorDialog *pKateXmlEditorDialog)
 : KMdiChildView(strTableName, pPoGreView, "KPGDataTableChildView")
{
	m_pPoGreView = pPoGreView;
	m_pDataTable = new KPGDataTable(this, 
		pPoGreView,
		pXmlGuiFactory,
  		strConnectionOptions,
		strNamespace, 
		strTableName, 
		listTableColumns,
		mapIndexKey,
		strWherePredicate, 
		strOrderByPredicate,
		pKateXmlEditorDialog);
	
	m_pLayout = new QHBoxLayout(this, 0, -1, "layout" );
	m_pLayout->addWidget( m_pDataTable, 0, 0 );
	
	setIcon(SmallIcon("data"));
}

KPGDataTableChildView::~KPGDataTableChildView()
{
}

// Add DataTableChildView GUI client to factory
void KPGDataTableChildView::slotActivated()
{
	m_pDataTable->addToGuiFactory();
}

// Remove DataTableChildView GUI client from factory
void KPGDataTableChildView::slotDeactivated()
{
	m_pDataTable->removeFromGuiFactory();
}

bool KPGDataTableChildView::requestClose()
{
	if(m_pDataTable->running())
	{
		KMessageBox::sorry(this, i18n("Reload query is running, cannot close !"));	 
		return false;
	}
	
	
	if(KMessageBox::questionYesNo(this, i18n("Really close data table window ?")) == KMessageBox::Yes) 
	{
		return true;
	}
	return false;
}

