/***************************************************************************
    Copyright (C) 2004 Christian Hubinger
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//
// C++ Implementation: kmfruleoptioneditiip
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kmfruletargetoptioneditnat.h"


// QT includes
#include <qstring.h>

// KDE includes
#include <kdebug.h>
#include <klocale.h>

// Project includes
#include "../../core/iptrule.h"
#include "../../core/kmfruleeditinterface.h"
#include "kmfruleeditortargetnat.h"

namespace KMF {
KMFRuleTargetOptionEditNat::KMFRuleTargetOptionEditNat(QObject *parent, const char *name)
		: KMFRuleTargetOptionEditInterface(parent, name) {
	kdDebug() <<"KMFRuleTargetOptionEditNat::KMFRuleTargetOptionEditNat(QObject *parent, const char *name)" << endl;
	
	m_managedTargets << "SNAT" << "DNAT";
	
	
	kdDebug() << "Parent has Type: " << parent->className()  << endl;
	
	m_edit = new KMFRuleEditorTargetNat( 0 , "Edit", 0 );
	m_edit->hide();

	connect( m_edit,SIGNAL(sigHideMe() ), 
		this,SLOT( slotShowOverview() ) );
}

KMFRuleTargetOptionEditNat::~KMFRuleTargetOptionEditNat() {}

void KMFRuleTargetOptionEditNat::slotShowOverview() {
	if ( KMFRuleEditInterface* ruleedit = dynamic_cast<KMFRuleEditInterface*> ( parent() ) ) {
		ruleedit->showOverview();
	} else {
		kdDebug() << "KMFRuleTargetOptionEditNat::slotShowOverview(): parent() not of type KMFRuleEditInterface" << endl;
	}
}


const QString& KMFRuleTargetOptionEditNat::optionEditName() const {
	return *( new QString( i18n("NAT Option") ) );
}
const QString& KMFRuleTargetOptionEditNat::description() const {
	return *( new QString( i18n("This plugin manages the NAT options of iptables.") ) );
}

void KMFRuleTargetOptionEditNat::loadRule( IPTRule* rule ) {
	if ( !rule ) {
		kdDebug() << "KMFRuleTargetOptionEditNat::loadRule( IPTRule* rule ) - rule == 0" << endl;
		return;
	}
	
	m_edit->loadRule( rule );
	m_rule = rule;

}

QWidget* KMFRuleTargetOptionEditNat::editWidget() {
	if ( ! m_edit ) {
		kdDebug() << "KMFRuleTargetOptionEditNat::editWidget() - m_edit == 0" << endl;
		return 0;
	}
	return m_edit;
}

bool KMFRuleTargetOptionEditNat::setTarget( const QString& target ){
	if ( ! manageTarget( target ) ) {
		return false;
	}
	if ( target == "SNAT") 
		m_edit->setMode( true );
	else 
		m_edit->setMode( false );
	return true;
}



// It's usually safe to leave the factory code alone.. with the
// notable exception of the KAboutData data
#include <kaboutdata.h>
#include <klocale.h>

// KInstance* KMFRuleTargetOptionEditNatFactory::s_instance = 0L;
// KAboutData* KMFRuleTargetOptionEditNatFactory::s_about = 0L;

KMFRuleTargetOptionEditNatFactory::KMFRuleTargetOptionEditNatFactory( QObject* parent, const char* name )
		: KLibFactory( parent, name ) {
// 	s_instance = new KInstance( "KMFRuleTargetOptionEditNatFactory" );
}

QObject* KMFRuleTargetOptionEditNatFactory::createObject( QObject* parent, const char* name,
        const char*, const QStringList & ) {
	QObject * obj = new KMFRuleTargetOptionEditNat( parent, name );
	emit objectCreated( obj );
	return obj;
}


// KInstance* KMFRuleTargetOptionEditNatFactory::instance() {
// 	if ( !s_instance ) {
// 		s_instance = new KInstance( "KMFRuleTargetOptionEditNatFactory" );
// 	}
// 	return s_instance;
// }

extern "C" {
	void* init_libkmfruletargetoptionedit_nat() {
		return new KMFRuleTargetOptionEditNatFactory;
	}
}

}


#include "kmfruletargetoptioneditnat.moc"
