/***************************************************************************
 begin                : Sun Jan 27 21:17:58 CET 2002
 copyright            : (C) 2002 by Christian Hubinger
 email                : chubinger@irrsinnig.org
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "kmyfirewall.h"

// QT includes
#include <qstring.h>
#include <qstringlist.h>
#include <qlistview.h>

// KDE includes

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>
#include <kconfig.h>
#include <kdebug.h>

// project inclues
#include "core/kmfapp.h"
#include "version.h"
#include "core/kmfconfig.h"

static const char description[] = I18N_NOOP( "KMyFirewall - IPTables configuration tool" );
 

static KCmdLineOptions options[] =
    {
        { "+[URL]", I18N_NOOP( "Files/URLs to Open." ), 0 },
	{ "i <interfacename>", I18N_NOOP("Select the interface to use at startup. Use 'iptables' for the iptables/netfilter interface or 'generic' for the generic GUI. By default the interface selection dialog is shown if the user did not specify to allways use one of the interfaces by default."), 0 },
	KCmdLineLastOption
    };

int main( int argc, char *argv[] ) {
	KAboutData aboutData( "kmyfirewall", I18N_NOOP( "KMyFirewall" ),
	                      KMYFIREWALL_VERSION, description, KAboutData::License_GPL,
	                      COPYRIGHT_STRING, 0, 0, "chubinger@irrsinnig.org" );
	aboutData.addAuthor( "Christian Hubinger", 0, "chubinger@irrsinnig.org" );
	aboutData.addCredit( "Benjamin Meyer", I18N_NOOP("A handful of fixes and code cleanup."),"ben+kmyfirewall@meyerhome.net");
	aboutData.addCredit( "Casper Planken", I18N_NOOP("Gave me some really good hints about how to do certain things"), "cplanken@chello.nl" );
	aboutData.addCredit( "Malcolm Hunter", I18N_NOOP("Spell Checking and making messages real English"), "malcolm.hunter@gmx.co.uk" );
	aboutData.addCredit( "Carsten Niehaus", I18N_NOOP("Part of the sanity checks, bugfixes"), "cniehaus@gmx.de" );
	aboutData.addCredit( "Christian Deschka", I18N_NOOP("Artwork"), "echos@lycos.at" );
	aboutData.addCredit( "Anton Frennevi", I18N_NOOP("Artwork"), "twopointone@hotmail.com" );
	aboutData.setHomepage( "http://kmyfirewall.sourceforge.net" );
	KCmdLineArgs::init( argc, argv, &aboutData );
	KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.

	KMF::KMFApp a;
	
	// Splash screen
	KMF::KMFConfig::self()->readConfig();
	if ( KMF::KMFConfig::showSplash() ) {
		KMF::showSplash();
	}
	
	KMF::KMyFirewall * kmyfirewall = new KMF::KMyFirewall;
	a.setMainWidget( kmyfirewall );
	kmyfirewall->show();
	
	KMF::closeSplash();



	return a.exec();

}
