//
// C++ Implementation: kmfchecklistitem
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "kmfchecklistitem.h"

// QT includes

// KDE includes
#include <kdebug.h>

// Project includes
#include "../core/netfilterobject.h"
#include "../core/kmfprotocol.h"
#include "../core/kmfprotocolusage.h"

namespace KMF {

KMFCheckListItem::KMFCheckListItem( QListView *parent, QListViewItem *after, const QString& text, Type tt, KMFProtocolUsage* obj ) : QCheckListItem( parent, after, text,  tt ) {
	loadKMFProtocolUsage( obj );
}
KMFCheckListItem::KMFCheckListItem( QListViewItem *parent, const QString& text , Type tt, KMFProtocolUsage* obj ) : QCheckListItem( parent, text,  tt ) {
	loadKMFProtocolUsage( obj );
}
KMFCheckListItem::KMFCheckListItem( QListViewItem *parent, QListViewItem *after, const QString& text, Type tt, KMFProtocolUsage* obj ) : QCheckListItem( parent, after, text,  tt ) {
	loadKMFProtocolUsage( obj );
}

KMFCheckListItem::~KMFCheckListItem() {}


void KMFCheckListItem::loadKMFProtocolUsage( KMFProtocolUsage* obj ) {
	if ( KMFProtocolUsage *prot = dynamic_cast<KMFProtocolUsage*> ( obj ) ) {
		m_protocolUsage = prot;
	} else {
		kdDebug() << "ERROR: Given NetfilterObject has wrong type" << endl;
	}
}

}

