//
//
// C++ Implementation: $MODULE$
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "kmfgenericinterface.h"

// qt includes
#include <qstring.h>
#include <qlayout.h>
#include <qtabwidget.h>

// kde includes
#include <klocale.h>
#include <kdebug.h>
#include <kglobal.h>
#include <kiconloader.h>


// project includes
#include "../core/kmfnetwork.h"
#include "../core/kmfgenericdoc.h"

#include "../kmfwidgets/kmfmynetworkwidget.h"
#include "kmfgenericinterfaceprotocol.h"
//#include "kmfgenericinterfaceeditprotocol.h"
#include "kmfgenericinterfacenat.h"
#include "kmfgenericinterfacehost.h"
#include "kmfgenericinterfacelogging.h"
#include "kmfgenericinterfaceicmp.h"

namespace KMF {

KMFGenericInterface::KMFGenericInterface( QWidget *parent, const char *name ) : KJanusWidget( parent, name,  KJanusWidget::IconList ) {
	connect( this,SIGNAL( aboutToShowPage( QWidget* ) ),
		this,SLOT( slotPageChanged( QWidget* ) ) );
	loadIcons();
	
	//###################### My Network Widget ###################################
	myNetworkFrame = addPage(i18n("My Network"), i18n("Define and configure the  firewall host you like to configure"), icon_zone_page );
	m_myNetworkWidget =  new KMFMyNetworkWidget( myNetworkFrame, "m_myNetworkWidget" );
	connect( this, SIGNAL( sigUpdateView() ),
		m_myNetworkWidget, SLOT( slotUpdateView() ) );
	connect( this, SIGNAL( sigUpdateView( NetfilterObject* ) ),
		m_myNetworkWidget, SLOT( slotUpdateView( NetfilterObject* ) ) );
	
	connect( m_myNetworkWidget, SIGNAL( sigActiveTargetChanged() ), this, SIGNAL( sigTargetChanged() ) );
	
	QGridLayout *myNetworkLayout = new QGridLayout( myNetworkFrame, 1, 1, 2, 2 );
	myNetworkLayout->addWidget( m_myNetworkWidget,0,0 );
	
	//###################### Access Control PAGE #################################
	protocolFrame = addPage(i18n("Access Control"), i18n("Access configuration for incoming and outgoing connections"), icon_protocol_page );

	m_protocolPageZones = new KMFGenericInterfaceProtocol( protocolFrame, "m_protocolPageIncoming");
	connect( this, SIGNAL( sigUpdateView() ),
		m_protocolPageZones, SLOT( slotUpdateView() ) );
	connect( this, SIGNAL( sigUpdateView( NetfilterObject* ) ),
		m_protocolPageZones, SLOT( slotUpdateView( NetfilterObject* ) ) );
	
	QGridLayout *protocoLayout = new QGridLayout( protocolFrame, 1, 1, 2, 2 );
	protocoLayout->addWidget( m_protocolPageZones,0,0 );

	//###################### HOSTS PAGE ###################################
	hostFrame = addPage(i18n("Special Hosts"), i18n("Define Hosts that should be treated specially."), icon_host_page );
	m_hostPage = new KMFGenericInterfaceHost(hostFrame,"m_hostPageTrusted");
	connect( this, SIGNAL( sigUpdateView() ),
		m_hostPage, SLOT( slotUpdateView() ) );
	connect( this, SIGNAL( sigUpdateView( NetfilterObject* ) ),
		m_hostPage, SLOT( slotUpdateView( NetfilterObject* ) ) );

	QGridLayout *hostLayout = new QGridLayout( hostFrame, 1, 1, 2, 2 );
	hostLayout->addWidget( m_hostPage,0,0 );

	//###################### ICMP PAGE #################################
	icmpFrame = addPage(i18n("ICMP Options"), i18n("Define how ICMP packets should be handled."), icon_icmp_page );
	QGridLayout *icmpLayout = new QGridLayout( icmpFrame, 1, 1, 2, 2 );
	m_icmpPage = new KMFGenericInterfaceIcmp(icmpFrame,"m_icmpPage");
	connect( this, SIGNAL( sigUpdateView() ),
		m_icmpPage, SLOT( slotUpdateView() ) );
	connect( this, SIGNAL( sigUpdateView( NetfilterObject* ) ),
		m_icmpPage, SLOT( slotUpdateView( NetfilterObject* ) ) );
	
	icmpLayout->addWidget( m_icmpPage,0,0 );


	//###################### NAT PAGE ###################################
	natFrame = addPage(i18n("NAT Configuration"), i18n("Configure NAT (Network Address Translation) here."), icon_nat_page );
	QGridLayout *natLayout = new QGridLayout( natFrame, 1, 1, 2, 2 );
	m_natPage = new KMFGenericInterfaceNat(natFrame,"m_natPage");
	connect( this, SIGNAL( sigUpdateView() ),
		m_natPage, SLOT( slotUpdateView() ) );
	connect( this, SIGNAL( sigUpdateView( NetfilterObject* ) ),
		m_natPage, SLOT( slotUpdateView( NetfilterObject* ) ) );
	
	natLayout->addWidget( m_natPage,0,0 );

	//###################### LOGGING PAGE ###################################
	logFrame = addPage(i18n("Logging"), i18n("Configure your firewall's logging behavior here."), icon_logging_page );
	QGridLayout *logLayout = new QGridLayout( logFrame, 1, 1, 2, 2 );
	m_loggingPage = new KMFGenericInterfaceLogging(logFrame,"m_loggingPage");
	connect( this, SIGNAL( sigUpdateView() ),
		m_loggingPage, SLOT( slotUpdateView() ) );
	connect( this, SIGNAL( sigUpdateView( NetfilterObject* ) ),
		m_loggingPage, SLOT( slotUpdateView( NetfilterObject* ) ) );
	
	logLayout->addWidget( m_loggingPage,0,0 );
	
	setEnabled( false );
}

KMFGenericInterface::~KMFGenericInterface() {}

void KMFGenericInterface::loadDoc( KMFNetwork* doc ) {
	kdDebug() << "void KMFGenericInterface::loadDoc( KMFGenericDoc* )" << endl;
	if ( ! doc ) {
		setEnabled( false );
		return;
	}
	setEnabled( true );
	m_network = doc;

	m_myNetworkWidget->setNetwork( m_network );
	m_myNetworkWidget->slotUpdateView();
	m_myNetworkWidget->parent();
	
	m_protocolPageZones->loadDoc( m_network );
	m_protocolPageZones->slotUpdateView();
	
	m_hostPage->loadDoc( m_network );
	m_hostPage->slotUpdateView();

// 	m_protocolPageEditProtocol->loadDoc( m_network );
// 	m_protocolPageEditProtocol->slotUpdateView();

	m_icmpPage->loadDoc( m_network );
	m_icmpPage->slotUpdateView();

	m_natPage->loadDoc( m_network );
	m_natPage->slotUpdateView();

	m_loggingPage->loadDoc( m_network );
	m_loggingPage->slotUpdateView();
}

/* 
void KMFGenericInterface::slotUpdateView( NetfilterObject* obj ) {
	kdDebug() << "KMFGenericInterface::slotUpdateView( NetfilterObject* )" << endl;
	if ( ! m_network ) {
			setEnabled( false );
			return;
		}
		m_myNetworkWidget->slotUpdateView( obj );

		m_protocolPageZones->slotUpdateView( obj );

		m_hostPage->slotUpdateView( obj );

		m_icmpPage->slotUpdateView( obj );

		m_natPage->slotUpdateView( obj );

		m_loggingPage->slotUpdateView( obj );
}

void KMFGenericInterface::slotUpdateView() {
		if ( ! m_network ) {
			setEnabled( false );
			return;
		}
		m_myNetworkWidget->slotUpdateView();

		m_protocolPageZones->slotUpdateView();

		m_hostPage->slotUpdateView();

		m_icmpPage->slotUpdateView();

		m_natPage->slotUpdateView();

		m_loggingPage->slotUpdateView();
}
*/

void KMFGenericInterface::slotPageChanged( QWidget* /*wid*/ ){
	kdDebug() << "KMFGenericInterface::slotPageChanged( QWidget* )" << endl;
	emit sigUpdateView();
	// slotUpdateView();
}

void KMFGenericInterface::loadIcons() {
	kdDebug() << "void KMFGenericInterface::loadIcons()" << endl;
	KIconLoader *loader = KGlobal:: iconLoader();
	QString icon_name;

	icon_name = "network";
	icon_zone_page = loader->loadIcon( icon_name, KIcon::Desktop );

	icon_name = "services";
	icon_protocol_page = loader->loadIcon( icon_name, KIcon::Desktop );

	icon_name = "nfs_unmount";
	icon_edit_protocol_page = loader->loadIcon( icon_name, KIcon::Desktop );

	icon_name = "pipe";
	icon_icmp_page = loader->loadIcon( icon_name, KIcon::Desktop );

	icon_name = "log";
	icon_logging_page = loader->loadIcon( icon_name, KIcon::Desktop );

	icon_name = "network_local";
	icon_host_page = loader->loadIcon( icon_name, KIcon::Desktop );

	icon_name = "filesaveas";
	icon_nat_page = loader->loadIcon( icon_name, KIcon::Desktop );
}

}

#include "kmfgenericinterface.moc"
