#!/bin/bash


clean() {
	echo -n "Delete old build..."
	rm -rf $BUILDDIR
	echo "Done."
	
	echo -n "Create $BUILDDIR..."
	mkdir $BUILDDIR
	echo "Done."
}

checkout() {
	echo "Do SVN checkout from $SVNURL..."
	svn co $SVNURL
	echo "Done."

}

linkadmin() {
	echo -n "Link admin dir...$ADMIN"
	ln -s $ADMIN .
	echo "Done."
}


cleanbuild() {
	echo "Make Clean..."
	$MAKE clean
	echo "Done."
}

build() {
	echo "Start build..."
	$MAKE -f admin/Makefile.common && \
		./configure $CONFIG_OPTIONS && \
	time $MAKE $MAKE_ARGS
	echo "Done."
}

BUILDDIR="../check_svn_build_buildDir"
MAKE="unsermake"
MAKE_ARGS="-j3"
CONFIG_OPTIONS="--prefix=/usr --enable-debug=no "
SVNURL="https://svn.kde.org/home/kde/branches/extragear/kde3/network/kmyfirewall/"
ADMIN="../../kde-common/admin/"

echo "Usage: check_svn_config.sh"

clean
cd $BUILDDIR
checkout
cd kmyfirewall/
linkadmin
cleanbuild
build

	

	
	
	
	
	
	
	
	
	
	
	
	
	
	

