/***************************************************************************
                          contactaddeduserdialog.cpp  -  description
                             -------------------
    begin                : Sun Apr 14 2002
    copyright            : (C) 2002 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "contactaddeduserdialog.h"
#include "../model/contactlist.h"
#include "../contact/group.h"
#include "../currentaccount.h"
#include "../kmessdebug.h"
#include "../utils/kmessconfig.h"



/**
 * Constructor
 *
 * The dialog is instantly shown as modal when the class is instantiated.
 *
 * @param contactHandle         Reference to the handle of the contact that has added you
 * @param contactFriendlyName   The friendly name of the contact
 */
ContactAddedUserDialog::ContactAddedUserDialog( const QString &contactHandle, const QString &contactFriendlyName )
  : KDialog()
  , Ui::ContactAddedUserDialog()
  , contactHandle_( contactHandle )
{
  // Load the ui file in a main qwidget
  setObjectName( "ContactAddedUser" );
  QWidget *mainWidget = new QWidget( this );
  setupUi( mainWidget );

  setMainWidget( mainWidget );

  // Let the dialog destroy itself when it's done
  setAttribute( Qt::WA_DeleteOnClose );

  //adjust or restore saved size
  adjustSize();
  restoreDialogSize( KMessConfig::instance()->getGlobalConfig( "ContactAddedUserDialog" ) );

  // Update the window properties
  setCaption( i18n( "You have been added by someone" ) );

  // Set up the label
  if( contactHandle == contactFriendlyName )
  {
    messageLabel_->setText( i18n( "%1\nhas added you to his or her contact list."
                                  , contactHandle ) );
  }
  else
  {
    messageLabel_->setText( i18n( "%1 (%2)\nhas added you to his or her contact list."
                                  , contactFriendlyName
                                  , contactHandle ) );
  }

  // Fill up the groups list from the contactlist data
  QList<Group*> groupList( CurrentAccount::instance()->getContactList()->getGroupList() );
  QListWidgetItem *item;

  foreach( const Group *group, groupList )
    {
      if( ! group->isSpecialGroup() )
      {
        item = new QListWidgetItem( group->getName(), groupList_ );

        // Set the groupId in the item's data, to retrieve it later
        item->setData( Qt::UserRole, group->getId() );
        item->setFlags( Qt::ItemIsUserCheckable | Qt::ItemIsEnabled );
        item->setCheckState( Qt::Unchecked );
      }
    }
}


/**
* @brief Destructor
*
*/
ContactAddedUserDialog::~ContactAddedUserDialog()
{
  KConfigGroup group = KMessConfig::instance()->getGlobalConfig( "ContactAddedUserDialog" );
  saveDialogSize( group );
}



/**
* @brief Called when the user pressed the "ok" button
*
*/
void ContactAddedUserDialog::accept()
{
  QStringList groupIds;

  if( addContactOption_->isChecked() )
  {
    // Find all checked items in the list
    QListWidgetItem *item;
    for( int i = 0; i < groupList_->count(); i++ )
    {
      item = groupList_->item( i );
      if( item->checkState() == Qt::Checked )
      {
        // Retrieve the group id from the item's data
        groupIds.append( item->data( Qt::UserRole ).toString() );
      }
    }

    emit userChoice( contactHandle_, groupIds, ADD );
  }
  else if( allowContactOption_->isChecked() )
  {
    emit userChoice( contactHandle_, groupIds, ALLOW );
  }
  else
  {
    emit userChoice( contactHandle_, groupIds, BLOCK );
  }

  // Call parent
  KDialog::accept();
}



/**
* @brief Called when the user pressed the "cancel" button
*
*/
void ContactAddedUserDialog::reject()
{
  // No choice for the moment, the question will be asked the next time

  // Call parent
  KDialog::reject();
}


#include "contactaddeduserdialog.moc"

