/***************************************************************************
 *   Copyright (C) 2004 by Alessandro Bonometti                            *
 *   bauno@bauniga.baita                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "hlistviewitem.h"
#include "newsgroup.h"
#include <qpainter.h>
#include <klocale.h>
/*
static const char *patterns[] = { "\\d+\\.(?:avi|mpg|mpeg|wmv)",  //.nn.avi
	"(?:avi|mpg|mpeg|wmv)\\.\\d+)",  //.avi.nn
	"(?:\\.r\\d+|\\.rar|\\.part\\d+\\.rar)",    //.rnn, .part01.rar, .rar
	"(?:\\.PAR|\\.P\\d+)", //PAR, P01, etc
	"(?:\\.par2|\\vol\\d+\\+\\d+\\.par2)", //.par2, .volnn+nnn-par2
	"(?:\\.nfo | \\.diz | \\.jpe?g| \\.bmp | \\.txt\\b)", //.nfo, .diz, bmp, etc...
	"\0"
};*/

GListViewItem::GListViewItem( KListView* p, BHListViewItem *bhl, bool hf, bool hd) : KListViewItem(p), haveFrom(hf), haveDate(hd)
{
	subject = bhl->getSubject();
	from = bhl->getFrom();
	size = 0;
	if (haveDate) {
		dt = bhl->getDate();
		//qdt=new QDateTime(QDateTime::fromString(bhl->getDate()));
	} else dt = 0;
	setText(Subj_Col, subject);
	setPixmap(Subj_Col,BarIcon("text_block", KIcon::SizeSmall));
	setText(Bytes_Col, QString::number(size));
	parts = 0;
	setText(Parts_Col, QString::number(parts));
	prevItems = new KListViewItem(this, i18n("Previews"));
	postItems = new KListViewItem(this, prevItems, i18n("Data"));
	parItems = new KListViewItem(this, postItems, i18n("Pars"));
	setExpandable(true);
	
	
	
	
}

BHListViewItem::BHListViewItem( KListView *parent, SmallBinHeader *sbh, Db *_db, bool hf, bool hd, QMap< int, NntpHost * > *_servers )  : KListViewItem(parent), db(_db), servers(_servers), haveFrom(hf), haveDate(hd)
{
	subject=sbh->subj;
	from=sbh->from;
	if (haveDate) {
		dt = sbh->tDate;
// 		qdt=new QDateTime(QDateTime::fromString(sbh->date));
	} else dt=0;
	status=sbh->status;
	if (sbh->missingParts == 0) {
		lineColor=Qt::black;
		ok=true;
		setText(Parts_Col, "*/" + QString::number(sbh->parts));
		setPixmap(1,BarIcon("icon_binary_complete", KIcon::SizeSmall));
	} else {
		lineColor=Qt::red;
		ok=false;
		// 		
		setText(Parts_Col, QString::number(sbh->parts - sbh->missingParts) + "/" + QString::number(sbh->parts));
// 		setPixmap(0,BarIcon("button_cancel", KIcon::SizeSmall));
		setPixmap(Parts_Col,BarIcon("icon_binary_incomplete", KIcon::SizeSmall));
	}
	setText(Subj_Col, sbh->subj);
	setText(Bytes_Col, QString::number((sbh->size)/1024));
	colCount=MAN_COL+haveFrom+haveDate;
	
	if (haveFrom)
		setText(MAN_COL, from);
	if (haveDate) {
		QDateTime qdt;
		qdt.setTime_t(dt);
		setText(colCount-1, qdt.toString());
		//setText(colCount-1, sbh->date);
// 		kdDebug() << "Have date in col: "<< colCount-1 << " " << sbh->date << endl;
	}
	
	if (servers != NULL) {
		QMap<int, NntpHost*>::iterator it;
		int i =0;
		for (it=servers->begin(); it != servers->end(); ++it) {
			if (sbh->serverParts.contains(it.key())) {
				if (sbh->serverParts[it.key()]==sbh->parts)
					setPixmap(colCount+i, BarIcon("button_ok", KIcon::SizeSmall));
				else setText(colCount+i, QString::number(sbh->serverParts[it.key()]));;
			} else setPixmap(colCount+i, BarIcon("button_cancel", KIcon::SizeSmall));
			++i;
				
		}
	}
	setExpandable(true);
	
}


BHListViewItem::BHListViewItem( KListView *parent, BinHeader *bh, Db *_db, bool hf, bool hd, QMap< int, NntpHost * > *_servers) : KListViewItem(parent), db(_db), servers(_servers), haveFrom(hf), haveDate(hd)
{
	subject=bh->getSubj();
	from=bh->getFrom();
	
	if (haveDate) {
		dt = bh->getDate();
		//qdt=new QDateTime(QDateTime::fromString(bh->getDate()));
	}else dt=0;
	
	status=bh->getStatus();
	
	if (bh->isCompleted()) {
		lineColor=Qt::black;
		ok=true;

		setText(Parts_Col, "*/" + QString::number(bh->getParts()));
		setPixmap(1,BarIcon("icon_binary_complete", KIcon::SizeSmall));

		
	}
	else {
		lineColor=Qt::red;
		ok=false;
		// 		
		setText(Parts_Col, QString::number(bh->getParts()-bh->getMissingParts()) + "/" + QString::number(bh->getParts()));
// 		setPixmap(0,BarIcon("button_cancel", KIcon::SizeSmall));
		setPixmap(Parts_Col,BarIcon("icon_binary_incomplete", KIcon::SizeSmall));
	}
	setText(Subj_Col, bh->getSubj());
	
	setText(Bytes_Col, QString::number(bh->getSize()/1024));
	
	//colCount is the first FREE column...(replaces Num_Col)
	//MAN_COL is the first FREE column after mandatory columns
	colCount=MAN_COL+haveFrom+haveDate;
	
	//From (if exist) is always immediately after the "mandatory" columns
	if (haveFrom)
		setText(MAN_COL, from);
	if (haveDate) {
		QDateTime qdt;
		qdt.setTime_t(bh->getDate());
		setText(colCount-1, qdt.toString());
// 		setText(colCount-1, bh->getDate());
	}
	if (servers != NULL) {
		QMap<int, NntpHost*>::iterator it;
		int i =0;
		for (it=servers->begin(); it != servers->end(); ++it) {
			if (bh->serverPart.contains(it.key())) {
				if (bh->serverPart[it.key()]==bh->getParts())
					setPixmap(colCount+i, BarIcon("button_ok", KIcon::SizeSmall));
				else setText(colCount+i, QString::number(bh->serverPart[it.key()]));;
			} else setPixmap(colCount+i, BarIcon("button_cancel", KIcon::SizeSmall));
			++i;
				
		}
	}
	setExpandable(true);
	
}



BHListViewItem::BHListViewItem(KListView *parent, BinHeader *bh, Db *_db, QMap<int, NntpHost*> *_servers) :KListViewItem(parent), db(_db), servers(_servers)
{
	

	subject=bh->getSubj();
	from=bh->getFrom();

	dt = bh->getDate();
	//qdt=new QDateTime(QDateTime::fromString(bh->getDate()));
	status=bh->getStatus();
	
			

	if (bh->isCompleted()) {
		lineColor=Qt::black;
		ok=true;

		setText(Parts_Col, "*/" + QString::number(bh->getParts()));
		setPixmap(1,BarIcon("icon_binary_complete", KIcon::SizeSmall));

		
	}
	else {
		lineColor=Qt::red;
		ok=false;
// 		
		setText(1, QString::number(bh->getParts()-bh->getMissingParts()) + "/" + QString::number(bh->getParts()));
// 		setPixmap(0,BarIcon("button_cancel", KIcon::SizeSmall));
		setPixmap(1,BarIcon("icon_binary_incomplete", KIcon::SizeSmall));
	}
	
	//Keep???
// 	setExpandable(TRUE);
	
	setText(Subj_Col, bh->getSubj());
	
	setText(Bytes_Col, QString::number(bh->getSize()/1024));

// 	setText(Lines_Col, QString::number(bh->getLines()));
// 	setText(From_Col, bh->getFrom());
// 	setText(Date_Col, bh->getDate());
	QDateTime qdt;
	qdt.setTime_t(bh->getDate());
	setText(Date_Col, qdt.toString());

	QMap<int, NntpHost*>::iterator it;
	int i =0;
	for (it=servers->begin(); it != servers->end(); ++it) {
		if (bh->serverPart.contains(it.key())) {
			if (bh->serverPart[it.key()]==bh->getParts())
				setPixmap(Num_Col+i, BarIcon("button_ok", KIcon::SizeSmall));
			else setText(Num_Col+i, QString::number(bh->serverPart[it.key()]));;
		} else setPixmap(Num_Col+i, BarIcon("button_cancel", KIcon::SizeSmall));
		++i;
			
	}
	
	


}



void BHListViewItem::paintCell( QPainter * p, const QColorGroup & cg, int column, int width, int alignment )
{
	QColorGroup _cg( cg );


   _cg.setColor( QColorGroup::Text, lineColor);


    KListViewItem::paintCell( p, _cg, column, width, alignment );
	if (status==BinHeader::bh_new)
		setPixmap(Subj_Col, BarIcon("icon_article_new", KIcon::SizeSmall));
	else if (status==BinHeader::bh_read)
		setPixmap(Subj_Col, BarIcon("icon_article_read", KIcon::SizeSmall));
	else if (status==BinHeader::bh_downloaded)
		setPixmap(Subj_Col, BarIcon("icon_binary", KIcon::SizeSmall));

	
	
}

BHListViewItem::~ BHListViewItem( )
{
// 	if (qdt)
// 		delete qdt;
}

void BHListViewItem::setOpen( bool o )
{
	
	uint ret;
	// Build the key
// 	QString index = text(Subj_Col)+text(From_Col);
	QString index = subject + from;
	
	
	
			
	if (o && !childCount()) {
		Dbt key;
    	Dbt data;
		memset(&key, 0, sizeof(key));
		memset(&data, 0, sizeof(data));
    	data.set_flags(DB_DBT_MALLOC);
		const char *k= (const char *)index;
		key.set_data((void*)k);
		key.set_size(index.length());
    	
		ret=db->get(NULL, &key, &data, 0);
		if (ret == 0) { //key found
			BinHeader *bh=new BinHeader((uchar*)data.get_data());
			free(data.get_data());
			uint pad=1;
			uint temp=bh->getParts();
			// calculate the pad;
			while( temp >= 10) {
				pad++; 
				temp/=10;
			}
			
			
			for (bh->pnmit=bh->partNum.begin(); bh->pnmit != bh->partNum.end(); ++(bh->pnmit) ) {
				
// 				temp=bh->pnmit.key();
				
				QString s=QString::number(bh->pnmit.key()).rightJustify(pad,'0');
// 				qDebug("part: %s", (const char *)s);
				/* 
				int i=0;	
				while (temp >= 10) { 
					i++; 
					
					temp/=10; 
				}
				
// 				qDebug("Part: %d, article pad: %d, post pad: %d", temp, i, pad);
				
				for (uint j =0;  j < pad-i; j++) 
					s.prepend('0');
				
				*/
				KListViewItem *temp;
				temp=new KListViewItem(this, bh->getSubj(), s + "/" + QString::number(bh->getParts()), 
									   QString::number(bh->partSize[bh->pnmit.key()]/1024));
				
				if (haveFrom)
					temp->setText(MAN_COL, bh->getFrom());
				if (haveDate) {
					QDateTime qdt;
					qdt.setTime_t(bh->getDate());
					temp->setText(colCount -1, qdt.toString());
// 					temp->setText(colCount-1, bh->getDate());
				}
				temp->setSelectable(false);
// 				qDebug("Part size: %d", bh->partSize[bh->pnmit.key()]);
				// Examine per-server parts...
				
// 				servers::iterator it;
				QMap<int, NntpHost*>::iterator it;
				
				int i=0;
				if (servers != NULL) {
					for (it=servers->begin(); it != servers->end(); ++it) {
						if (bh->pnmit.data().contains(it.data()->id))
							temp->setPixmap(colCount+i, BarIcon("button_ok", KIcon::SizeSmall));
						else temp->setPixmap(colCount+i, BarIcon("button_cancel", KIcon::SizeSmall));
						++i;
					}
				}
				
				/*
				for (int i =0; i < 3 ; i++) {  //This sucks, too...
					if (bh->pnmit.data().contains(i+1))
// 						temp->setText(5+i, "O");
						temp->setPixmap(6+i, BarIcon("button_ok", KIcon::SizeSmall));
					else temp->setPixmap(6+i, BarIcon("button_cancel", KIcon::SizeSmall));// temp->setText(5+i, "X");
				}
				*/		
				
			}
				
		} else { //Error: whats happened?
			qDebug("Error retieving key: %d",ret);
			qDebug("Key: %s", (const char *) index);
			qDebug("Size: %d", key.get_size());
			
			
			o=false;
		}
		
		
	} 
	
	QListViewItem::setOpen(o);
}


BHListViewItem::BHListViewItem(KListView *parent, BinHeader *bh) : KListViewItem(parent, bh->getSubj(), QString::number(bh->getSize()), QString::number(bh->getLines())) 
{
	if (bh->isCompleted()) {
		lineColor=Qt::black;
		ok=true;
	}
	else {
		lineColor=Qt::red;
		ok=false;
		
	}
	setExpandable(TRUE);
		
}

int BHListViewItem::compare( QListViewItem * i, int col, bool ascending ) const
{	
	
	
// 	if (col == Date_Col) {
	if (haveDate && col == colCount-1) {
		if (dt < ((BHListViewItem*)i)->dt)
			return 1;
		else if (dt > ((BHListViewItem*)i)->dt)
			return -1;
		else return 0;
	} else if ( col == Bytes_Col ) {
		
		if ( text(col).toInt() < i->text(col).toInt())
			return -1;
		else if (text(col).toInt() > i->text(col).toInt())
			return 1;
		else return 0;
	} else return KListViewItem::compare(i, col, ascending);
	
}

void NGListViewItem::paintCell( QPainter * p, const QColorGroup & cg, int column, int width, int alignment )
{
	QFont f=p->font();
	if (ng->unreadArticles != 0) {
		//Draw bold text
		f.setBold(true);
		p->setFont(f);
	} else {
		f.setBold(false);
		p->setFont(f);
	}
	KListViewItem::paintCell( p, cg, column, width, alignment );
		
}

NGListViewItem::NGListViewItem(KListView *parent, NewsGroup * _ng) : KListViewItem(parent, _ng->getAlias() , QString::number(_ng->unreadArticles), QString::number( _ng->totalArticles)) , ng(_ng)
{ 
	setPixmap(0, BarIcon("icon_newsgroup", KIcon::SizeSmall));
}

NGListViewItem::NGListViewItem( KListViewItem *parent, NewsGroup *_ng ) : KListViewItem(parent, _ng->getAlias() , QString::number(_ng->unreadArticles), QString::number( _ng->totalArticles)) , ng(_ng)
{
	setPixmap(0, BarIcon("icon_newsgroup", KIcon::SizeSmall));
}


TListViewItem::TListViewItem( int q, int t, QListViewItem * p, QListViewItem *last ) : KListViewItem(p, last, "Thread #" + QString::number(t), "Disconnected")
{
	
	qId=q;
	threadId=t;
	
}

int TListViewItem::rtti( ) const
{
	//List is etherogeneous, or something similar :)
	return TITEM;
}

int NGListViewItem::rtti( ) const
{
	return GITEM;
}




void GListViewItem::addPart( BHListViewItem * bhl )
{
	///@todo identify the part type
	
	//Add the part - for now just add it to the "data" branch
	postItems->insertItem(bhl);
	size+=bhl->getSize();
	parts+=1;
	setText(Parts_Col, QString::number(parts));
	setText(Bytes_Col, QString::number(size));
	
	
}

bool BHListViewItem::operator ==(BHListViewItem *bhl )
{
	return (getSubject() == bhl->getSubject());
}

bool BHListViewItem::operator <( BHListViewItem * bhl )
{
	return (getSubject() < bhl->getSubject());
}







