/***************************************************************************
 *   Copyright (C) 2004 by Leonid Zeitlin                                  *
 *   lz@europe.com                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "windowclasswatcher.h"
#include "kbconfig.h"

#include <kwinmodule.h>
#include <kdebug.h>

#include <X11/Xutil.h>

WindowClassWatcher::WindowClassWatcher(KBConfig *kbconf, QObject *parent, const char *name)
 : WindowWatcher(kbconf, parent, name)
{
  reset();
}

WindowClassWatcher::~WindowClassWatcher()
{
}

QString WindowClassWatcher::getWindowClass(WId id)
{
  XClassHint hint;
  QString ret = QString::null;
  
  if (XGetClassHint(qt_xdisplay(), id, &hint)) {
    ret = hint.res_class;
    XFree(hint.res_name);
    XFree(hint.res_class);
  }
  return ret;
}

void WindowClassWatcher::windowAdded(WId id)
{
  QString wclass = getWindowClass(id);
  KBClassInfo &info = m_class_group_map[wclass];
  if (info.refcount == 0) {
    // new class
    info.groupno = m_kbconf->default_groupno();
    info.next_groupno = m_kbconf->getNextGroup(m_kbconf->default_groupno());
  }
  info.refcount++;
  m_win_class_map.insert(id, wclass);
}

void WindowClassWatcher::windowRemoved(WId id)
{
  ClassGroupMap::Iterator iter = m_class_group_map.find(m_win_class_map[id]);
  if (iter != m_class_group_map.end()) {
    iter.data().refcount--;
    if (iter.data().refcount <= 0) m_class_group_map.remove(iter);
  }  
  m_win_class_map.remove(id);
}

void WindowClassWatcher::activeWindowChanged(WId id)
{
  if (id == 0) return; // no window is active
  m_active_class = m_class_group_map.find(m_win_class_map[id]);
  if (m_active_class != m_class_group_map.end()) 
    emit windowChanged(m_active_class.data().groupno, m_active_class.data().next_groupno);
}

void WindowClassWatcher::changeGroup(int groupno, int next_groupno)
{
  if (m_active_class != m_class_group_map.end()) {
    m_active_class.data().groupno = groupno;
    m_active_class.data().next_groupno = next_groupno;
  }
}

void WindowClassWatcher::reset()
{
  m_win_class_map.clear();
  m_class_group_map.clear();

  // fill the map with existing windows  
  const QValueList<WId> windows = m_kwin_module->windows();
  const QValueList<WId>::ConstIterator end = windows.end();
  for (QValueList<WId>::ConstIterator it = windows.begin(); it != end; ++it)
     windowAdded(*it);
  
  WId active_window = m_kwin_module->activeWindow();
  if (active_window) 
    m_active_class = m_class_group_map.find(m_win_class_map[active_window]);
  else m_active_class = m_class_group_map.end();
}

