/***************************************************************************
 *   Copyright (C) 2005 by KesieV   *
 *   kesiev@hotmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kitty_feededit.h"
#include "kitty_feedmodel.h"
#include <kdialogbase.h>
#include <qlineedit.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qtextedit.h>
#include <klocale.h>
#include <kmessagebox.h>

kitty_feededit::kitty_feededit( QWidget *parent, const QString& caption,const t_feed& feed)
   : KDialogBase( parent, "urldialog", true, caption,
                  KDialogBase::Ok|KDialogBase::Cancel, KDialogBase::Ok, true )
{
   editfeed=feed;
   
QWidget *page = new QWidget( this );
   setMainWidget(page);
   QVBoxLayout *topLayout = new QVBoxLayout( page, 0, spacingHint() );

   QLabel *label = new QLabel( i18n("Feed title"), page);
   topLayout->addWidget( label );

   title = new QLineEdit( editfeed.title, page );
   topLayout->addWidget( title );

   label = new QLabel( i18n("Author"), page);
   topLayout->addWidget( label );

   author = new QLineEdit( editfeed.author, page );
   topLayout->addWidget( author );

   label = new QLabel( i18n("Feed description"), page);
   topLayout->addWidget( label );

   description = new QTextEdit( editfeed.description,"", page);
   topLayout->addWidget( description );

   topLayout->addStretch(10);	
   changed=false;
}


void kitty_feededit::slotOk() {
	changed=true;
	editfeed.description=description->text();
	editfeed.title=title->text();
	editfeed.author=author->text();
	close();
}

kitty_feededit::~kitty_feededit()
{
}


#include "kitty_feededit.moc"
