/* This file is part of the Keep project
   Copyright (C) 2006 Jean-Rémy Falleri <jr.falleri@laposte.net>

   Keep is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   Keep is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Keep; if not, write to the
   Free Software Foundation, Inc.,
   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           */

#ifndef _RDBMANAGER_H_
#define _RDBMANAGER_H_

#include <qvaluelist.h>
#include <qobject.h>
#include <qdatetime.h>

#include "backupconfig.h"
#include "rdblistener.h"

class RDBManager: public QObject
{
Q_OBJECT
public:
	RDBManager();
	~RDBManager();

	QValueList<QDateTime> incrementList(Backup backup);
	QValueList<Backup> outdatedBackupList();
	QDateTime lastIncrement(Backup backup);
	
	QString compareAtTime(Backup backup, QDateTime date);
	QString listChangedSince(Backup backup, QDateTime date);
	QString listAtTime(Backup backup, QDateTime date);

	bool isRDB();
	QString RDBVersion();

public slots:
	void slotCheckBackup();
	void slotForceBackup(QValueList<Backup> backupList);
	void slotRestoreBackup(Backup backup,QDateTime time);

signals:
	void backupError(Backup backup,QString errorMessage);
	void backupSuccess(Backup backup);

private:
	void doBackup(Backup backup);
	void removeOldIncrements(Backup backup);
	KProcess * RDBProcess(bool isNice=false,int niceLevel=0);
};

#endif
